/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.scenario.animation.shared.TimelineClipCore;
import java.util.Arrays;
import java.util.Comparator;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.util.Duration;

public final class Timeline
extends Animation {
    final TimelineClipCore clipCore;
    private final ObservableList<KeyFrame> keyFrames = new TrackableObservableList<KeyFrame>(){

        @Override
        protected void onChanged(ListChangeListener.Change<KeyFrame> change) {
            while (change.next()) {
                String string;
                if (change.wasPermutated()) continue;
                for (KeyFrame keyFrame : change.getRemoved()) {
                    string = keyFrame.getName();
                    if (string == null) continue;
                    Timeline.this.getCuePoints().remove(string);
                }
                for (KeyFrame keyFrame : change.getAddedSubList()) {
                    string = keyFrame.getName();
                    if (string == null) continue;
                    Timeline.this.getCuePoints().put(string, keyFrame.getTime());
                }
                Timeline.this.updateKeyFrames();
            }
        }
    };
    private static final Comparator<KeyFrame> KEY_FRAME_COMPARATOR = new Comparator<KeyFrame>(){

        @Override
        public int compare(KeyFrame keyFrame, KeyFrame keyFrame2) {
            return keyFrame.getTime().compareTo(keyFrame2.getTime());
        }
    };

    public final ObservableList<KeyFrame> getKeyFrames() {
        return this.keyFrames;
    }

    public Timeline(double d, KeyFrame ... keyFrameArray) {
        super(d);
        this.clipCore = new TimelineClipCore(this);
        this.getKeyFrames().setAll((KeyFrame[])keyFrameArray);
    }

    public Timeline(KeyFrame ... keyFrameArray) {
        this.clipCore = new TimelineClipCore(this);
        this.getKeyFrames().setAll((KeyFrame[])keyFrameArray);
    }

    public Timeline(double d) {
        super(d);
        this.clipCore = new TimelineClipCore(this);
    }

    public Timeline() {
        this.clipCore = new TimelineClipCore(this);
    }

    Timeline(TimelineClipCore timelineClipCore) {
        this.clipCore = timelineClipCore;
    }

    private void updateKeyFrames() {
        KeyFrame[] keyFrameArray = new KeyFrame[this.getKeyFrames().size()];
        this.keyFrames.toArray(keyFrameArray);
        Arrays.sort(keyFrameArray, KEY_FRAME_COMPARATOR);
        Duration duration = keyFrameArray.length == 0 ? Duration.ZERO : keyFrameArray[keyFrameArray.length - 1].getTime();
        this.setCycleDuration(duration);
        this.clipCore.setKeyFrames(keyFrameArray);
    }

    @Override
    @Deprecated
    public void impl_playTo(long l, long l2) {
        this.clipCore.playTo(l);
    }

    @Override
    @Deprecated
    public void impl_jumpTo(long l, long l2) {
        this.clipCore.jumpTo(l);
    }

    @Override
    @Deprecated
    public void impl_setCurrentRate(double d) {
        super.impl_setCurrentRate(d);
        this.clipCore.notifyCurrentRateChanged();
    }

    @Override
    void impl_start(boolean bl) {
        super.impl_start(bl);
        this.clipCore.start(bl);
    }

    @Override
    public void stop() {
        if (this.getStatus() == Animation.Status.RUNNING) {
            this.clipCore.abort();
        }
        super.stop();
    }
}

