/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.javafx.animation.transition.AnimationPathHelper;
import com.sun.javafx.animation.transition.Position2D;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.transform.BaseTransform;
import javafx.animation.Transition;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

public final class PathTransition
extends Transition {
    private ObjectProperty<Node> node;
    private static final Node DEFAULT_NODE = null;
    private Node cachedNode;
    private ObjectProperty<Duration> duration;
    private static final Duration DEFAULT_DURATION = Duration.millis(400.0);
    private ObjectProperty<Shape> path;
    private static final Shape DEFAULT_PATH = null;
    private ObjectProperty<OrientationType> orientation;
    private static final OrientationType DEFAULT_ORIENTATION = OrientationType.NONE;
    private boolean cachedIsNormalRequired;
    private final Position2D posResult = new Position2D();
    private AnimationPathHelper apHelper;

    public final void setNode(Node node) {
        if (this.node != null || node != null) {
            this.nodeProperty().set(node);
        }
    }

    public final Node getNode() {
        return this.node == null ? DEFAULT_NODE : (Node)this.node.get();
    }

    public final ObjectProperty<Node> nodeProperty() {
        if (this.node == null) {
            this.node = new SimpleObjectProperty<Node>(this, "node", DEFAULT_NODE);
        }
        return this.node;
    }

    public final void setDuration(Duration duration) {
        if (this.duration != null || !DEFAULT_DURATION.equals(duration)) {
            this.durationProperty().set(duration);
        }
    }

    public final Duration getDuration() {
        return this.duration == null ? DEFAULT_DURATION : (Duration)this.duration.get();
    }

    public final ObjectProperty<Duration> durationProperty() {
        if (this.duration == null) {
            this.duration = new ObjectPropertyBase<Duration>(DEFAULT_DURATION){

                @Override
                public void invalidated() {
                    PathTransition.this.setCycleDuration(PathTransition.this.getDuration());
                }

                @Override
                public Object getBean() {
                    return PathTransition.this;
                }

                @Override
                public String getName() {
                    return "duration";
                }
            };
        }
        return this.duration;
    }

    public final void setPath(Shape shape) {
        if (this.path != null || shape != null) {
            this.pathProperty().set(shape);
        }
    }

    public final Shape getPath() {
        return this.path == null ? DEFAULT_PATH : (Shape)this.path.get();
    }

    public final ObjectProperty<Shape> pathProperty() {
        if (this.path == null) {
            this.path = new SimpleObjectProperty<Shape>(this, "path", DEFAULT_PATH);
        }
        return this.path;
    }

    public final void setOrientation(OrientationType orientationType) {
        if (this.orientation != null || !DEFAULT_ORIENTATION.equals((Object)orientationType)) {
            this.orientationProperty().set(orientationType);
        }
    }

    public final OrientationType getOrientation() {
        return this.orientation == null ? OrientationType.NONE : (OrientationType)((Object)this.orientation.get());
    }

    public final ObjectProperty<OrientationType> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new SimpleObjectProperty<OrientationType>(this, "orientation", DEFAULT_ORIENTATION);
        }
        return this.orientation;
    }

    public PathTransition(Duration duration, Shape shape, Node node) {
        this.setDuration(duration);
        this.setPath(shape);
        this.setNode(node);
        this.setCycleDuration(duration);
    }

    public PathTransition(Duration duration, Shape shape) {
        this(duration, shape, null);
    }

    public PathTransition() {
        this(DEFAULT_DURATION, null, null);
    }

    @Override
    public void interpolate(double d) {
        this.apHelper.getPosition2D(d, this.cachedIsNormalRequired, this.posResult);
        this.cachedNode.setTranslateX(this.posResult.x - this.cachedNode.impl_getPivotX());
        this.cachedNode.setTranslateY(this.posResult.y - this.cachedNode.impl_getPivotY());
        if (this.cachedIsNormalRequired) {
            this.cachedNode.setRotate(this.posResult.rotateAngle);
        }
    }

    private Node getTargetNode() {
        Node node = this.getNode();
        return node != null ? node : this.getParentTargetNode();
    }

    @Override
    boolean impl_startable(boolean bl) {
        return super.impl_startable(bl) && (this.getTargetNode() != null && this.getPath() != null && !this.getPath().getLayoutBounds().isEmpty() || !bl && this.cachedNode != null && this.apHelper != null);
    }

    @Override
    void impl_sync(boolean bl) {
        super.impl_sync(bl);
        if (bl || this.cachedNode == null) {
            this.cachedNode = this.getTargetNode();
            Shape shape = this.getPath();
            Path2D path2D = new Path2D(shape.impl_configShape());
            BaseTransform baseTransform = shape.impl_getLeafTransform();
            this.apHelper = new AnimationPathHelper(path2D, baseTransform, 1.0);
            this.cachedIsNormalRequired = this.getOrientation() == OrientationType.ORTHOGONAL_TO_TANGENT;
        }
    }

    public static enum OrientationType {
        NONE,
        ORTHOGONAL_TO_TANGENT;

    }
}

