/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.launch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.internal.valgrind.launch.Messages;
import org.eclipse.linuxtools.internal.valgrind.launch.ValgrindLaunchConfigurationDelegate;
import org.eclipse.linuxtools.internal.valgrind.launch.ValgrindLaunchPlugin;
import org.eclipse.linuxtools.profiling.launch.ConfigUtils;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class ValgrindRemoteProxyLaunchDelegate
extends ValgrindLaunchConfigurationDelegate {
    private static final String VALGRIND_CMD = "valgrind";
    private ConfigUtils configUtils;
    private static final String VERSION_OPT = "--version";
    private static final String VERSION_PREFIX = "valgrind-";
    private static final char VERSION_DELIMITER = '-';
    private static final Version MIN_VER = ValgrindLaunchPlugin.VER_3_3_0;

    private String whichVersion(IProject project) {
        String[] cmdArray = new String[]{VALGRIND_CMD, VERSION_OPT};
        try {
            Process p = RuntimeProcessFactory.getFactory().exec(cmdArray, project);
            BufferedReader stdout = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String commandOutput = stdout.readLine();
            stdout.close();
            return commandOutput;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private Version getValgrindVersion(IProject project) throws CoreException {
        String verString = this.whichVersion(project);
        if (verString == null || verString.equals("")) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.valgrind.launch", Messages.getString("ValgrindLaunchPlugin.Couldn't_determine_version")));
        }
        if ((verString = verString.replace(VERSION_PREFIX, "")).indexOf(45) > 0) {
            verString = verString.substring(0, verString.indexOf(45));
        }
        if (verString.length() <= 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.valgrind.launch", Messages.getString("ValgrindLaunchPlugin.Couldn't_determine_version")));
        }
        Version valgrindVersion = Version.parseVersion((String)verString);
        if (valgrindVersion.compareTo(MIN_VER) < 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.linuxtools.valgrind.launch", NLS.bind((String)Messages.getString("ValgrindLaunchPlugin.Error_min_version"), (Object)valgrindVersion.toString(), (Object)MIN_VER.toString())));
        }
        return valgrindVersion;
    }

    /*
     * Exception decompiling
     */
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor m) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String createLaunchStr(IPath valgrindPath) throws CoreException {
        String projectName = this.configUtils.getProjectName();
        IProject project = ConfigUtils.getProject((String)projectName);
        URI projectURI = project.getLocationURI();
        String host = projectURI.getHost();
        if (host == null) {
            host = projectURI.getAuthority();
        }
        String location = host == null ? "remote host" : String.valueOf(projectURI.getScheme()) + "://" + host;
        return String.valueOf(this.config.getName()) + " [" + this.getPlugin().getToolName(this.toolID) + "]" + " " + valgrindPath.toString() + " on " + location;
    }

    protected String getPluginID() {
        return "org.eclipse.linuxtools.valgrind.launch";
    }

    public void onError(Throwable t) {
    }
}

