/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.twiki.core.block;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class ListBlock
extends Block {
    static final Pattern startPattern = Pattern.compile("((?: {3})+)(\\*|(?:1|a|A|i|I)\\.)\\s(.*+)");
    static final Pattern continuationPattern = Pattern.compile(" {3}\\s*(.*+)");
    private int blockLineCount = 0;
    private Matcher matcher;
    private Stack<ListState> listState;

    public int processLineContent(String line, int offset) {
        boolean continuation = false;
        if (this.blockLineCount == 0) {
            this.listState = new Stack();
            Attributes attributes = new Attributes();
            String listSpec = this.matcher.group(1);
            int level = this.calculateLevel(listSpec);
            String typeSpec = this.matcher.group(2);
            DocumentBuilder.BlockType type = this.calculateType(typeSpec);
            this.computeAttributes(attributes, type, typeSpec);
            offset = this.matcher.start(3);
            this.listState.push(new ListState(1, type));
            this.builder.beginBlock(type, attributes);
            this.adjustLevel(type, listSpec, level);
        } else {
            Matcher matcher = startPattern.matcher(line);
            if (!matcher.matches()) {
                matcher = continuationPattern.matcher(line);
                if (this.listState.isEmpty() || !matcher.matches()) {
                    this.setClosed(true);
                    return 0;
                }
                continuation = true;
                offset = matcher.start(1) - 1;
            } else {
                String listSpec = matcher.group(1);
                int level = this.calculateLevel(listSpec);
                String typeSpec = matcher.group(2);
                DocumentBuilder.BlockType type = this.calculateType(typeSpec);
                offset = matcher.start(3);
                this.adjustLevel(type, typeSpec, level);
            }
        }
        ++this.blockLineCount;
        ListState listState = this.listState.peek();
        if (!continuation && listState.openItem) {
            this.builder.endBlock();
            listState.openItem = false;
        }
        if (!listState.openItem) {
            listState.openItem = true;
            this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        }
        this.markupLanguage.emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    private void computeAttributes(Attributes attributes, DocumentBuilder.BlockType type, String typeSpec) {
        if (type == DocumentBuilder.BlockType.NUMERIC_LIST) {
            switch (typeSpec.charAt(0)) {
                case 'a': {
                    attributes.setCssStyle("list-style: lower-alpha;");
                    break;
                }
                case 'A': {
                    attributes.setCssStyle("list-style: upper-alpha;");
                    break;
                }
                case 'i': {
                    attributes.setCssStyle("list-style: lower-roman;");
                    break;
                }
                case 'I': {
                    attributes.setCssStyle("list-style: upper-roman;");
                }
            }
        }
    }

    private void adjustLevel(DocumentBuilder.BlockType type, String typeSpec, int level) {
        ListState previousState = this.listState.peek();
        while (level != previousState.level || previousState.type != type) {
            Attributes blockAttributes;
            if (level > previousState.level) {
                if (!previousState.openItem) {
                    this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
                    previousState.openItem = true;
                }
                blockAttributes = new Attributes();
                this.computeAttributes(blockAttributes, type, typeSpec);
                this.listState.push(new ListState(previousState.level + 1, type));
                this.builder.beginBlock(type, blockAttributes);
            } else {
                this.closeOne();
                if (this.listState.isEmpty()) {
                    blockAttributes = new Attributes();
                    this.computeAttributes(blockAttributes, type, typeSpec);
                    this.listState.push(new ListState(1, type));
                    this.builder.beginBlock(type, blockAttributes);
                }
            }
            previousState = this.listState.peek();
        }
    }

    private int calculateLevel(String listSpec) {
        return listSpec.length() / 3;
    }

    private DocumentBuilder.BlockType calculateType(String listSpec) {
        return listSpec.charAt(listSpec.length() - 1) == '*' ? DocumentBuilder.BlockType.BULLETED_LIST : DocumentBuilder.BlockType.NUMERIC_LIST;
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        this.listState = null;
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            while (this.listState != null && !this.listState.isEmpty()) {
                this.closeOne();
            }
            this.listState = null;
        }
        super.setClosed(closed);
    }

    private void closeOne() {
        ListState e = this.listState.pop();
        if (e.openItem) {
            this.builder.endBlock();
        }
        this.builder.endBlock();
    }

    private static class ListState {
        int level;
        DocumentBuilder.BlockType type;
        boolean openItem;

        private ListState(int level, DocumentBuilder.BlockType type) {
            this.level = level;
            this.type = type;
        }
    }
}

