/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.dataviewers.charts.dialogs;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.ISTDataViewersField;
import org.eclipse.linuxtools.dataviewers.charts.provider.ChartFactory;
import org.eclipse.linuxtools.dataviewers.charts.provider.IChartField;
import org.eclipse.linuxtools.internal.dataviewers.charts.Activator;
import org.eclipse.linuxtools.internal.dataviewers.charts.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.swtchart.Chart;

public class ChartDialog
extends Dialog {
    private static final String TAG_SECTION_CHARTS_STATE = "charts_section";
    private static final String TAG_COLUMN_BUTTON_ = "COLUMN_BUTTON_";
    private static final String TAG_BAR_GRAPH_BUTTON = "BAR_GRAPH_BUTTON";
    private static final String TAG_VERTICAL_BARS_BUTTON = "VERTICAL_BARS_BUTTON";
    private static final boolean DEFAULT_COLUMN_BUTTON = true;
    private static final boolean DEFAULT_BAR_GRAPH_BUTTON = true;
    private static final boolean DEFAULT_VERTICAL_BARS_BUTTON = false;
    private final AbstractSTViewer stViewer;
    private Chart chart;
    private Text errorMessageText;
    private Button verticalBarsButton;
    private Button pieChartButton;
    private Button barGraphButton;
    private Button okButton;
    private List<Button> columnButtons;

    public ChartDialog(Shell shell, AbstractSTViewer stViewer) {
        super(shell);
        this.stViewer = stViewer;
    }

    public void restoreState() {
        IDialogSettings settings = this.stViewer.getViewerSettings().getSection(TAG_SECTION_CHARTS_STATE);
        if (settings == null) {
            settings = this.stViewer.getViewerSettings().addNewSection(TAG_SECTION_CHARTS_STATE);
            return;
        }
        int i = 0;
        while (i < this.columnButtons.size()) {
            boolean selected = Boolean.parseBoolean(settings.get(TAG_COLUMN_BUTTON_ + i));
            this.columnButtons.get(i).setSelection(selected);
            ++i;
        }
        boolean barGraph = Boolean.parseBoolean(settings.get(TAG_BAR_GRAPH_BUTTON));
        this.barGraphButton.setSelection(barGraph);
        this.pieChartButton.setSelection(!barGraph);
        boolean vBars = Boolean.parseBoolean(settings.get(TAG_VERTICAL_BARS_BUTTON));
        this.verticalBarsButton.setSelection(vBars);
        this.verticalBarsButton.setEnabled(barGraph);
    }

    public void saveState() {
        IDialogSettings settings = this.stViewer.getViewerSettings().getSection(TAG_SECTION_CHARTS_STATE);
        if (settings == null) {
            settings = this.stViewer.getViewerSettings().addNewSection(TAG_SECTION_CHARTS_STATE);
        }
        int i = 0;
        while (i < this.columnButtons.size()) {
            boolean selected = this.columnButtons.get(i).getSelection();
            settings.put(TAG_COLUMN_BUTTON_ + i, selected);
            ++i;
        }
        boolean barGraph = this.barGraphButton.getSelection();
        settings.put(TAG_BAR_GRAPH_BUTTON, barGraph);
        boolean vBars = this.verticalBarsButton.getSelection();
        settings.put(TAG_VERTICAL_BARS_BUTTON, vBars);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ChartConstants_CREATE_NEW_CHART_FROM_SELECTION);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.chart = this.produceChart();
            this.saveState();
        } else {
            this.chart = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.validateInput();
        return c;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite titleComp = new Composite(composite, 0);
        titleComp.setLayout((Layout)new RowLayout(256));
        Label icon = new Label(titleComp, 0);
        icon.setImage(Activator.getImage("icons/chart_icon.png"));
        Label label = new Label(titleComp, 64);
        label.setText(Messages.ChartConstants_CHART_BUILDER);
        GridData data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        titleComp.setLayoutData((Object)data);
        Group chartTypeGroup = new Group(composite, 0);
        data = new GridData(768);
        chartTypeGroup.setLayoutData((Object)data);
        chartTypeGroup.setLayout((Layout)new GridLayout(2, false));
        chartTypeGroup.setText(Messages.ChartConstants_SELECT_YOUR_CHART_TYPE);
        ValidateSelectionListener listener = new ValidateSelectionListener();
        this.barGraphButton = new Button((Composite)chartTypeGroup, 16);
        this.barGraphButton.setText(Messages.ChartConstants_BAR_GRAPH);
        this.barGraphButton.addSelectionListener((SelectionListener)listener);
        this.barGraphButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartDialog.this.verticalBarsButton.setEnabled(ChartDialog.this.barGraphButton.getSelection());
            }
        });
        data = new GridData();
        this.barGraphButton.setLayoutData((Object)data);
        this.verticalBarsButton = new Button((Composite)chartTypeGroup, 32);
        this.verticalBarsButton.setText(Messages.ChartConstants_VERTICAL_BARS);
        data = new GridData();
        this.verticalBarsButton.setLayoutData((Object)data);
        this.pieChartButton = new Button((Composite)chartTypeGroup, 16);
        this.pieChartButton.setText(Messages.ChartConstants_PIE_CHART);
        this.pieChartButton.addSelectionListener((SelectionListener)listener);
        data = new GridData();
        data.horizontalSpan = 2;
        this.pieChartButton.setLayoutData((Object)data);
        Group chartColumnGroup = new Group(composite, 0);
        chartColumnGroup.setLayout((Layout)new GridLayout(1, true));
        data = new GridData(768);
        chartColumnGroup.setLayoutData((Object)data);
        chartColumnGroup.setText(Messages.ChartConstants_SELECT_COLUMNS_TO_SHOW);
        this.addColumnButtons((Composite)chartColumnGroup, (SelectionListener)listener);
        this.errorMessageText = new Text(composite, 8);
        this.errorMessageText.setLayoutData((Object)new GridData(768));
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        ChartDialog.applyDialogFont((Control)composite);
        this.setWidgetsValues();
        return composite;
    }

    private void setWidgetsValues() {
        this.barGraphButton.setSelection(true);
        this.verticalBarsButton.setEnabled(this.barGraphButton.getSelection());
        this.verticalBarsButton.setSelection(false);
        for (Button button : this.columnButtons) {
            button.setSelection(true);
        }
        this.restoreState();
    }

    private void addColumnButtons(Composite comp, SelectionListener listener) {
        this.columnButtons = new LinkedList<Button>();
        ISTDataViewersField[] iSTDataViewersFieldArray = this.stViewer.getAllFields();
        int n = iSTDataViewersFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISTDataViewersField field = iSTDataViewersFieldArray[n2];
            if (field instanceof IChartField) {
                IChartField cField = (IChartField)field;
                Button b = new Button(comp, 32);
                b.setText(cField.getColumnHeaderText());
                b.setData((Object)cField);
                b.addSelectionListener(listener);
                GridData dt = new GridData();
                b.setLayoutData((Object)dt);
                this.columnButtons.add(b);
            }
            ++n2;
        }
        Label sep = new Label(comp, 258);
        GridData data = new GridData(768);
        sep.setLayoutData((Object)data);
        Composite buttonComposite = new Composite(comp, 0);
        data = new GridData();
        buttonComposite.setLayoutData((Object)data);
        FillLayout l = new FillLayout();
        l.spacing = 5;
        buttonComposite.setLayout((Layout)l);
        final Button b1 = new Button(buttonComposite, 8);
        b1.setText(Messages.ChartConstants_SELECT_ALL);
        Button b2 = new Button(buttonComposite, 8);
        b2.setText(Messages.ChartConstants_DESELECT_ALL);
        SelectionListener sl = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                boolean b = e.getSource() == b1;
                for (Button button : ChartDialog.this.columnButtons) {
                    button.setSelection(b);
                }
                ChartDialog.this.validateInput();
            }
        };
        b1.addSelectionListener(sl);
        b2.addSelectionListener(sl);
    }

    public Chart getValue() {
        return this.chart;
    }

    protected void validateInput() {
        String errorMessage = null;
        int selectedNum = 0;
        for (Button button : this.columnButtons) {
            if (!button.getSelection()) continue;
            ++selectedNum;
        }
        if (selectedNum == 0) {
            errorMessage = Messages.ChartConstants_NO_COLUMN_SELECTED;
        }
        this.setErrorMessage(errorMessage);
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessageText.setText(errorMessage == null ? "" : errorMessage);
        this.okButton.setEnabled(errorMessage == null);
        this.errorMessageText.getParent().update();
    }

    private Chart produceChart() {
        boolean horizontalBars;
        IStructuredSelection selection = (IStructuredSelection)this.stViewer.getViewer().getSelection();
        if (selection == StructuredSelection.EMPTY) {
            return null;
        }
        Object[] objects = selection.toArray();
        ISTDataViewersField labelField = this.getLabelField(this.stViewer);
        ArrayList<IChartField> selectedFields = new ArrayList<IChartField>();
        for (Button button : this.columnButtons) {
            if (!button.getSelection()) continue;
            selectedFields.add((IChartField)button.getData());
        }
        boolean barChartType = this.barGraphButton.getSelection();
        boolean bl = horizontalBars = !this.verticalBarsButton.getSelection();
        if (barChartType) {
            return ChartFactory.produceBarChart(objects, labelField, selectedFields, Messages.ChartConstants_BAR_GRAPH, horizontalBars);
        }
        return ChartFactory.producePieChart(objects, labelField, selectedFields, Messages.ChartConstants_PIE_CHART);
    }

    protected ISTDataViewersField getLabelField(AbstractSTViewer viewer) {
        return viewer.getAllFields()[0];
    }

    private class ValidateSelectionListener
    extends SelectionAdapter {
        private ValidateSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ChartDialog.this.validateInput();
        }
    }
}

