/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.cdt.internal.ui.text.doctools.DocCommentOwnerManager;
import org.eclipse.cdt.internal.ui.text.doctools.NullDocCommentOwner;
import org.eclipse.cdt.ui.dialogs.DialogsMessages;
import org.eclipse.cdt.ui.text.doctools.IDocCommentOwner;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DocCommentOwnerCombo
extends Composite {
    protected Combo fCombo;
    protected IDocCommentOwner[] fOwners;
    protected IDocCommentOwner fInitialOwner;

    public DocCommentOwnerCombo(Composite parent, int style, IDocCommentOwner initialOwner) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        this.fInitialOwner = initialOwner;
        this.fOwners = DocCommentOwnerCombo.getNontestOwners();
        this.createControl(this);
    }

    public IDocCommentOwner getSelectedDocCommentOwner() {
        int index = this.fCombo.getSelectionIndex();
        return index == 0 ? NullDocCommentOwner.INSTANCE : this.fOwners[index - 1];
    }

    private static IDocCommentOwner[] getNontestOwners() {
        ArrayList<IDocCommentOwner> result = new ArrayList<IDocCommentOwner>();
        IDocCommentOwner[] iDocCommentOwnerArray = DocCommentOwnerManager.getInstance().getRegisteredOwners();
        int n = iDocCommentOwnerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDocCommentOwner owner = iDocCommentOwnerArray[n2];
            if (owner.getID().indexOf(".test.") == -1) {
                result.add(owner);
            }
            ++n2;
        }
        return result.toArray(new IDocCommentOwner[result.size()]);
    }

    public void createControl(Composite parent) {
        String[] items = new String[this.fOwners.length + 1];
        items[0] = DialogsMessages.DocCommentOwnerCombo_None;
        int i = 0;
        while (i < this.fOwners.length) {
            items[i + 1] = this.fOwners[i].getName();
            ++i;
        }
        this.fCombo = ControlFactory.createSelectCombo(parent, items, DialogsMessages.DocCommentOwnerCombo_None);
        this.selectInCombo(this.fInitialOwner);
    }

    public void selectInCombo(IDocCommentOwner owner) {
        int i = 0;
        while (i < this.fOwners.length) {
            if (this.fOwners[i].getID().equals(owner.getID())) {
                this.fCombo.select(i + 1);
                return;
            }
            ++i;
        }
        this.fCombo.select(0);
    }

    public void setEnabled(boolean enabled) {
        this.fCombo.setEnabled(enabled);
    }
}

