/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeGroupStyle;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class IncludeOrderBlock
extends OptionsConfigurationBlock {
    private static final int IDX_UP = 0;
    private static final int IDX_DOWN = 1;
    private static final String[] UP_DOWN_LABELS = new String[]{PreferencesMessages.IncludeOrderBlock_up, PreferencesMessages.IncludeOrderBlock_down};
    private final List<IncludeGroupStyle> styles;
    private Map<IncludeGroupStyle.IncludeKind, IncludeGroupStyle> stylesByKind;
    private GroupListField includeGroupList;
    private PixelConverter pixelConverter;

    public IncludeOrderBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container, List<IncludeGroupStyle> styles) {
        super(context, project, new OptionsConfigurationBlock.Key[0], container);
        this.styles = styles;
    }

    @Override
    protected Control createContents(Composite parent) {
        this.pixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.includeGroupList = new GroupListField();
        this.includeGroupList.setLabelText(PreferencesMessages.IncludeOrderBlock_order_of_includes);
        Label label = this.includeGroupList.getLabelControl(composite);
        label.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        Control control = this.includeGroupList.getListControl(composite);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = this.pixelConverter.convertWidthInCharsToPixels(50);
        gd.heightHint = this.pixelConverter.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)gd);
        Composite buttonsControl = this.includeGroupList.getButtonBox(composite);
        buttonsControl.setLayoutData((Object)new GridData(4, 1, false, false));
        this.updateControls();
        return composite;
    }

    @Override
    protected void updateControls() {
        super.updateControls();
        this.stylesByKind = IncludeOrderBlock.getStylesByKind(this.styles);
        ArrayList<IncludeGroupStyle> orderedStyles = new ArrayList<IncludeGroupStyle>(this.styles);
        Collections.sort(orderedStyles);
        ArrayList<IncludeGroupStyle> groupedStyles = new ArrayList<IncludeGroupStyle>();
        int order = 0;
        for (IncludeGroupStyle style : orderedStyles) {
            style.setOrder(order++);
            IncludeGroupStyle.IncludeKind includeKind = style.getIncludeKind();
            if (!style.isKeepTogether() || includeKind.hasChildren() && !this.hasUngroupedChildren(includeKind, this.stylesByKind)) continue;
            groupedStyles.add(style);
        }
        int i = 0;
        while (i < groupedStyles.size()) {
            IncludeGroupStyle style = (IncludeGroupStyle)groupedStyles.get(i);
            IncludeGroupStyle.IncludeKind groupingKind = this.getGroupingParentKind(style);
            if (groupingKind != null) {
                while (++i < groupedStyles.size() && this.getGroupingParentKind((IncludeGroupStyle)groupedStyles.get(i)) == groupingKind) {
                }
                int j = i + 1;
                while (j < groupedStyles.size()) {
                    if (this.getGroupingParentKind((IncludeGroupStyle)groupedStyles.get(j)) == groupingKind) {
                        groupedStyles.add(i++, (IncludeGroupStyle)groupedStyles.remove(j));
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.includeGroupList.setElements(groupedStyles);
    }

    private boolean areKeptTogether(IncludeGroupStyle style1, IncludeGroupStyle style2) {
        IncludeGroupStyle.IncludeKind kind = this.getGroupingParentKind(style1);
        return kind != null && kind == this.getGroupingParentKind(style2);
    }

    private IncludeGroupStyle.IncludeKind getGroupingParentKind(IncludeGroupStyle style) {
        IncludeGroupStyle.IncludeKind kind = style.getIncludeKind().parent;
        if (kind == null) {
            return null;
        }
        while (kind != IncludeGroupStyle.IncludeKind.OTHER || !style.isKeepTogether()) {
            IncludeGroupStyle parent = this.stylesByKind.get((Object)kind);
            if (parent != null && parent.isKeepTogether()) {
                return kind;
            }
            if (kind == IncludeGroupStyle.IncludeKind.OTHER) break;
            kind = IncludeGroupStyle.IncludeKind.OTHER;
        }
        return null;
    }

    private static Map<IncludeGroupStyle.IncludeKind, IncludeGroupStyle> getStylesByKind(List<IncludeGroupStyle> styles) {
        HashMap<IncludeGroupStyle.IncludeKind, IncludeGroupStyle> stylesByKind = new HashMap<IncludeGroupStyle.IncludeKind, IncludeGroupStyle>();
        for (IncludeGroupStyle style : styles) {
            if (style.getIncludeKind() == IncludeGroupStyle.IncludeKind.MATCHING_PATTERN) continue;
            stylesByKind.put(style.getIncludeKind(), style);
        }
        return stylesByKind;
    }

    private boolean hasUngroupedChildren(IncludeGroupStyle.IncludeKind includeKind, Map<IncludeGroupStyle.IncludeKind, IncludeGroupStyle> stylesByKind) {
        for (IncludeGroupStyle.IncludeKind childKind : includeKind.children) {
            if (stylesByKind.get((Object)childKind).isKeepTogether()) continue;
            return true;
        }
        if (includeKind == IncludeGroupStyle.IncludeKind.OTHER) {
            for (IncludeGroupStyle.IncludeKind kind : stylesByKind.keySet()) {
                if (kind == IncludeGroupStyle.IncludeKind.OTHER || !kind.hasChildren() || stylesByKind.get((Object)kind).isKeepTogether() || !this.hasUngroupedChildren(kind, stylesByKind)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        this.fContext.statusChanged(new StatusInfo());
    }

    private static class GroupLabelProvider
    extends LabelProvider {
        private GroupLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            IncludeGroupStyle style = (IncludeGroupStyle)element;
            String name = style.getName();
            if (name == null) {
                name = style.getIncludeKind().name;
            }
            return name;
        }
    }

    private class GroupListField
    extends ListDialogField<IncludeGroupStyle> {
        GroupListField() {
            super(null, UP_DOWN_LABELS, (IBaseLabelProvider)new GroupLabelProvider());
        }

        @Override
        public void dialogFieldChanged() {
            super.dialogFieldChanged();
            int order = 0;
            for (IncludeGroupStyle style : this.getElements()) {
                style.setOrder(order++);
            }
        }

        @Override
        protected boolean getManagedButtonState(ISelection sel, int index) {
            if (index == 0) {
                return !sel.isEmpty() && this.canMoveUp();
            }
            if (index == 1) {
                return !sel.isEmpty() && this.canMoveDown();
            }
            return true;
        }

        @Override
        protected boolean managedButtonPressed(int index) {
            if (index == 0) {
                this.up();
            } else if (index == 1) {
                this.down();
            } else {
                return false;
            }
            return true;
        }

        private void up() {
            boolean[] selected = this.getSelectionMask(false);
            this.extendSelectionForMovingUp(selected, this.fElements);
            if (selected != null) {
                this.setElements(this.moveUp(this.fElements, selected));
                this.fTable.reveal(this.fElements.get(this.getFirstSelected(selected)));
            }
        }

        private void down() {
            boolean[] selected = this.getSelectionMask(true);
            List<IncludeGroupStyle> reversed = this.reverse(this.fElements);
            this.extendSelectionForMovingUp(selected, reversed);
            if (selected != null) {
                this.setElements(this.reverse(this.moveUp(reversed, selected)));
                this.fTable.reveal(this.fElements.get(this.getFirstSelected(selected)));
            }
        }

        private List<IncludeGroupStyle> reverse(List<IncludeGroupStyle> p) {
            ArrayList<IncludeGroupStyle> reverse = new ArrayList<IncludeGroupStyle>(p.size());
            int i = p.size();
            while (--i >= 0) {
                reverse.add(p.get(i));
            }
            return reverse;
        }

        private boolean[] getSelectionMask(boolean reverse) {
            boolean[] selectionMask = null;
            if (this.isOkToUse(this.fTableControl)) {
                int nElements = this.fElements.size();
                int[] nArray = this.fTable.getTable().getSelectionIndices();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    if (selectionMask == null) {
                        selectionMask = new boolean[nElements];
                    }
                    selectionMask[reverse ? nElements - 1 - i : i] = true;
                    ++n2;
                }
            }
            return selectionMask;
        }

        private void extendSelectionForMovingUp(boolean[] selection, List<IncludeGroupStyle> styles) {
            int i = 1;
            while (i < selection.length) {
                int j = i - 1;
                if (!selection[i] && selection[j] && IncludeOrderBlock.this.areKeptTogether(styles.get(i), styles.get(j))) {
                    selection[i] = true;
                }
                ++i;
            }
        }

        private List<IncludeGroupStyle> moveUp(List<IncludeGroupStyle> elements, boolean[] selected) {
            int nElements = elements.size();
            ArrayList<IncludeGroupStyle> res = new ArrayList<IncludeGroupStyle>(nElements);
            ArrayList<IncludeGroupStyle> floating = new ArrayList<IncludeGroupStyle>();
            int i = 0;
            while (i < nElements) {
                IncludeGroupStyle curr = elements.get(i);
                if (selected[i]) {
                    res.add(curr);
                } else {
                    if (!floating.isEmpty() && !IncludeOrderBlock.this.areKeptTogether(curr, (IncludeGroupStyle)floating.get(0))) {
                        res.addAll(floating);
                        floating.clear();
                    }
                    floating.add(curr);
                }
                ++i;
            }
            res.addAll(floating);
            return res;
        }

        private int getFirstSelected(boolean[] selected) {
            int i = 0;
            while (i < selected.length) {
                if (selected[i]) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private boolean canMoveUp() {
            boolean[] selected = this.getSelectionMask(false);
            if (selected == null || selected[0]) {
                return false;
            }
            return this.canMoveUp(this.fElements, selected);
        }

        private boolean canMoveDown() {
            boolean[] selected = this.getSelectionMask(true);
            if (selected == null || selected[0]) {
                return false;
            }
            return this.canMoveUp(this.reverse(this.fElements), selected);
        }

        private boolean canMoveUp(List<IncludeGroupStyle> elements, boolean[] selected) {
            int i = 1;
            while (i < selected.length) {
                int j = i - 1;
                if (selected[i] && !selected[j] && IncludeOrderBlock.this.areKeptTogether(elements.get(i), elements.get(j))) {
                    while (++i < selected.length && selected[i]) {
                    }
                    if (!IncludeOrderBlock.this.areKeptTogether(elements.get(i - 1), elements.get(j))) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
    }
}

