/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.launch.launching;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.internal.oprofile.core.OpcontrolException;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OprofileDaemonEvent;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OprofileDaemonOptions;
import org.eclipse.linuxtools.internal.oprofile.launch.OprofileLaunchMessages;
import org.eclipse.linuxtools.internal.oprofile.launch.configuration.LaunchOptions;
import org.eclipse.linuxtools.internal.oprofile.launch.configuration.OprofileCounter;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.internal.oprofile.ui.view.OprofileView;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchConfigurationDelegate;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractOprofileLaunchConfigurationDelegate
extends ProfileLaunchConfigurationDelegate {
    protected ILaunchConfiguration config;

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.config = config;
        Oprofile.OprofileProject.setProject((IProject)this.getProject());
        LaunchOptions options = new LaunchOptions();
        options.loadConfiguration(config);
        IPath exePath = this.getExePath(config);
        options.setBinaryImage(exePath.toOSString());
        OprofileDaemonEvent[] daemonEvents = null;
        if (!config.getAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.USE_DEFAULT_EVENT", false)) {
            OprofileCounter[] counters = this.oprofileCounters(config);
            ArrayList<OprofileDaemonEvent> events = new ArrayList<OprofileDaemonEvent>();
            int i = 0;
            while (i < counters.length) {
                if (counters[i].getEnabled()) {
                    events.add(counters[i].getDaemonEvent());
                }
                ++i;
            }
            daemonEvents = new OprofileDaemonEvent[events.size()];
            events.toArray(daemonEvents);
        }
        if (!this.preExec(options, daemonEvents, launch)) {
            return;
        }
        IRemoteCommandLauncher launcher = RemoteProxyManager.getInstance().getLauncher(this.oprofileProject());
        Path workingDirPath = new Path(this.oprofileWorkingDirURI(config).getPath());
        String[] arguments = this.getProgramArgumentsArray(config);
        Process process = null;
        int i = 0;
        while (i < options.getExecutionsNumber()) {
            process = launcher.execute(exePath, arguments, this.getEnvironment(config), (IPath)workingDirPath, monitor);
            DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(exePath.toOSString()));
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                process.destroy();
                Status status = new Status(4, "org.eclipse.linuxtools.oprofile.launch", OprofileLaunchMessages.getString("oprofilelaunch.error.interrupted_error.status_message"));
                throw new CoreException((IStatus)status);
            }
            ++i;
        }
        this.postExec(options, daemonEvents, process);
    }

    protected abstract boolean preExec(LaunchOptions var1, OprofileDaemonEvent[] var2, ILaunch var3);

    protected abstract void postExec(LaunchOptions var1, OprofileDaemonEvent[] var2, Process var3);

    protected String getPluginID() {
        return "org.eclipse.linuxtools.oprofile.launch";
    }

    protected void refreshOprofileView() {
        OprofileView view = OprofileUiPlugin.getDefault().getOprofileView();
        if (view != null) {
            view.refreshView();
        } else {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.oprofile.ui.OProfileView");
            }
            catch (PartInitException e2) {
                e2.printStackTrace();
            }
            OprofileUiPlugin.getDefault().getOprofileView().refreshView();
        }
    }

    protected void oprofileShutdown() throws OpcontrolException {
        OprofileCorePlugin.getDefault().getOpcontrolProvider().shutdownDaemon();
    }

    protected void oprofileReset() throws OpcontrolException {
        OprofileCorePlugin.getDefault().getOpcontrolProvider().reset();
    }

    protected void oprofileSetupDaemon(OprofileDaemonOptions options, OprofileDaemonEvent[] events) throws OpcontrolException {
        OprofileCorePlugin.getDefault().getOpcontrolProvider().setupDaemon(options, events);
    }

    protected void oprofileStartCollection() throws OpcontrolException {
        OprofileCorePlugin.getDefault().getOpcontrolProvider().startCollection();
    }

    protected void oprofileDumpSamples() throws OpcontrolException {
        OprofileCorePlugin.getDefault().getOpcontrolProvider().dumpSamples();
    }

    protected IProject oprofileProject() {
        return Oprofile.OprofileProject.getProject();
    }

    protected URI oprofileWorkingDirURI(ILaunchConfiguration config) throws CoreException {
        File workingDirectory = this.getWorkingDirectory(config);
        if (workingDirectory == null) {
            return this.getProject().getLocationURI();
        }
        URI uri = null;
        try {
            uri = new URI(workingDirectory.getAbsolutePath());
        }
        catch (URISyntaxException uRISyntaxException) {
            Status status = new Status(4, OprofileCorePlugin.getId(), OprofileLaunchMessages.getString("oprofilelaunch.error.invalidworkingdir.status_message"));
            throw new CoreException((IStatus)status);
        }
        return uri;
    }

    protected OprofileCounter[] oprofileCounters(ILaunchConfiguration config) {
        return OprofileCounter.getCounters(config);
    }

    protected boolean oprofileStatus() throws OpcontrolException {
        return OprofileCorePlugin.getDefault().getOpcontrolProvider().status();
    }

    protected IProject getProject() {
        try {
            IProject project = CDebugUtils.verifyCProject((ILaunchConfiguration)this.config).getProject();
            return project;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected IPath getExePath(ILaunchConfiguration config) throws CoreException {
        IPath exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
        return exePath;
    }
}

