/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.ui;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.linuxtools.internal.perf.IPerfData;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.StatComparisonData;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class StatComparisonView
extends ViewPart {
    private static final Color RED = new Color((Device)Display.getDefault(), 150, 0, 0);
    private static final Color GREEN = new Color((Device)Display.getDefault(), 0, 100, 0);
    private static String OCCURRENCE = "\\s*(\\-?+\\d+[\\.\\,\\d]*).*";
    private StyledText text;
    private static int SECONDARY_ID = 0;

    public void createPartControl(Composite parent) {
        parent.setLayoutData((Object)new GridLayout(1, true));
        this.text = new StyledText(parent, 576);
        this.text.setEditable(false);
        IPerfData statsDiff = PerfPlugin.getDefault().getStatDiffData();
        if (statsDiff != null) {
            this.setStyledText(statsDiff.getPerfData());
            this.setContentDescription(statsDiff.getTitle());
        }
    }

    public void setFocus() {
    }

    private void setStyledText(String input) {
        String[] lines;
        this.text.setText(input);
        this.text.setAlignment(16384);
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        int ptr = 0;
        this.text.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        String[] stringArray = lines = input.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher m;
            String line = stringArray[n2];
            if (Pattern.matches(OCCURRENCE, line) && (m = Pattern.compile(OCCURRENCE).matcher(line)).matches() && m.group(1) != null) {
                try {
                    float occurrence = StatComparisonData.toFloat(m.group(1).trim());
                    if (occurrence > 0.0f) {
                        styles.add(new StyleRange(ptr, line.length(), RED, null));
                    } else if (occurrence < 0.0f) {
                        styles.add(new StyleRange(ptr, line.length(), GREEN, null));
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ptr += line.length() + 1;
            ++n2;
        }
        this.text.setStyleRanges(styles.toArray(new StyleRange[0]));
    }

    public static void refreshView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    int n = SECONDARY_ID;
                    SECONDARY_ID = n + 1;
                    iWorkbenchPage.showView("org.eclipse.linuxtools.perf.ui.StatViewDiff", Integer.toString(n), 3);
                }
                catch (PartInitException e) {
                    Status status = new Status(4, "org.eclipse.linuxtools.perf", e.getMessage(), (Throwable)e);
                    PerfPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
        });
    }
}

