/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.ui;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.linuxtools.internal.perf.IPerfData;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.osgi.framework.Bundle;

public class SourceDisassemblyView
extends ViewPart
implements IFindReplaceTarget {
    private static final Color RED = new Color((Device)Display.getDefault(), 150, 0, 0);
    private static final Color ORANGE = new Color((Device)Display.getDefault(), 150, 100, 0);
    private static final Color GREEN = new Color((Device)Display.getDefault(), 0, 100, 0);
    private static String ASM = "\\s+([0-9]+\\.[0-9]+ )?:\\s+[0-9a-f]+:\\s+[0-9a-z]+\\s+.*";
    private static String CODE = "\\s+:\\s+.*";
    private static String WORD_BOUNDARY = "\\b";
    private static int SECONDARY_ID = 0;
    private StyledText text;

    public void createPartControl(Composite parent) {
        parent.setLayoutData((Object)new GridLayout(1, true));
        this.text = new StyledText(parent, 576);
        this.text.setEditable(false);
        IPerfData data = PerfPlugin.getDefault().getSourceDisassemblyData();
        if (data != null) {
            this.setStyledText(data.getPerfData());
            this.setContentDescription(data.getTitle());
            this.setupFindDialog();
        }
    }

    public void setFocus() {
    }

    protected void setStyledText(StyledText txt) {
        this.text = txt;
    }

    public String getContent() {
        return this.text == null ? "" : this.text.getText();
    }

    private void setStyledText(String input) {
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        int ptr = 0;
        this.text.setText(input);
        StringTokenizer tok = new StringTokenizer(input, "\n");
        while (tok.hasMoreTokens()) {
            String line = tok.nextToken();
            if (Pattern.matches(ASM, line)) {
                Matcher m = Pattern.compile(ASM).matcher(line);
                if (m.matches() && m.group(1) != null) {
                    try {
                        float percent = Float.parseFloat(m.group(1).trim());
                        if (percent >= 20.0f) {
                            styles.add(new StyleRange(ptr, line.length(), RED, null));
                        } else if (percent >= 5.0f) {
                            styles.add(new StyleRange(ptr, line.length(), ORANGE, null));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (Pattern.matches(CODE, line)) {
                styles.add(new StyleRange(ptr, line.length(), GREEN, null));
            }
            ptr += line.length() + 1;
        }
        this.text.setStyleRanges(styles.toArray(new StyleRange[0]));
    }

    public static void refreshView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    int n = SECONDARY_ID;
                    SECONDARY_ID = n + 1;
                    iWorkbenchPage.showView("org.eclipse.linuxtools.perf.ui.SourceDisassemblyView", Integer.toString(n), 3);
                }
                catch (PartInitException e) {
                    Status status = new Status(4, "org.eclipse.linuxtools.perf", e.getMessage(), (Throwable)e);
                    PerfPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
        });
    }

    public void setupFindDialog() {
        FindReplaceAction findAction = new FindReplaceAction(Platform.getResourceBundle((Bundle)PerfPlugin.getDefault().getBundle()), null, this.text.getShell(), (IFindReplaceTarget)this);
        findAction.setImageDescriptor(PerfPlugin.getImageDescriptor("icons/search.gif"));
        findAction.setToolTipText("Search Source Disassembly");
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add((IAction)findAction);
        bars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)findAction);
    }

    public boolean canPerformFind() {
        return this.text != null && !"".equals(this.text.getText());
    }

    public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        int matchIndex = -1;
        String searchString = this.text.getText();
        String findRegex = findString;
        if (widgetOffset < 0) {
            int n = widgetOffset = searchForward ? 0 : searchString.length();
        }
        if (wholeWord) {
            findRegex = String.valueOf(WORD_BOUNDARY) + findRegex + WORD_BOUNDARY;
        }
        int caseFlag = caseSensitive ? 0 : 2;
        Pattern pattern = Pattern.compile(findRegex, caseFlag);
        Matcher matcher = pattern.matcher(searchString);
        if (searchForward) {
            matchIndex = matcher.find(widgetOffset) ? matcher.start() : -1;
        } else {
            matcher.region(0, widgetOffset);
            while (matcher.find()) {
                matchIndex = matcher.start();
            }
        }
        if (matchIndex != -1) {
            this.text.setSelection(matchIndex, matchIndex + findString.length());
        }
        return matchIndex;
    }

    public Point getSelection() {
        Point selection = this.text.getSelection();
        return new Point(selection.x, selection.y - selection.x);
    }

    public String getSelectionText() {
        return this.text.getSelectionText();
    }

    public boolean isEditable() {
        return false;
    }

    public void replaceSelection(String text) {
    }
}

