/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.handlers;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.StatComparisonData;
import org.eclipse.linuxtools.internal.perf.handlers.Messages;
import org.eclipse.linuxtools.internal.perf.ui.StatComparisonView;

public class PerfStatsQuickDiffHandler
implements IHandler {
    public Object execute(ExecutionEvent event) {
        PerfPlugin plugin = PerfPlugin.getDefault();
        File curStatData = plugin.getPerfFile("perf.stat");
        File prevStatData = plugin.getPerfFile("perf.old.stat");
        String title = MessageFormat.format(Messages.ContentDescription_0, prevStatData.getName(), curStatData.getName());
        StatComparisonData diffData = new StatComparisonData(title, prevStatData, curStatData);
        diffData.runComparison();
        plugin.setStatDiffData(diffData);
        StatComparisonView.refreshView();
        return null;
    }

    public boolean isEnabled() {
        PerfPlugin plugin = PerfPlugin.getDefault();
        IPath workingDir = plugin.getWorkingDir();
        if (workingDir != null) {
            File curStatData = plugin.getPerfFile("perf.stat");
            File prevStatData = plugin.getPerfFile("perf.old.stat");
            return curStatData.exists() && prevStatData.exists();
        }
        return false;
    }

    public boolean isHandled() {
        return this.isEnabled();
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

