/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.handlers;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.StatComparisonData;
import org.eclipse.linuxtools.internal.perf.handlers.AbstractComparisonHandler;
import org.eclipse.linuxtools.internal.perf.handlers.Messages;
import org.eclipse.linuxtools.internal.perf.handlers.PerfSaveStatsHandler;
import org.eclipse.linuxtools.internal.perf.ui.StatComparisonView;

public class PerfStatsComparisonHandler
extends AbstractComparisonHandler {
    @Override
    protected boolean isValidFile(IFile file) {
        return file == null ? false : PerfSaveStatsHandler.DATA_EXT.equals(file.getFileExtension());
    }

    @Override
    protected void handleComparison(IFile oldData, IFile newData) {
        String title = MessageFormat.format(Messages.ContentDescription_0, oldData.getName(), newData.getName());
        File oldDatum = oldData.getLocation().toFile();
        File newDatum = newData.getLocation().toFile();
        StatComparisonData diffData = new StatComparisonData(title, oldDatum, newDatum);
        diffData.runComparison();
        PerfPlugin.getDefault().setStatDiffData(diffData);
        StatComparisonView.refreshView();
    }
}

