/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.internal.perf.PerfPlugin;
import org.eclipse.linuxtools.internal.perf.model.PMCommand;
import org.eclipse.linuxtools.internal.perf.model.PMDso;
import org.eclipse.linuxtools.internal.perf.model.PMEvent;
import org.eclipse.linuxtools.internal.perf.model.PMFile;
import org.eclipse.linuxtools.internal.perf.model.PMSymbol;
import org.eclipse.linuxtools.internal.perf.model.TreeParent;
import org.eclipse.linuxtools.internal.perf.ui.PerfProfileView;
import org.eclipse.linuxtools.profiling.launch.ConfigUtils;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PerfCore {
    private static HashMap<String, HashMap<String, ArrayList<String>>> eventsHostMap = null;
    private static HashMap<String, ArrayList<String>> eventList = null;

    public static String spitStream(BufferedReader br, String blockTitle, PrintStream print) {
        StringBuffer strBuf = new StringBuffer();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                strBuf.append(line);
                strBuf.append("\n");
            }
        }
        catch (IOException e) {
            PerfCore.logException(e);
        }
        String str = strBuf.toString();
        if (!str.trim().equals("") && print != null) {
            print.println(String.valueOf(blockTitle) + ": \n" + str + "\n END OF " + blockTitle);
        }
        return str;
    }

    public static HashMap<String, ArrayList<String>> getEventList(ILaunchConfiguration config) {
        String projectHost = PerfCore.getHostName(config);
        if (eventsHostMap == null) {
            eventsHostMap = new HashMap();
        }
        if (projectHost == null) {
            projectHost = "local";
        }
        if ((eventList = eventsHostMap.get(projectHost)) == null) {
            eventList = PerfCore.loadEventList(config);
            eventsHostMap.put(projectHost, eventList);
        }
        return eventList;
    }

    private static String getHostName(ILaunchConfiguration config) {
        String projectName = null;
        try {
            projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
        }
        catch (CoreException coreException) {
            return null;
        }
        if (projectName.equals("")) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            return null;
        }
        return project.getLocationURI().getHost();
    }

    private static IProject getProject(ILaunchConfiguration config) {
        if (config == null) {
            return null;
        }
        ConfigUtils configUtils = new ConfigUtils(config);
        try {
            String projectName = configUtils.getProjectName();
            if (projectName != null && !projectName.equals("")) {
                return ConfigUtils.getProject((String)projectName);
            }
        }
        catch (CoreException e1) {
            PerfCore.logException((Exception)((Object)e1));
        }
        return null;
    }

    private static HashMap<String, ArrayList<String>> loadEventList(ILaunchConfiguration config) {
        HashMap<String, ArrayList<String>> events = new HashMap<String, ArrayList<String>>();
        IProject project = PerfCore.getProject(config);
        if (project == null ? !PerfCore.checkPerfInPath() : !PerfCore.checkRemotePerfInPath(project)) {
            return events;
        }
        Process p = null;
        BufferedReader input = null;
        try {
            p = RuntimeProcessFactory.getFactory().exec(new String[]{"perf", "list"}, project);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()));
        }
        catch (IOException e) {
            PerfCore.logException(e);
        }
        return PerfCore.parseEventList(input);
    }

    public static HashMap<String, ArrayList<String>> parseEventList(BufferedReader input) {
        HashMap<String, ArrayList<String>> events;
        block21: {
            events = new HashMap<String, ArrayList<String>>();
            try {
                try {
                    String line;
                    while ((line = input.readLine()) != null) {
                        String event;
                        String category;
                        if (!line.contains("[")) continue;
                        if (line.contains("Hardware breakpoint")) {
                            category = "Hardware breakpoint";
                            event = line.substring(1, line.indexOf(91, 0)).trim();
                        } else if (line.contains("Raw hardware event descriptor")) {
                            category = "Raw hardware event descriptor";
                            event = line.substring(1, line.indexOf(91, 0)).trim();
                        } else {
                            event = line.substring(1, line.indexOf(91, 0)).trim();
                            if (event.contains("OR")) {
                                event = event.split("OR")[0];
                            }
                            category = line.replaceFirst(".*\\[(.+)\\]", "$1").trim();
                        }
                        ArrayList<String> categoryEvents = events.get(category);
                        if (categoryEvents == null) {
                            categoryEvents = new ArrayList();
                            events.put(category, categoryEvents);
                        }
                        categoryEvents.add(event.trim());
                    }
                }
                catch (IOException e) {
                    PerfCore.logException(e);
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return events;
    }

    public static String getPerfVersion(ILaunchConfiguration config, String[] environ, IPath workingDir) {
        IProject project = PerfCore.getProject(config);
        Process p = null;
        IRemoteFileProxy proxy = null;
        IFileStore workingDirFileStore = null;
        if (workingDir == null) {
            try {
                p = RuntimeProcessFactory.getFactory().exec(new String[]{"perf", "--version"}, project);
            }
            catch (IOException e) {
                PerfCore.logException(e);
            }
        } else {
            try {
                proxy = RemoteProxyManager.getInstance().getFileProxy(new URI(workingDir.toOSString()));
                workingDirFileStore = proxy.getResource(workingDir.toOSString());
                p = RuntimeProcessFactory.getFactory().exec(new String[]{"perf", "--version"}, environ, workingDirFileStore, project);
            }
            catch (IOException e) {
                PerfCore.logException(e);
            }
            catch (CoreException e) {
                PerfCore.logException((Exception)((Object)e));
            }
            catch (URISyntaxException e) {
                PerfCore.logException(e);
            }
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
        return PerfCore.spitStream(input, "Perf --version", null);
    }

    public static boolean checkPerfInPath() {
        try {
            Runtime.getRuntime().exec(new String[]{"perf", "--version"});
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static boolean checkRemotePerfInPath(IProject project) {
        try {
            RuntimeProcessFactory.getFactory().exec(new String[]{"perf", "--version"}, project);
        }
        catch (IOException e) {
            PerfCore.logException(e);
            return false;
        }
        return true;
    }

    public static String[] getRecordString(ILaunchConfiguration config) {
        String[] base = new String[]{"perf", "record", "-f"};
        if (config == null) {
            return base;
        }
        ArrayList<String> newCommand = new ArrayList<String>();
        newCommand.addAll(Arrays.asList(base));
        try {
            if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Record.Realtime", false)) {
                newCommand.add("-r");
            }
            if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Record.Verbose", false)) {
                newCommand.add("-v");
            }
            if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Multiplex", false)) {
                newCommand.add("-M");
            }
            List selE = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.SelectedEvents", PerfPlugin.ATTR_SelectedEvents_default);
            if (!config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.DefaultEvent", true) && selE != null) {
                for (Object e : selE) {
                    newCommand.add("-e");
                    newCommand.add((String)e);
                }
            }
        }
        catch (CoreException coreException) {}
        return newCommand.toArray(new String[0]);
    }

    public static String[] getReportString(ILaunchConfiguration config, String perfDataLoc) {
        ArrayList<String> base = new ArrayList<String>();
        base.addAll(Arrays.asList("perf", "report", "--sort", "comm,dso,sym", "-n", "-t", "\u0001"));
        if (config != null) {
            try {
                String kernelLoc = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Kernel.Location", "");
                if (kernelLoc != "") {
                    base.add("--vmlinux");
                    base.add(kernelLoc);
                }
                if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.ModuleSymbols", false)) {
                    base.add("-m");
                }
                if (perfDataLoc != null) {
                    base.add("-i");
                    base.add(perfDataLoc);
                }
            }
            catch (CoreException coreException) {}
        }
        return base.toArray(new String[base.size()]);
    }

    public static String[] getAnnotateString(ILaunchConfiguration config, String dso, String symbol, String perfDataLoc, boolean OldPerfVersion) {
        ArrayList<String> base = new ArrayList<String>();
        if (OldPerfVersion) {
            base.addAll(Arrays.asList("perf", "annotate", "-s", symbol, "-l", "-P"));
        } else {
            base.addAll(Arrays.asList("perf", "annotate", "-d", dso, "-s", symbol, "-l", "-P"));
        }
        if (config != null) {
            try {
                String kernelLoc = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Kernel.Location", "");
                if (kernelLoc != "") {
                    base.add("--vmlinux");
                    base.add(kernelLoc);
                }
                if (config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.ModuleSymbols", false)) {
                    base.add("-m");
                }
                if (perfDataLoc != null) {
                    base.add("-i");
                    base.add(perfDataLoc);
                }
            }
            catch (CoreException coreException) {}
        }
        return base.toArray(new String[base.size()]);
    }

    public static void Report(ILaunchConfiguration config, String[] environ, IPath workingDir, IProgressMonitor monitor, String perfDataLoc, PrintStream print) {
        IProject project = PerfCore.getProject(config);
        TreeParent invisibleRoot = PerfPlugin.getDefault().clearModelRoot();
        boolean OldPerfVersion = false;
        if (PerfCore.getPerfVersion(config, environ, workingDir).contains("perf version 0.0.2.PERF")) {
            OldPerfVersion = true;
            if (print != null) {
                print.println("WARNING: You are running an older version of Perf, please update if you can. The plugin may produce unpredictable results.");
            }
        }
        BufferedReader input = null;
        BufferedReader error = null;
        Process p = null;
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        try {
            if (workingDir == null) {
                p = RuntimeProcessFactory.getFactory().exec(PerfCore.getReportString(config, perfDataLoc), project);
                PerfPlugin.getDefault().setPerfProfileData((IPath)new Path(perfDataLoc));
                PerfPlugin.getDefault().setWorkingDir(project.getLocation());
            } else {
                String defaultPerfDataLoc = String.valueOf(workingDir.toOSString()) + "perf.data";
                p = RuntimeProcessFactory.getFactory().exec(PerfCore.getReportString(config, defaultPerfDataLoc), project);
                PerfPlugin.getDefault().setPerfProfileData((IPath)new Path(defaultPerfDataLoc));
                PerfPlugin.getDefault().setWorkingDir(workingDir);
            }
            input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        }
        catch (IOException e) {
            PerfCore.logException(e);
        }
        PerfCore.parseRemoteReport(config, workingDir, monitor, perfDataLoc, print, invisibleRoot, OldPerfVersion, input, error, project);
    }

    public static void parseReport(ILaunchConfiguration config, IPath workingDir, IProgressMonitor monitor, String perfDataLoc, PrintStream print, TreeParent invisibleRoot, boolean OldPerfVersion, BufferedReader input, BufferedReader error) {
        PerfCore.parseRemoteReport(config, workingDir, monitor, perfDataLoc, print, invisibleRoot, OldPerfVersion, input, error, null);
    }

    public static void parseRemoteReport(ILaunchConfiguration config, IPath workingDir, IProgressMonitor monitor, String perfDataLoc, PrintStream print, TreeParent invisibleRoot, boolean OldPerfVersion, BufferedReader input, BufferedReader error, IProject project) {
        boolean hasProfileData;
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        String line = null;
        Process p = null;
        PMEvent currentEvent = null;
        TreeParent currentCommand = null;
        TreeParent currentDso = null;
        PMFile currentFile = null;
        PMSymbol currentSym = null;
        try {
            while ((line = input.readLine()) != null) {
                if (monitor != null && monitor.isCanceled()) {
                    return;
                }
                if (line.startsWith("#")) {
                    if (line.contains("Events:") || line.contains("Samples:")) {
                        String[] tmp = line.trim().split(" ");
                        String event = tmp[tmp.length - 1];
                        if (line.contains("Samples:")) {
                            event = event.substring(1, event.length() - 1);
                        }
                        currentEvent = new PMEvent(event);
                        invisibleRoot.addChild(currentEvent);
                        currentCommand = null;
                        currentDso = null;
                        continue;
                    }
                    if (!line.contains("Samples:")) continue;
                    if (print != null) {
                        print.println("WARNING: You are running an older version of Perf, please update if you can. The plugin may produce unpredictable results.");
                    }
                    invisibleRoot.addChild(new PMEvent("WARNING: You are running an older version of Perf, the plugin may produce unpredictable results."));
                    continue;
                }
                String[] items = line.trim().split("\u0001");
                if (items.length != 5) continue;
                float percent = Float.parseFloat(items[0]);
                double samples = Double.parseDouble(items[1].trim());
                String comm = items[2].trim();
                String dso = items[3].trim();
                String symbol = items[4].trim();
                boolean kernelFlag = ("" + symbol.charAt(1)).equals("k");
                if (!(currentCommand != null && currentCommand.getName().equals(comm) || (currentCommand = (PMCommand)currentEvent.getChild(comm)) != null)) {
                    currentCommand = new PMCommand(comm);
                    currentEvent.addChild(currentCommand);
                }
                if (!(currentDso != null && currentDso.getName().equals(dso) || (currentDso = (PMDso)currentCommand.getChild(dso)) != null)) {
                    currentDso = new PMDso(dso, kernelFlag);
                    currentCommand.addChild(currentDso);
                }
                currentFile = ((PMDso)currentDso).getFile("Unfiled Symbols");
                currentSym = new PMSymbol(symbol, percent, samples);
                currentFile.addChild(currentSym);
            }
        }
        catch (IOException e) {
            PerfCore.logException(e);
        }
        PerfCore.spitStream(error, "Perf Report", print);
        boolean SourceLineNumbers = true;
        boolean Kernel_SourceLineNumbers = false;
        try {
            SourceLineNumbers = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.SourceLineNumbers", true);
            Kernel_SourceLineNumbers = config.getAttribute("org.eclipse.linuxtools.internal.perf.attr.Kernel.SourceLineNumbers", false);
        }
        catch (CoreException coreException) {
            SourceLineNumbers = false;
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        boolean bl = hasProfileData = invisibleRoot.getChildren().length != 0;
        if (SourceLineNumbers) {
            TreeParent[] treeParentArray = invisibleRoot.getChildren();
            int n = treeParentArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeParent ev = treeParentArray[n2];
                if (ev instanceof PMEvent) {
                    TreeParent[] treeParentArray2 = ev.getChildren();
                    int n3 = treeParentArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TreeParent cmd = treeParentArray2[n4];
                        if (cmd instanceof PMCommand) {
                            TreeParent[] treeParentArray3 = cmd.getChildren();
                            int n5 = treeParentArray3.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                TreeParent d = treeParentArray3[n6];
                                if (d instanceof PMDso) {
                                    currentDso = (PMDso)d;
                                    if (Kernel_SourceLineNumbers || !((PMDso)currentDso).isKernelDso()) {
                                        TreeParent[] treeParentArray4 = ((PMDso)currentDso).getFile("Unfiled Symbols").getChildren();
                                        int n7 = treeParentArray4.length;
                                        int n8 = 0;
                                        while (n8 < n7) {
                                            TreeParent s = treeParentArray4[n8];
                                            if (s instanceof PMSymbol) {
                                                String[] annotateCmd;
                                                if (monitor != null && monitor.isCanceled()) {
                                                    return;
                                                }
                                                currentSym = (PMSymbol)s;
                                                if (workingDir == null) {
                                                    annotateCmd = PerfCore.getAnnotateString(config, currentDso.getName(), currentSym.getName().substring(4), perfDataLoc, OldPerfVersion);
                                                } else {
                                                    String perfDefaultDataLoc = workingDir + "/" + "perf.data";
                                                    annotateCmd = PerfCore.getAnnotateString(config, currentDso.getName(), currentSym.getName().substring(4), perfDefaultDataLoc, OldPerfVersion);
                                                }
                                                try {
                                                    p = project == null ? Runtime.getRuntime().exec(annotateCmd) : RuntimeProcessFactory.getFactory().exec(annotateCmd, project);
                                                    input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                                                    error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                                                }
                                                catch (IOException e) {
                                                    PerfCore.logException(e);
                                                }
                                                PerfCore.parseAnnotation(monitor, input, workingDir, (PMDso)currentDso, currentSym);
                                            }
                                            ++n8;
                                        }
                                        if (((PMDso)currentDso).getFile("Unfiled Symbols").getChildren().length == 0) {
                                            currentDso.removeChild(((PMDso)currentDso).getFile("Unfiled Symbols"));
                                        }
                                        PerfCore.spitStream(error, "Perf Annotate", print);
                                    }
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        if (print != null) {
            if (hasProfileData) {
                print.println("Profile data loaded into Perf Profile View.");
            } else {
                print.println("No profile data generated to be displayed.");
            }
        }
    }

    public static void parseAnnotation(IProgressMonitor monitor, BufferedReader input, IPath workingDir, PMDso currentDso, PMSymbol currentSym) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        boolean grabBlock = false;
        boolean blockStarted = false;
        String line = null;
        try {
            while ((line = input.readLine()) != null) {
                String[] items;
                if (line.startsWith("Sorted summary for file")) {
                    grabBlock = true;
                    String dsoName = line.replace("Sorted summary for file ", "");
                    blockStarted = false;
                    if (workingDir != null && dsoName.startsWith("./")) {
                        dsoName = workingDir.toOSString().endsWith("/") ? String.valueOf(workingDir.toOSString()) + dsoName.substring(2) : String.valueOf(workingDir.toOSString()) + dsoName.substring(1);
                    }
                    currentDso.setPath(dsoName);
                    continue;
                }
                if (line.startsWith("---")) {
                    if (blockStarted) {
                        blockStarted = false;
                        grabBlock = false;
                        continue;
                    }
                    blockStarted = true;
                    continue;
                }
                if (!grabBlock || !blockStarted || (items = line.trim().split(" +")).length != 2) continue;
                float percent = Float.parseFloat(items[0]);
                String lineRef = items[1];
                items = lineRef.split(":");
                if (currentDso == null) break;
                int lineNum = -1;
                try {
                    lineNum = Integer.parseInt(items[1]);
                }
                catch (NumberFormatException numberFormatException) {}
                currentSym.addPercent(lineNum, Float.valueOf(percent));
                if (currentSym.getParent().getName().equals("Unfiled Symbols")) {
                    currentSym.getParent().removeChild(currentSym);
                    currentDso.getFile(items[0]).addChild(currentSym);
                    continue;
                }
                if (((PMFile)currentSym.getParent()).getPath().equals(items[0])) continue;
                currentSym.markConflict();
                currentSym.getParent().removeChild(currentSym);
                currentDso.getFile("Symbols conflicting in multiple files").addChild(currentSym);
            }
        }
        catch (IOException e) {
            PerfCore.logException(e);
        }
    }

    public static void RefreshView(final String title) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.perf.ui.ProfileView");
                    PerfProfileView view = PerfPlugin.getDefault().getProfileView();
                    view.setContentDescription(title);
                    view.refreshModel();
                }
                catch (PartInitException e) {
                    PerfCore.logException((Exception)((Object)e));
                }
            }
        });
    }

    public static void logException(Exception e) {
        Status status = new Status(4, "org.eclipse.linuxtools.perf", e.getMessage());
        PerfPlugin.getDefault().getLog().log((IStatus)status);
    }
}

