/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.linuxtools.internal.perf.IPerfData;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public abstract class AbstractDataManipulator
implements IPerfData {
    private String text;
    private String title;
    private File workDir;
    private ILaunch launch;

    AbstractDataManipulator(String title, File workDir) {
        this.title = title;
        this.workDir = workDir;
    }

    @Override
    public String getPerfData() {
        return this.text;
    }

    protected File getWorkDir() {
        return this.workDir;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setLaunch(ILaunch launch) {
        this.launch = launch;
    }

    public void performCommand(String[] cmd, int fd) {
        block33: {
            BufferedReader buffData = null;
            BufferedReader buffTmp = null;
            try {
                try {
                    Process proc;
                    if (this.workDir != null) {
                        Path path = new Path(this.workDir.getAbsolutePath());
                        IFileStore workDirStore = EFS.getLocalFileSystem().getStore((IPath)path);
                        proc = RuntimeProcessFactory.getFactory().exec(cmd, null, workDirStore, null);
                    } else {
                        proc = RuntimeProcessFactory.getFactory().exec(cmd, null);
                    }
                    StringBuffer strBuffData = new StringBuffer();
                    StringBuffer strBuffTmp = new StringBuffer();
                    String line = "";
                    switch (fd) {
                        case 1: {
                            buffData = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                            buffTmp = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                            while ((line = buffData.readLine()) != null) {
                                strBuffData.append(line);
                                strBuffData.append("\n");
                            }
                            while ((line = buffTmp.readLine()) != null) {
                                strBuffTmp.append(line);
                                strBuffTmp.append("\n");
                            }
                            break;
                        }
                        case 2: {
                            buffData = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                            buffTmp = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                            while ((line = buffTmp.readLine()) != null) {
                                strBuffTmp.append(line);
                                strBuffTmp.append("\n");
                            }
                            while ((line = buffData.readLine()) != null) {
                                strBuffData.append(line);
                                strBuffData.append("\n");
                            }
                            break;
                        }
                        default: {
                            buffData = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                            buffTmp = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                            while ((line = buffData.readLine()) != null) {
                                strBuffData.append(line);
                                strBuffData.append("\n");
                            }
                            while ((line = buffTmp.readLine()) != null) {
                                strBuffTmp.append(line);
                                strBuffTmp.append("\n");
                            }
                            break block5;
                        }
                    }
                    this.text = strBuffData.toString();
                    if (this.launch != null) {
                        String configName = this.launch.getLaunchConfiguration().getName();
                        DebugPlugin.newProcess((ILaunch)this.launch, (Process)proc, (String)"");
                        ConsolePlugin plugin = ConsolePlugin.getDefault();
                        IConsoleManager conMan = plugin.getConsoleManager();
                        IConsole[] existing = conMan.getConsoles();
                        IOConsole binaryOutCons = null;
                        IConsole[] iConsoleArray = existing;
                        int n = existing.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IConsole x = iConsoleArray[n2];
                            if (x.getName().contains(configName) && x instanceof IOConsole) {
                                binaryOutCons = (IOConsole)x;
                            }
                            ++n2;
                        }
                        if (binaryOutCons != null) {
                            IOConsoleOutputStream outputTo = binaryOutCons.newOutputStream();
                            PrintStream print = new PrintStream((OutputStream)outputTo);
                            print.println(strBuffTmp.toString());
                        }
                    }
                }
                catch (IOException iOException) {
                    this.text = "";
                    try {
                        if (buffData != null) {
                            buffData.close();
                        }
                        if (buffTmp != null) {
                            buffTmp.close();
                        }
                        break block33;
                    }
                    catch (IOException iOException2) {}
                    break block33;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (buffData != null) {
                        buffData.close();
                    }
                    if (buffTmp != null) {
                        buffTmp.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (buffData != null) {
                    buffData.close();
                }
                if (buffTmp != null) {
                    buffTmp.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public abstract void parse();
}

