/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.trace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.internal.tmf.core.Messages;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.trace.ITmfCheckpoint;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTraceIndexer;
import org.eclipse.linuxtools.tmf.core.trace.TmfCheckpoint;

public class TmfCheckpointIndexer
implements ITmfTraceIndexer {
    protected final ITmfTrace fTrace;
    private final int fCheckpointInterval;
    private boolean fIsIndexing;
    protected final List<ITmfCheckpoint> fTraceIndex;
    private ITmfEventRequest fIndexingRequest = null;

    public TmfCheckpointIndexer(ITmfTrace trace) {
        this(trace, 50000);
    }

    public TmfCheckpointIndexer(ITmfTrace trace, int interval) {
        this.fTrace = trace;
        this.fCheckpointInterval = interval;
        this.fTraceIndex = new ArrayList<ITmfCheckpoint>();
        this.fIsIndexing = false;
    }

    @Override
    public void dispose() {
        if (this.fIndexingRequest != null && !this.fIndexingRequest.isCompleted()) {
            this.fIndexingRequest.cancel();
            this.fTraceIndex.clear();
        }
    }

    @Override
    public boolean isIndexing() {
        return this.fIsIndexing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildIndex(long offset, TmfTimeRange range, boolean waitForCompletion) {
        List<ITmfCheckpoint> list = this.fTraceIndex;
        synchronized (list) {
            if (this.fIsIndexing) {
                return;
            }
            this.fIsIndexing = true;
        }
        final Job job = new Job("Indexing " + this.fTrace.getName() + "..."){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("", -1);
                while (!monitor.isCanceled()) {
                    try {
                        long prevNbEvents = TmfCheckpointIndexer.this.fTrace.getNbEvents();
                        Thread.sleep(250L);
                        long nbEvents = TmfCheckpointIndexer.this.fTrace.getNbEvents();
                        this.setName(String.valueOf(Messages.TmfCheckpointIndexer_Indexing) + ' ' + TmfCheckpointIndexer.this.fTrace.getName() + " (" + nbEvents + ")");
                        long rate = (nbEvents - prevNbEvents) * 4L;
                        monitor.setTaskName(String.valueOf(rate) + " " + Messages.TmfCheckpointIndexer_EventsPerSecond);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.OK_STATUS;
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        this.fIndexingRequest = new TmfEventRequest(ITmfEvent.class, range, offset, Integer.MAX_VALUE, this.fCheckpointInterval, ITmfDataRequest.ExecutionType.BACKGROUND){

            @Override
            public void handleData(ITmfEvent event) {
                super.handleData(event);
                if (event != null && this.getNbRead() % TmfCheckpointIndexer.this.fCheckpointInterval == 0) {
                    this.updateTraceStatus();
                }
            }

            @Override
            public void handleSuccess() {
                this.updateTraceStatus();
            }

            @Override
            public void handleCompleted() {
                job.cancel();
                super.handleCompleted();
                TmfCheckpointIndexer.this.fIsIndexing = false;
            }

            private void updateTraceStatus() {
                if (TmfCheckpointIndexer.this.fTrace.getNbEvents() > 0L) {
                    TmfCheckpointIndexer.this.signalNewTimeRange(TmfCheckpointIndexer.this.fTrace.getStartTime(), TmfCheckpointIndexer.this.fTrace.getEndTime());
                }
            }
        };
        this.fTrace.sendRequest(this.fIndexingRequest);
        if (waitForCompletion) {
            try {
                this.fIndexingRequest.waitForCompletion();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void signalNewTimeRange(ITmfTimestamp startTime, ITmfTimestamp endTime) {
        this.fTrace.broadcast(new TmfTraceUpdatedSignal(this.fTrace, this.fTrace, new TmfTimeRange(startTime, endTime)));
    }

    @Override
    public synchronized void updateIndex(ITmfContext context, ITmfTimestamp timestamp) {
        if (context.getRank() % (long)this.fCheckpointInterval == 0L) {
            long position = context.getRank() / (long)this.fCheckpointInterval;
            if ((long)this.fTraceIndex.size() == position) {
                this.fTraceIndex.add(new TmfCheckpoint(timestamp, context.getLocation()));
            }
        }
    }

    @Override
    public synchronized ITmfContext seekIndex(ITmfTimestamp timestamp) {
        if (timestamp == null) {
            return this.fTrace.seekEvent(0L);
        }
        int index = Collections.binarySearch(this.fTraceIndex, new TmfCheckpoint(timestamp, null));
        index = index < 0 ? Math.max(0, -(index + 2)) : Math.max(0, index - 1);
        return this.restoreCheckpoint(index);
    }

    @Override
    public ITmfContext seekIndex(long rank) {
        if (rank < 0L) {
            return this.fTrace.seekEvent(0L);
        }
        int index = (int)rank / this.fCheckpointInterval;
        return this.restoreCheckpoint(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITmfContext restoreCheckpoint(int checkpoint) {
        ITmfLocation location = null;
        int index = 0;
        List<ITmfCheckpoint> list = this.fTraceIndex;
        synchronized (list) {
            if (!this.fTraceIndex.isEmpty()) {
                index = checkpoint;
                if (index >= this.fTraceIndex.size()) {
                    index = this.fTraceIndex.size() - 1;
                }
                location = this.fTraceIndex.get(index).getLocation();
            }
        }
        ITmfContext context = this.fTrace.seekEvent(location);
        context.setRank((long)index * (long)this.fCheckpointInterval);
        return context;
    }

    protected List<ITmfCheckpoint> getTraceIndex() {
        return this.fTraceIndex;
    }
}

