/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.statesystem;

import java.io.File;
import java.io.IOException;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.HistoryBuilder;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.StateSystem;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.InMemoryBackend;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.NullBackend;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.historytree.HistoryTreeBackend;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.historytree.ThreadedHistoryTreeBackend;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.partial.PartialHistoryBackend;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.partial.PartialStateSystem;
import org.eclipse.linuxtools.tmf.core.component.TmfComponent;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateSystem;

public final class TmfStateSystemFactory
extends TmfComponent {
    private static final int QUEUE_SIZE = 10000;

    private TmfStateSystemFactory() {
    }

    public static ITmfStateSystem newFullHistory(File htFile, ITmfStateProvider stateProvider, boolean buildManually) throws TmfTraceException {
        HistoryBuilder builder;
        if (htFile.exists()) {
            int version = stateProvider == null ? -42 : stateProvider.getVersion();
            try {
                HistoryTreeBackend htBackend = new HistoryTreeBackend(htFile, version);
                return HistoryBuilder.openExistingHistory(htBackend);
            }
            catch (IOException iOException) {}
        }
        if (stateProvider == null) {
            return null;
        }
        try {
            ThreadedHistoryTreeBackend htBackend = new ThreadedHistoryTreeBackend(htFile, stateProvider.getStartTime(), stateProvider.getVersion(), 10000);
            StateSystem ss = new StateSystem(htBackend);
            stateProvider.assignTargetStateSystem(ss);
            builder = new HistoryBuilder(stateProvider, ss, htBackend, buildManually);
        }
        catch (IOException e) {
            throw new TmfTraceException(e.toString(), e);
        }
        return builder.getStateSystemQuerier();
    }

    public static ITmfStateSystem newNullHistory(ITmfStateProvider stateProvider) {
        NullBackend backend = new NullBackend();
        StateSystem ss = new StateSystem(backend);
        stateProvider.assignTargetStateSystem(ss);
        HistoryBuilder builder = new HistoryBuilder(stateProvider, ss, backend, true);
        return builder.getStateSystemQuerier();
    }

    public static ITmfStateSystem newInMemHistory(ITmfStateProvider stateProvider, boolean buildManually) {
        InMemoryBackend backend = new InMemoryBackend(stateProvider.getStartTime());
        StateSystem ss = new StateSystem(backend);
        stateProvider.assignTargetStateSystem(ss);
        HistoryBuilder builder = new HistoryBuilder(stateProvider, ss, backend, buildManually);
        return builder.getStateSystemQuerier();
    }

    public static ITmfStateSystem newPartialHistory(File htFile, ITmfStateProvider realStateProvider, boolean buildManually) throws TmfTraceException {
        ThreadedHistoryTreeBackend realBackend = null;
        try {
            realBackend = new ThreadedHistoryTreeBackend(htFile, realStateProvider.getStartTime(), realStateProvider.getVersion(), 10000);
        }
        catch (IOException e) {
            throw new TmfTraceException(e.toString(), e);
        }
        ITmfStateProvider partialProvider = realStateProvider.getNewInstance();
        PartialStateSystem pss = new PartialStateSystem();
        partialProvider.assignTargetStateSystem(pss);
        PartialHistoryBackend partialBackend = new PartialHistoryBackend(partialProvider, pss, realBackend, 50000L);
        StateSystem realSS = new StateSystem(partialBackend);
        pss.assignUpstream(realSS);
        realStateProvider.assignTargetStateSystem(realSS);
        HistoryBuilder builder = new HistoryBuilder(realStateProvider, realSS, partialBackend, buildManually);
        return builder.getStateSystemQuerier();
    }
}

