/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.ctfadaptor;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfEventField;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTimestamp;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTrace;
import org.eclipse.linuxtools.tmf.core.event.TmfEventField;

public final class CtfTmfEventFactory {
    private static CtfTmfEvent nullEvent = null;

    private CtfTmfEventFactory() {
    }

    public static CtfTmfEvent createEvent(EventDefinition eventDef, String fileName, CtfTmfTrace originTrace) {
        long ts = eventDef.getTimestamp();
        CtfTmfTimestamp timestamp = new CtfTmfTimestamp(originTrace.getCTFTrace().timestampCyclesToNanos(ts));
        int sourceCPU = eventDef.getCPU();
        TmfEventField content = new TmfEventField(":root:", null, CtfTmfEventFactory.parseFields(eventDef));
        String reference = fileName == null ? "No stream" : fileName;
        CtfTmfEvent event = new CtfTmfEvent(originTrace, -1L, timestamp, content, reference, sourceCPU, eventDef.getDeclaration());
        return event;
    }

    public static CtfTmfEvent getNullEvent() {
        if (nullEvent == null) {
            nullEvent = new CtfTmfEvent();
        }
        return nullEvent;
    }

    private static CtfTmfEventField[] parseFields(EventDefinition eventDef) {
        ArrayList<CtfTmfEventField> fields = new ArrayList<CtfTmfEventField>();
        StructDefinition structFields = eventDef.getFields();
        for (Map.Entry entry : structFields.getDefinitions().entrySet()) {
            String curFieldName = (String)entry.getKey();
            Definition curFieldDef = (Definition)entry.getValue();
            CtfTmfEventField curField = CtfTmfEventField.parseField(curFieldDef, curFieldName);
            fields.add(curField);
        }
        StructDefinition structContext = eventDef.getContext();
        if (structContext != null) {
            for (Map.Entry entry : structContext.getDefinitions().entrySet()) {
                String curContextName = "context." + (String)entry.getKey();
                Definition curContextDef = (Definition)entry.getValue();
                CtfTmfEventField curContext = CtfTmfEventField.parseField(curContextDef, curContextName);
                fields.add(curContext);
            }
        }
        return fields.toArray(new CtfTmfEventField[fields.size()]);
    }
}

