/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.statesystem;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.internal.tmf.core.statesystem.backends.IStateHistoryBackend;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.interval.TmfStateInterval;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.core.statevalue.TmfStateValue;

class TransientState {
    private final IStateHistoryBackend backend;
    private boolean isActive;
    private long latestTime;
    private List<ITmfStateValue> ongoingStateInfo;
    private List<Long> ongoingStateStartTimes;
    private List<ITmfStateValue.Type> stateValueTypes;

    TransientState(IStateHistoryBackend backend) {
        this.backend = backend;
        this.isActive = true;
        this.ongoingStateInfo = new ArrayList<ITmfStateValue>();
        this.ongoingStateStartTimes = new ArrayList<Long>();
        this.stateValueTypes = new ArrayList<ITmfStateValue.Type>();
        this.latestTime = backend != null ? backend.getStartTime() : 0L;
    }

    long getLatestTime() {
        return this.latestTime;
    }

    ITmfStateValue getOngoingStateValue(int index) throws AttributeNotFoundException {
        this.checkValidAttribute(index);
        return this.ongoingStateInfo.get(index);
    }

    long getOngoingStartTime(int index) throws AttributeNotFoundException {
        this.checkValidAttribute(index);
        return this.ongoingStateStartTimes.get(index);
    }

    void changeOngoingStateValue(int index, ITmfStateValue newValue) throws AttributeNotFoundException {
        this.checkValidAttribute(index);
        this.ongoingStateInfo.set(index, newValue);
    }

    ITmfStateInterval getOngoingInterval(int quark) throws AttributeNotFoundException {
        this.checkValidAttribute(quark);
        return new TmfStateInterval(this.ongoingStateStartTimes.get(quark), -1L, quark, this.ongoingStateInfo.get(quark));
    }

    private void checkValidAttribute(int quark) throws AttributeNotFoundException {
        if (quark > this.ongoingStateInfo.size() - 1 || quark < 0) {
            throw new AttributeNotFoundException();
        }
    }

    synchronized void replaceOngoingState(List<ITmfStateInterval> newStateIntervals) {
        int size = newStateIntervals.size();
        this.ongoingStateInfo = new ArrayList<ITmfStateValue>(size);
        this.ongoingStateStartTimes = new ArrayList<Long>(size);
        this.stateValueTypes = new ArrayList<ITmfStateValue.Type>(size);
        for (ITmfStateInterval interval : newStateIntervals) {
            this.ongoingStateInfo.add(interval.getStateValue());
            this.ongoingStateStartTimes.add(interval.getStartTime());
            this.stateValueTypes.add(interval.getStateValue().getType());
        }
    }

    synchronized void addEmptyEntry() {
        this.ongoingStateInfo.add(TmfStateValue.nullValue());
        this.stateValueTypes.add(ITmfStateValue.Type.NULL);
        if (this.backend == null) {
            this.ongoingStateStartTimes.add(0L);
        } else {
            this.ongoingStateStartTimes.add(this.backend.getStartTime());
        }
    }

    boolean hasInfoAboutStateOf(long time, int quark) {
        return this.isActive() && time >= this.ongoingStateStartTimes.get(quark);
    }

    synchronized void processStateChange(long eventTime, ITmfStateValue value, int index) throws TimeRangeException, AttributeNotFoundException, StateValueTypeException {
        assert (this.isActive);
        ITmfStateValue.Type expectedSvType = this.stateValueTypes.get(index);
        this.checkValidAttribute(index);
        if (expectedSvType == ITmfStateValue.Type.NULL) {
            this.stateValueTypes.set(index, value.getType());
        } else if (value.getType() != ITmfStateValue.Type.NULL && value.getType() != expectedSvType) {
            throw new StateValueTypeException();
        }
        if (this.latestTime < eventTime) {
            this.latestTime = eventTime;
        }
        if (this.ongoingStateInfo.get(index).equals(value)) {
            return;
        }
        if (this.backend != null && this.ongoingStateStartTimes.get(index) < eventTime) {
            this.backend.insertPastState(this.ongoingStateStartTimes.get(index), eventTime - 1L, index, this.ongoingStateInfo.get(index));
            this.ongoingStateStartTimes.set(index, eventTime);
        }
        this.ongoingStateInfo.set(index, value);
    }

    void doQuery(List<ITmfStateInterval> stateInfo, long t) {
        if (!this.isActive) {
            return;
        }
        assert (stateInfo.size() == this.ongoingStateInfo.size());
        int i = 0;
        while (i < this.ongoingStateInfo.size()) {
            if (this.hasInfoAboutStateOf(t, i)) {
                TmfStateInterval interval = new TmfStateInterval(this.ongoingStateStartTimes.get(i), -1L, i, this.ongoingStateInfo.get(i));
                stateInfo.set(i, interval);
            }
            ++i;
        }
    }

    void closeTransientState(long endTime) {
        assert (this.isActive);
        int i = 0;
        while (i < this.ongoingStateInfo.size()) {
            if (this.ongoingStateStartTimes.get(i) <= endTime) {
                try {
                    this.backend.insertPastState(this.ongoingStateStartTimes.get(i), endTime, i, this.ongoingStateInfo.get(i));
                }
                catch (TimeRangeException e) {
                    throw new IllegalStateException(e);
                }
            }
            ++i;
        }
        this.ongoingStateInfo.clear();
        this.ongoingStateStartTimes.clear();
        this.isActive = false;
    }

    boolean isActive() {
        return this.isActive;
    }

    void setInactive() {
        this.isActive = false;
    }

    void debugPrint(PrintWriter writer) {
        writer.println("------------------------------");
        writer.println("Info stored in the Builder:");
        if (!this.isActive) {
            writer.println("Builder is currently inactive");
            writer.println('\n');
            return;
        }
        writer.println("\nAttribute\tStateValue\tValid since time");
        int i = 0;
        while (i < this.ongoingStateInfo.size()) {
            writer.format("%d\t\t", i);
            writer.print(String.valueOf(this.ongoingStateInfo.get(i).toString()) + "\t\t");
            writer.println(this.ongoingStateStartTimes.get(i).toString());
            ++i;
        }
        writer.println('\n');
    }
}

