/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.statesystem;

import org.eclipse.linuxtools.internal.tmf.core.statesystem.HistoryBuilder;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;

class StateSystemBuildRequest
extends TmfEventRequest {
    private static final int CHUNK_SIZE = 50000;
    private final HistoryBuilder builder;
    private final ITmfStateProvider sci;
    private final ITmfTrace trace;

    StateSystemBuildRequest(HistoryBuilder builder) {
        super(builder.getStateProvider().getExpectedEventType(), TmfTimeRange.ETERNITY, Integer.MAX_VALUE, 50000, ITmfDataRequest.ExecutionType.BACKGROUND);
        this.builder = builder;
        this.sci = builder.getStateProvider();
        this.trace = this.sci.getTrace();
    }

    @Override
    public void handleData(ITmfEvent event) {
        super.handleData(event);
        if (event != null && event.getTrace() == this.trace) {
            this.sci.processEvent(event);
        }
    }

    @Override
    public void handleSuccess() {
        super.handleSuccess();
        this.builder.close(false);
    }

    @Override
    public void handleCancel() {
        super.handleCancel();
        this.builder.close(true);
    }

    @Override
    public void handleFailure() {
        super.handleFailure();
        this.builder.close(true);
    }
}

