/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    public long handle;
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int HANDLE = 8;
    static final int DISABLED = 16;
    static final int MENU = 32;
    static final int OBSCURED = 64;
    static final int MOVED = 128;
    static final int RESIZED = 256;
    static final int ZERO_WIDTH = 512;
    static final int ZERO_HEIGHT = 1024;
    static final int HIDDEN = 2048;
    static final int FOREGROUND = 4096;
    static final int BACKGROUND = 8192;
    static final int FONT = 16384;
    static final int PARENT_BACKGROUND = 32768;
    static final int THEME_BACKGROUND = 65536;
    static final int LAYOUT_NEEDED = 131072;
    static final int LAYOUT_CHANGED = 262144;
    static final int LAYOUT_CHILD = 524288;
    static final int RELEASED = 0x100000;
    static final int DISPOSE_SENT = 0x200000;
    static final int FOREIGN_HANDLE = 0x400000;
    static final int DRAG_DETECT = 0x800000;
    static final int SKIN_NEEDED = 0x1000000;
    static final int CHECK_SUBWINDOW = 0x2000000;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int ACTIVATE = 1;
    static final int BUTTON_PRESS_EVENT = 2;
    static final int BUTTON_PRESS_EVENT_INVERSE = 3;
    static final int BUTTON_RELEASE_EVENT = 4;
    static final int BUTTON_RELEASE_EVENT_INVERSE = 5;
    static final int CHANGED = 6;
    static final int CHANGE_VALUE = 7;
    static final int CLICKED = 8;
    static final int COMMIT = 9;
    static final int CONFIGURE_EVENT = 10;
    static final int DELETE_EVENT = 11;
    static final int DELETE_RANGE = 12;
    static final int DELETE_TEXT = 13;
    static final int ENTER_NOTIFY_EVENT = 14;
    static final int EVENT = 15;
    static final int EVENT_AFTER = 16;
    static final int EXPAND_COLLAPSE_CURSOR_ROW = 17;
    static final int EXPOSE_EVENT = 18;
    static final int DRAW = 18;
    static final int EXPOSE_EVENT_INVERSE = 19;
    static final int FOCUS = 20;
    static final int FOCUS_IN_EVENT = 21;
    static final int FOCUS_OUT_EVENT = 22;
    static final int GRAB_FOCUS = 23;
    static final int HIDE = 24;
    static final int INPUT = 25;
    static final int INSERT_TEXT = 26;
    static final int KEY_PRESS_EVENT = 27;
    static final int KEY_RELEASE_EVENT = 28;
    static final int LEAVE_NOTIFY_EVENT = 29;
    static final int MAP = 30;
    static final int MAP_EVENT = 31;
    static final int MNEMONIC_ACTIVATE = 32;
    static final int MOTION_NOTIFY_EVENT = 33;
    static final int MOTION_NOTIFY_EVENT_INVERSE = 34;
    static final int MOVE_FOCUS = 35;
    static final int OUTPUT = 36;
    static final int POPULATE_POPUP = 37;
    static final int POPUP_MENU = 38;
    static final int PREEDIT_CHANGED = 39;
    static final int REALIZE = 40;
    static final int ROW_ACTIVATED = 41;
    static final int SCROLL_CHILD = 42;
    static final int SCROLL_EVENT = 43;
    static final int SELECT = 44;
    static final int SHOW = 45;
    static final int SHOW_HELP = 46;
    static final int SIZE_ALLOCATE = 47;
    static final int STYLE_SET = 48;
    static final int SWITCH_PAGE = 49;
    static final int TEST_COLLAPSE_ROW = 50;
    static final int TEST_EXPAND_ROW = 51;
    static final int TEXT_BUFFER_INSERT_TEXT = 52;
    static final int TOGGLED = 53;
    static final int UNMAP = 54;
    static final int UNMAP_EVENT = 55;
    static final int UNREALIZE = 56;
    static final int VALUE_CHANGED = 57;
    static final int VISIBILITY_NOTIFY_EVENT = 58;
    static final int WINDOW_STATE_EVENT = 59;
    static final int ACTIVATE_INVERSE = 60;
    static final int DAY_SELECTED = 61;
    static final int MONTH_CHANGED = 62;
    static final int STATUS_ICON_POPUP_MENU = 63;
    static final int ROW_INSERTED = 64;
    static final int ROW_DELETED = 65;
    static final int DAY_SELECTED_DOUBLE_CLICK = 66;
    static final int ICON_RELEASE = 67;
    static final int SELECTION_DONE = 68;
    static final int START_INTERACTIVE_SEARCH = 69;
    static final int BACKSPACE = 70;
    static final int BACKSPACE_INVERSE = 71;
    static final int COPY_CLIPBOARD = 72;
    static final int COPY_CLIPBOARD_INVERSE = 73;
    static final int CUT_CLIPBOARD = 74;
    static final int CUT_CLIPBOARD_INVERSE = 75;
    static final int PASTE_CLIPBOARD = 76;
    static final int PASTE_CLIPBOARD_INVERSE = 77;
    static final int DELETE_FROM_CURSOR = 78;
    static final int DELETE_FROM_CURSOR_INVERSE = 79;
    static final int MOVE_CURSOR = 80;
    static final int MOVE_CURSOR_INVERSE = 81;
    static final int DIRECTION_CHANGED = 82;
    static final int CREATE_MENU_PROXY = 83;
    static final int LAST_SIGNAL = 84;
    static final String IS_ACTIVE = "org.eclipse.swt.internal.control.isactive";
    static final String KEY_CHECK_SUBWINDOW = "org.eclipse.swt.internal.control.checksubwindow";

    Widget() {
    }

    public Widget(Widget parent, int style) {
        this.checkSubclass();
        this.checkParent(parent);
        this.style = style;
        this.display = parent.display;
        this.reskinWidget();
    }

    void _addListener(int eventType, Listener listener) {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    public void addListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._addListener(eventType, listener);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(12, typedListener);
    }

    long paintWindow() {
        return 0L;
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        if ((style & int3) != 0) {
            style = style & ~mask | int3;
        }
        if ((style & int4) != 0) {
            style = style & ~mask | int4;
        }
        if ((style & int5) != 0) {
            style = style & ~mask | int5;
        }
        return style;
    }

    long cellDataProc(long tree_column, long cell, long tree_model, long iter, long data) {
        return 0L;
    }

    void checkOpen() {
    }

    void checkOrientation(Widget parent) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && parent != null) {
            if ((parent.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((parent.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
        if (OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
            this.style &= 0xFBFFFFFF;
            this.style |= 0x2000000;
        }
    }

    void checkParent(Widget parent) {
        if (parent == null) {
            this.error(4);
        }
        if (parent.isDisposed()) {
            this.error(5);
        }
        parent.checkWidget();
        parent.checkOpen();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    void createHandle(int index) {
    }

    void createWidget(int index) {
        this.createHandle(index);
        this.setOrientation(true);
        this.hookEvents();
        this.register();
    }

    void deregister() {
        if (this.handle == 0L) {
            return;
        }
        if ((this.state & 8) != 0) {
            this.display.removeWidget(this.handle);
        }
    }

    void destroyWidget() {
        long topHandle = this.topHandle();
        this.releaseHandle();
        if (topHandle != 0L && (this.state & 8) != 0) {
            OS.gtk_widget_destroy(topHandle);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    void error(int code) {
        SWT.error(code);
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String key) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        if (key.equals(KEY_CHECK_SUBWINDOW)) {
            return new Boolean((this.state & 0x2000000) != 0);
        }
        if (key.equals(IS_ACTIVE)) {
            return new Boolean(this.isActive());
        }
        if ((this.state & 4) != 0) {
            Object[] table = (Object[])this.data;
            for (int i = 1; i < table.length; i += 2) {
                if (!key.equals(table[i])) continue;
                return table[i + 1];
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    public Listener[] getListeners(int eventType) {
        this.checkWidget();
        if (this.eventTable == null) {
            return new Listener[0];
        }
        return this.eventTable.getListeners(eventType);
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.length();
        while (--index > 0 && string.charAt(index) != '.') {
        }
        return string.substring(index + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    long gtk_activate(long widget) {
        return 0L;
    }

    void gtk_adjustment_get(long hAdjustment, GtkAdjustment adjustment) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            adjustment.lower = OS.gtk_adjustment_get_lower(hAdjustment);
            adjustment.upper = OS.gtk_adjustment_get_upper(hAdjustment);
            adjustment.page_increment = OS.gtk_adjustment_get_page_increment(hAdjustment);
            adjustment.step_increment = OS.gtk_adjustment_get_step_increment(hAdjustment);
            adjustment.page_size = OS.gtk_adjustment_get_page_size(hAdjustment);
            adjustment.value = OS.gtk_adjustment_get_value(hAdjustment);
        } else {
            OS.memmove(adjustment, hAdjustment);
        }
    }

    double gtk_adjustment_get_step_increment(long hAdjustment) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            return (int)OS.gtk_adjustment_get_step_increment(hAdjustment);
        }
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, hAdjustment);
        return (int)adjustment.step_increment;
    }

    double gtk_adjustment_get_page_increment(long hAdjustment) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            return (int)OS.gtk_adjustment_get_page_increment(hAdjustment);
        }
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, hAdjustment);
        return (int)adjustment.page_increment;
    }

    double gtk_adjustment_get_lower(long hAdjustment) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            return (int)OS.gtk_adjustment_get_lower(hAdjustment);
        }
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, hAdjustment);
        return (int)adjustment.lower;
    }

    double gtk_adjustment_get_upper(long hAdjustment) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            return (int)OS.gtk_adjustment_get_upper(hAdjustment);
        }
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, hAdjustment);
        return (int)adjustment.upper;
    }

    double gtk_adjustment_get_page_size(long hAdjustment) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            return (int)OS.gtk_adjustment_get_page_size(hAdjustment);
        }
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, hAdjustment);
        return (int)adjustment.page_size;
    }

    double gtk_adjustment_get_value(long hAdjustment) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            return (int)OS.gtk_adjustment_get_value(hAdjustment);
        }
        GtkAdjustment adjustment = new GtkAdjustment();
        OS.memmove(adjustment, hAdjustment);
        return (int)adjustment.value;
    }

    void gtk_adjustment_configure(long hAdjustment, GtkAdjustment a) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            OS.gtk_adjustment_configure(hAdjustment, a.value, a.lower, a.upper, a.step_increment, a.page_increment, a.page_size);
        } else {
            OS.memmove(hAdjustment, a);
            OS.gtk_adjustment_changed(hAdjustment);
        }
    }

    long gtk_button_press_event(long widget, long event) {
        return 0L;
    }

    long gtk_button_release_event(long widget, long event) {
        return 0L;
    }

    long gtk_changed(long widget) {
        return 0L;
    }

    long gtk_change_value(long widget, long scroll, long value1, long value2) {
        return 0L;
    }

    long gtk_clicked(long widget) {
        return 0L;
    }

    long gtk_commit(long imcontext, long text) {
        return 0L;
    }

    long gtk_configure_event(long widget, long event) {
        return 0L;
    }

    long gtk_create_menu_proxy(long widget) {
        return 0L;
    }

    long gtk_day_selected(long widget) {
        return 0L;
    }

    long gtk_day_selected_double_click(long widget) {
        return 0L;
    }

    long gtk_delete_event(long widget, long event) {
        return 0L;
    }

    long gtk_delete_range(long widget, long iter1, long iter2) {
        return 0L;
    }

    long gtk_delete_text(long widget, long start_pos, long end_pos) {
        return 0L;
    }

    long gtk_enter_notify_event(long widget, long event) {
        return 0L;
    }

    long gtk_event(long widget, long event) {
        return 0L;
    }

    long gtk_event_after(long widget, long event) {
        return 0L;
    }

    long gtk_expand_collapse_cursor_row(long widget, long logical, long expand, long open_all) {
        return 0L;
    }

    long gtk_draw(long widget, long cairo) {
        return 0L;
    }

    long gtk_expose_event(long widget, long event) {
        return 0L;
    }

    long gtk_focus(long widget, long event) {
        return 0L;
    }

    long gtk_focus_in_event(long widget, long event) {
        return 0L;
    }

    long gtk_focus_out_event(long widget, long event) {
        return 0L;
    }

    long gtk_grab_focus(long widget) {
        return 0L;
    }

    long gtk_hide(long widget) {
        return 0L;
    }

    long gtk_icon_release(long widget, long icon_pos, long event) {
        return 0L;
    }

    long gtk_input(long widget, long arg1) {
        return 0L;
    }

    long gtk_insert_text(long widget, long new_text, long new_text_length, long position) {
        return 0L;
    }

    long gtk_key_press_event(long widget, long event) {
        GdkEventKey gdkEvent = new GdkEventKey();
        OS.memmove(gdkEvent, event, (long)GdkEventKey.sizeof);
        return this.sendKeyEvent(1, gdkEvent) ? 0L : 1L;
    }

    long gtk_key_release_event(long widget, long event) {
        GdkEventKey gdkEvent = new GdkEventKey();
        OS.memmove(gdkEvent, event, (long)GdkEventKey.sizeof);
        return this.sendKeyEvent(2, gdkEvent) ? 0L : 1L;
    }

    long gtk_leave_notify_event(long widget, long event) {
        return 0L;
    }

    long gtk_map(long widget) {
        return 0L;
    }

    long gtk_map_event(long widget, long event) {
        return 0L;
    }

    long gtk_mnemonic_activate(long widget, long arg1) {
        return 0L;
    }

    long gtk_month_changed(long widget) {
        return 0L;
    }

    long gtk_motion_notify_event(long widget, long event) {
        return 0L;
    }

    long gtk_move_focus(long widget, long event) {
        return 0L;
    }

    long gtk_output(long widget) {
        return 0L;
    }

    long gtk_populate_popup(long widget, long menu) {
        return 0L;
    }

    long gtk_popup_menu(long widget) {
        return 0L;
    }

    long gtk_preedit_changed(long imcontext) {
        return 0L;
    }

    long gtk_realize(long widget) {
        return 0L;
    }

    long gtk_row_activated(long tree, long path, long column) {
        return 0L;
    }

    long gtk_row_deleted(long model, long path) {
        return 0L;
    }

    long gtk_row_inserted(long model, long path, long iter) {
        return 0L;
    }

    long gtk_scroll_child(long widget, long scrollType, long horizontal) {
        return 0L;
    }

    long gtk_scroll_event(long widget, long event) {
        return 0L;
    }

    long gtk_select(long item) {
        return 0L;
    }

    long gtk_selection_done(long menushell) {
        return 0L;
    }

    long gtk_show(long widget) {
        return 0L;
    }

    long gtk_show_help(long widget, long helpType) {
        return 0L;
    }

    long gtk_size_allocate(long widget, long allocation) {
        return 0L;
    }

    long gtk_status_icon_popup_menu(long handle, long button, long activate_time) {
        return 0L;
    }

    long gtk_start_interactive_search(long widget) {
        return 0L;
    }

    long gtk_style_set(long widget, long previousStyle) {
        return 0L;
    }

    long gtk_switch_page(long widget, long page, long page_num) {
        return 0L;
    }

    long gtk_test_collapse_row(long tree, long iter, long path) {
        return 0L;
    }

    long gtk_test_expand_row(long tree, long iter, long path) {
        return 0L;
    }

    long gtk_text_buffer_insert_text(long widget, long iter, long text, long length) {
        return 0L;
    }

    long gtk_timer() {
        return 0L;
    }

    long gtk_toggled(long renderer, long pathStr) {
        return 0L;
    }

    long gtk_unmap(long widget) {
        return 0L;
    }

    long gtk_unmap_event(long widget, long event) {
        return 0L;
    }

    long gtk_unrealize(long widget) {
        return 0L;
    }

    long gtk_value_changed(long adjustment) {
        return 0L;
    }

    long gtk_visibility_notify_event(long widget, long event) {
        return 0L;
    }

    void gtk_widget_get_allocation(long widget, GtkAllocation allocation) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            OS.gtk_widget_get_allocation(widget, allocation);
        } else {
            allocation.x = OS.GTK_WIDGET_X(widget);
            allocation.y = OS.GTK_WIDGET_Y(widget);
            allocation.width = OS.GTK_WIDGET_WIDTH(widget);
            allocation.height = OS.GTK_WIDGET_HEIGHT(widget);
        }
    }

    boolean gtk_widget_get_mapped(long widget) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 20, 0)) {
            return OS.gtk_widget_get_mapped(widget);
        }
        return OS.GTK_WIDGET_MAPPED(widget);
    }

    boolean gtk_widget_has_focus(long widget) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            return OS.gtk_widget_has_focus(widget);
        }
        return OS.GTK_WIDGET_HAS_FOCUS(widget);
    }

    long gtk_window_state_event(long widget, long event) {
        return 0L;
    }

    int fontHeight(long font, long widgetHandle) {
        long context = OS.gtk_widget_get_pango_context(widgetHandle);
        long lang = OS.pango_context_get_language(context);
        long metrics = OS.pango_context_get_metrics(context, font, lang);
        int ascent = OS.pango_font_metrics_get_ascent(metrics);
        int descent = OS.pango_font_metrics_get_descent(metrics);
        OS.pango_font_metrics_unref(metrics);
        return OS.PANGO_PIXELS(ascent + descent);
    }

    long filterProc(long xEvent, long gdkEvent, long data2) {
        return 0L;
    }

    boolean filters(int eventType) {
        return this.display.filters(eventType);
    }

    long fixedMapProc(long widget) {
        return 0L;
    }

    long fixedSizeAllocateProc(long widget, long allocationPtr) {
        return OS.Call(Display.oldFixedSizeAllocateProc, widget, allocationPtr);
    }

    char[] fixMnemonic(String string) {
        return this.fixMnemonic(string, true);
    }

    char[] fixMnemonic(String string, boolean replace) {
        int length = string.length();
        char[] text = new char[length];
        string.getChars(0, length, text, 0);
        int i = 0;
        int j = 0;
        char[] result = new char[length * 2];
        block4: while (i < length) {
            switch (text[i]) {
                case '&': {
                    if (i + 1 < length && text[i + 1] == '&') {
                        result[j++] = text[i++];
                    } else if (replace) {
                        result[j++] = 95;
                    }
                    ++i;
                    continue block4;
                }
                case '_': {
                    if (!replace) break;
                    result[j++] = 95;
                }
            }
            result[j++] = text[i++];
        }
        return result;
    }

    boolean isActive() {
        return true;
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    public boolean isListening(int eventType) {
        this.checkWidget();
        return this.hooks(eventType);
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    void hookEvents() {
    }

    boolean hooks(int eventType) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(eventType);
    }

    long hoverProc(long widget) {
        return 0L;
    }

    long menuPositionProc(long menu, long x, long y, long push_in, long user_data) {
        return 0L;
    }

    boolean mnemonicHit(long mnemonicHandle, char key) {
        if (!this.mnemonicMatch(mnemonicHandle, key)) {
            return false;
        }
        OS.g_signal_handlers_block_matched(mnemonicHandle, 16, 0, 0, 0L, 0L, 32L);
        boolean result = OS.gtk_widget_mnemonic_activate(mnemonicHandle, false);
        OS.g_signal_handlers_unblock_matched(mnemonicHandle, 16, 0, 0, 0L, 0L, 32L);
        return result;
    }

    boolean mnemonicMatch(long mnemonicHandle, char key) {
        int keyval2;
        int keyval1 = OS.gdk_keyval_to_lower(OS.gdk_unicode_to_keyval(key));
        return keyval1 == (keyval2 = OS.gdk_keyval_to_lower(OS.gtk_label_get_mnemonic_keyval(mnemonicHandle)));
    }

    void modifyStyle(long handle, long style) {
        OS.gtk_widget_modify_style(handle, style);
    }

    public void notifyListeners(int eventType, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(eventType, event);
    }

    void postEvent(int eventType) {
        this.sendEvent(eventType, null, false);
    }

    void postEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, false);
    }

    void register() {
        if (this.handle == 0L) {
            return;
        }
        if ((this.state & 8) != 0) {
            this.display.addWidget(this.handle, this);
        }
    }

    void release(boolean destroy) {
        if ((this.state & 0x200000) == 0) {
            this.state |= 0x200000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(destroy);
        }
        if ((this.state & 0x100000) == 0) {
            this.state |= 0x100000;
            if (destroy) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    void releaseChildren(boolean destroy) {
    }

    void releaseHandle() {
        this.handle = 0L;
        this.state |= 1;
        this.display = null;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.deregister();
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    protected void removeListener(int eventType, SWTEventListener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    long rendererGetPreferredWidthProc(long cell, long handle, long minimun_size, long natural_size) {
        return 0L;
    }

    long rendererGetSizeProc(long cell, long handle, long cell_area, long x_offset, long y_offset, long width, long height) {
        return 0L;
    }

    long rendererRenderProc(long cell, long cr, long handle, long background_area, long cell_area, long flags) {
        return 0L;
    }

    long rendererRenderProc(long cell, long window, long handle, long background_area, long cell_area, long expose_area, long flags) {
        return 0L;
    }

    public void reskin(int flags) {
        this.checkWidget();
        this.reskinWidget();
        if ((flags & 1) != 0) {
            this.reskinChildren(flags);
        }
    }

    void reskinChildren(int flags) {
    }

    void reskinWidget() {
        if ((this.state & 0x1000000) != 0x1000000) {
            this.state |= 0x1000000;
            this.display.addSkinnableWidget(this);
        }
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, listener);
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void sendEvent(int eventType) {
        this.sendEvent(eventType, null, true);
    }

    void sendEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, true);
    }

    void sendEvent(int eventType, Event event, boolean send) {
        if (this.eventTable == null && !this.display.filters(eventType)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = eventType;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (send) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    boolean sendKeyEvent(int type, GdkEventKey keyEvent) {
        int length = keyEvent.length;
        if (keyEvent.string == 0L || OS.g_utf16_strlen(keyEvent.string, length) <= 1L) {
            Event event = new Event();
            event.time = keyEvent.time;
            if (!this.setKeyState(event, keyEvent)) {
                return true;
            }
            this.sendEvent(type, event);
            if (this.isDisposed()) {
                return false;
            }
            return event.doit;
        }
        byte[] buffer = new byte[length];
        OS.memmove(buffer, keyEvent.string, (long)length);
        char[] chars = Converter.mbcsToWcs(null, buffer);
        return this.sendIMKeyEvent(type, keyEvent, chars) != null;
    }

    char[] sendIMKeyEvent(int type, GdkEventKey keyEvent, char[] chars) {
        int index = 0;
        int count = 0;
        int state = 0;
        long ptr = 0L;
        if (keyEvent == null && (ptr = OS.gtk_get_current_event()) != 0L) {
            keyEvent = new GdkEventKey();
            OS.memmove(keyEvent, ptr, (long)GdkEventKey.sizeof);
            switch (keyEvent.type) {
                case 8: 
                case 9: {
                    state = keyEvent.state;
                    break;
                }
                default: {
                    keyEvent = null;
                }
            }
        }
        if (keyEvent == null) {
            int[] buffer = new int[1];
            OS.gtk_get_current_event_state(buffer);
            state = buffer[0];
        }
        while (index < chars.length) {
            Event event = new Event();
            if (keyEvent != null && chars.length <= 1) {
                this.setKeyState(event, keyEvent);
            } else {
                this.setInputState(event, state);
            }
            event.character = chars[index];
            this.sendEvent(type, event);
            if (this.isDisposed()) {
                if (ptr != 0L) {
                    OS.gdk_event_free(ptr);
                }
                return null;
            }
            if (event.doit) {
                chars[count++] = chars[index];
            }
            ++index;
        }
        if (ptr != 0L) {
            OS.gdk_event_free(ptr);
        }
        if (count == 0) {
            return null;
        }
        if (index != count) {
            char[] result = new char[count];
            System.arraycopy(chars, 0, result, 0, count);
            return result;
        }
        return chars;
    }

    void sendSelectionEvent(int eventType) {
        this.sendSelectionEvent(eventType, null, false);
    }

    void sendSelectionEvent(int eventType, Event event, boolean send) {
        long ptr;
        if (this.eventTable == null && !this.display.filters(eventType)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        if ((ptr = OS.gtk_get_current_event()) != 0L) {
            GdkEvent gdkEvent = new GdkEvent();
            OS.memmove(gdkEvent, ptr, (long)GdkEvent.sizeof);
            switch (gdkEvent.type) {
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: {
                    int[] state = new int[1];
                    OS.gdk_event_get_state(ptr, state);
                    this.setInputState(event, state[0]);
                    break;
                }
            }
            OS.gdk_event_free(ptr);
        }
        this.sendEvent(eventType, event, send);
    }

    public void setData(Object data) {
        this.checkWidget();
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = data;
        } else {
            this.data = data;
        }
    }

    public void setData(String key, Object value) {
        int index;
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        if (key.equals(KEY_CHECK_SUBWINDOW)) {
            if (value != null && value instanceof Boolean) {
                this.state = ((Boolean)value).booleanValue() ? (this.state |= 0x2000000) : (this.state &= 0xFDFFFFFF);
            }
            return;
        }
        Object[] table = null;
        if ((this.state & 4) != 0) {
            table = (Object[])this.data;
            for (index = 1; index < table.length && !key.equals(table[index]); index += 2) {
            }
        }
        if (value != null) {
            if ((this.state & 4) != 0) {
                if (index == table.length) {
                    Object[] newTable = new Object[table.length + 2];
                    System.arraycopy(table, 0, newTable, 0, table.length);
                    table = newTable;
                    this.data = newTable;
                }
            } else {
                table = new Object[3];
                table[0] = this.data;
                this.data = table;
                this.state |= 4;
            }
            table[index] = key;
            table[index + 1] = value;
        } else if ((this.state & 4) != 0 && index != table.length) {
            int length = table.length - 2;
            if (length == 1) {
                this.data = table[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] newTable = new Object[length];
                System.arraycopy(table, 0, newTable, 0, index);
                System.arraycopy(table, index + 2, newTable, index, length - index);
                this.data = newTable;
            }
        }
        if (key.equals("org.eclipse.swt.skin.class") || key.equals("org.eclipse.swt.skin.id")) {
            this.reskin(1);
        }
    }

    void setFontDescription(long widget, long font) {
        if (OS.GTK3) {
            OS.gtk_widget_override_font(widget, font);
            long context = OS.gtk_widget_get_style_context(this.handle);
            OS.gtk_style_context_invalidate(context);
        } else {
            OS.gtk_widget_modify_font(widget, font);
        }
    }

    void setForegroundColor(long handle, GdkColor color) {
        this.setForegroundColor(handle, color, true);
    }

    void setForegroundColor(long handle, GdkColor color, boolean setStateActive) {
        if (OS.GTK3) {
            GdkRGBA rgba = null;
            if (color != null) {
                rgba = new GdkRGBA();
                rgba.alpha = 1.0;
                rgba.red = (float)(color.red & 0xFFFF) / 65535.0f;
                rgba.green = (float)(color.green & 0xFFFF) / 65535.0f;
                rgba.blue = (float)(color.blue & 0xFFFF) / 65535.0f;
            }
            OS.gtk_widget_override_color(handle, 0, rgba);
            long context = OS.gtk_widget_get_style_context(handle);
            OS.gtk_style_context_invalidate(context);
            return;
        }
        long style = OS.gtk_widget_get_modifier_style(handle);
        OS.gtk_rc_style_set_fg(style, 0, color);
        if (setStateActive) {
            OS.gtk_rc_style_set_fg(style, 1, color);
        }
        OS.gtk_rc_style_set_fg(style, 2, color);
        int flags = OS.gtk_rc_style_get_color_flags(style, 0);
        flags = color == null ? flags & 0xFFFFFFFE : flags | 1;
        OS.gtk_rc_style_set_color_flags(style, 0, flags);
        if (setStateActive) {
            flags = OS.gtk_rc_style_get_color_flags(style, 1);
            flags = color == null ? flags & 0xFFFFFFFE : flags | 1;
            OS.gtk_rc_style_set_color_flags(style, 1, flags);
        }
        flags = OS.gtk_rc_style_get_color_flags(style, 2);
        flags = color == null ? flags & 0xFFFFFFFE : flags | 1;
        OS.gtk_rc_style_set_color_flags(style, 2, flags);
        OS.gtk_rc_style_set_text(style, 0, color);
        if (setStateActive) {
            OS.gtk_rc_style_set_text(style, 1, color);
        }
        OS.gtk_rc_style_set_text(style, 2, color);
        flags = OS.gtk_rc_style_get_color_flags(style, 0);
        flags = color == null ? flags & 0xFFFFFFFB : flags | 4;
        OS.gtk_rc_style_set_color_flags(style, 0, flags);
        flags = OS.gtk_rc_style_get_color_flags(style, 2);
        flags = color == null ? flags & 0xFFFFFFFB : flags | 4;
        OS.gtk_rc_style_set_color_flags(style, 2, flags);
        if (setStateActive) {
            flags = OS.gtk_rc_style_get_color_flags(style, 1);
            flags = color == null ? flags & 0xFFFFFFFB : flags | 4;
            OS.gtk_rc_style_set_color_flags(style, 1, flags);
        }
        this.modifyStyle(handle, style);
    }

    boolean setInputState(Event event, int state) {
        if ((state & 8) != 0) {
            event.stateMask |= 0x10000;
        }
        if ((state & 1) != 0) {
            event.stateMask |= 0x20000;
        }
        if ((state & 4) != 0) {
            event.stateMask |= 0x40000;
        }
        if ((state & 0x100) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((state & 0x200) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((state & 0x400) != 0) {
            event.stateMask |= 0x200000;
        }
        return true;
    }

    boolean setKeyState(Event event, GdkEventKey keyEvent) {
        if (keyEvent.string != 0L && OS.g_utf16_strlen(keyEvent.string, keyEvent.length) > 1L) {
            return false;
        }
        boolean isNull = false;
        event.keyCode = Display.translateKey(keyEvent.keyval);
        switch (keyEvent.keyval) {
            case 65288: {
                event.character = (char)8;
                break;
            }
            case 65290: {
                event.character = (char)10;
                break;
            }
            case 65293: 
            case 65421: {
                event.character = (char)13;
                break;
            }
            case 65439: 
            case 65535: {
                event.character = (char)127;
                break;
            }
            case 65307: {
                event.character = (char)27;
                break;
            }
            case 65056: 
            case 65289: {
                event.character = (char)9;
                break;
            }
            default: {
                if (event.keyCode == 0) {
                    int[] keyval = new int[1];
                    int[] effective_group = new int[1];
                    int[] level = new int[1];
                    int[] consumed_modifiers = new int[1];
                    if (OS.gdk_keymap_translate_keyboard_state(OS.gdk_keymap_get_default(), keyEvent.hardware_keycode, 0, keyEvent.group, keyval, effective_group, level, consumed_modifiers)) {
                        event.keyCode = OS.gdk_keyval_to_unicode(keyval[0]);
                    }
                }
                int key = keyEvent.keyval;
                if ((keyEvent.state & 4) != 0 && 0 <= key && key <= 127) {
                    if (97 <= key && key <= 122) {
                        key -= 32;
                    }
                    if (64 <= key && key <= 95) {
                        key -= 64;
                    }
                    event.character = (char)key;
                    isNull = keyEvent.keyval == 64 && key == 0;
                    break;
                }
                event.character = (char)OS.gdk_keyval_to_unicode(key);
            }
        }
        this.setLocationState(event, keyEvent);
        if (event.keyCode == 0 && event.character == '\u0000' && !isNull) {
            return false;
        }
        return this.setInputState(event, keyEvent.state);
    }

    void setLocationState(Event event, GdkEventKey keyEvent) {
        switch (keyEvent.keyval) {
            case 65505: 
            case 65507: 
            case 65513: {
                event.keyLocation = 16384;
                break;
            }
            case 65506: 
            case 65508: 
            case 65514: {
                event.keyLocation = 131072;
                break;
            }
            case 65407: 
            case 65421: 
            case 65429: 
            case 65430: 
            case 65431: 
            case 65432: 
            case 65433: 
            case 65434: 
            case 65435: 
            case 65436: 
            case 65438: 
            case 65439: 
            case 65450: 
            case 65451: 
            case 65453: 
            case 65454: 
            case 65455: 
            case 65456: 
            case 65457: 
            case 65458: 
            case 65459: 
            case 65460: 
            case 65461: 
            case 65462: 
            case 65463: 
            case 65464: 
            case 65465: 
            case 65469: {
                event.keyLocation = 2;
            }
        }
    }

    void setOrientation(boolean create) {
    }

    boolean setTabGroupFocus(boolean next) {
        return this.setTabItemFocus(next);
    }

    boolean setTabItemFocus(boolean next) {
        return false;
    }

    long shellMapProc(long handle, long arg0, long user_data) {
        return 0L;
    }

    long sizeAllocateProc(long handle, long arg0, long user_data) {
        return 0L;
    }

    long sizeRequestProc(long handle, long arg0, long user_data) {
        return 0L;
    }

    long g_object_ref_sink(long object) {
        if (OS.GLIB_VERSION >= OS.VERSION(2, 10, 0)) {
            return OS.g_object_ref_sink(object);
        }
        OS.gtk_object_sink(object);
        return 0L;
    }

    boolean gtk_widget_get_sensitive(long widget) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            return OS.gtk_widget_get_sensitive(widget);
        }
        return OS.GTK_WIDGET_SENSITIVE(widget);
    }

    boolean gtk_widget_get_visible(long widget) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            return OS.gtk_widget_get_visible(widget);
        }
        return (OS.GTK_WIDGET_FLAGS(widget) & 0x100) != 0;
    }

    boolean gtk_widget_get_realized(long widget) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 20, 0)) {
            return OS.gtk_widget_get_realized(widget);
        }
        return (OS.GTK_WIDGET_FLAGS(widget) & 0x40) != 0;
    }

    boolean gtk_widget_get_can_default(long widget) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            return OS.gtk_widget_get_can_default(widget);
        }
        return (OS.GTK_WIDGET_FLAGS(widget) & 0x2000) != 0;
    }

    boolean gtk_widget_get_has_window(long widget) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            return OS.gtk_widget_get_has_window(widget);
        }
        return (OS.GTK_WIDGET_FLAGS(widget) & 0x20) == 0;
    }

    long gtk_widget_get_window(long widget) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            return OS.gtk_widget_get_window(widget);
        }
        return OS.GTK_WIDGET_WINDOW(widget);
    }

    void gtk_widget_set_can_default(long widget, boolean can_default) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            OS.gtk_widget_set_can_default(widget, can_default);
        } else if (can_default) {
            OS.GTK_WIDGET_SET_FLAGS(widget, 8192);
        } else {
            OS.GTK_WIDGET_UNSET_FLAGS(widget, 8192);
        }
    }

    void gtk_widget_set_can_focus(long widget, boolean can_focus) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            OS.gtk_widget_set_can_focus(widget, can_focus);
        } else if (can_focus) {
            OS.GTK_WIDGET_SET_FLAGS(widget, 2048);
        } else {
            OS.GTK_WIDGET_UNSET_FLAGS(widget, 2048);
        }
    }

    void gtk_widget_set_mapped(long widget, boolean mapped) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 20, 0)) {
            OS.gtk_widget_set_mapped(widget, mapped);
        } else if (mapped) {
            OS.GTK_WIDGET_SET_FLAGS(widget, 128);
        } else {
            OS.GTK_WIDGET_UNSET_FLAGS(widget, 128);
        }
    }

    void gtk_widget_set_visible(long widget, boolean visible) {
        if (OS.GTK3) {
            OS.gtk_widget_set_visible(widget, visible);
        } else if (visible) {
            OS.GTK_WIDGET_SET_FLAGS(widget, 256);
        } else {
            OS.GTK_WIDGET_UNSET_FLAGS(widget, 256);
        }
    }

    void gtk_widget_set_receives_default(long widget, boolean receives_default) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 18, 0)) {
            OS.gtk_widget_set_receives_default(widget, receives_default);
        } else if (receives_default) {
            OS.GTK_WIDGET_SET_FLAGS(widget, 0x100000);
        } else {
            OS.GTK_WIDGET_UNSET_FLAGS(widget, 0x100000);
        }
    }

    void gdk_pixmap_get_size(long pixmap, int[] width, int[] height) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
            OS.gdk_pixmap_get_size(pixmap, width, height);
        } else {
            OS.gdk_drawable_get_size(pixmap, width, height);
        }
    }

    void gdk_window_get_size(long drawable, int[] width, int[] height) {
        if (OS.GTK_VERSION >= OS.VERSION(2, 24, 0)) {
            width[0] = OS.gdk_window_get_width(drawable);
            height[0] = OS.gdk_window_get_height(drawable);
        } else {
            OS.gdk_drawable_get_size(drawable, width, height);
        }
    }

    long gtk_box_new(int orientation, boolean homogeneous, int spacing) {
        long box = 0L;
        if (OS.GTK3) {
            box = OS.gtk_box_new(orientation, spacing);
            OS.gtk_box_set_homogeneous(box, homogeneous);
        } else {
            box = orientation == 0 ? OS.gtk_hbox_new(homogeneous, spacing) : OS.gtk_vbox_new(homogeneous, spacing);
        }
        return box;
    }

    int gdk_pointer_grab(long window, int grab_ownership, boolean owner_events, int event_mask, long confine_to, long cursor, int time_) {
        if (OS.GTK3) {
            long display = 0L;
            if (window != 0L) {
                display = OS.gdk_window_get_display(window);
            } else {
                window = OS.gdk_get_default_root_window();
                display = OS.gdk_window_get_display(window);
            }
            long device_manager = OS.gdk_display_get_device_manager(display);
            long pointer = OS.gdk_device_manager_get_client_pointer(device_manager);
            return OS.gdk_device_grab(pointer, window, grab_ownership, owner_events, event_mask, cursor, time_);
        }
        return OS.gdk_pointer_grab(window, owner_events, event_mask, confine_to, cursor, time_);
    }

    void gdk_pointer_ungrab(long window, int time_) {
        if (OS.GTK3) {
            long display = OS.gdk_window_get_display(window);
            long device_manager = OS.gdk_display_get_device_manager(display);
            long pointer = OS.gdk_device_manager_get_client_pointer(device_manager);
            OS.gdk_device_ungrab(pointer, time_);
        } else {
            OS.gdk_pointer_ungrab(time_);
        }
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return this.getName() + " {" + string + "}";
    }

    long topHandle() {
        return this.handle;
    }

    long timerProc(long widget) {
        return 0L;
    }

    boolean translateTraversal(int event) {
        return false;
    }

    long windowProc(long handle, long user_data) {
        switch ((int)user_data) {
            case 1: {
                return this.gtk_activate(handle);
            }
            case 6: {
                return this.gtk_changed(handle);
            }
            case 8: {
                return this.gtk_clicked(handle);
            }
            case 83: {
                return this.gtk_create_menu_proxy(handle);
            }
            case 61: {
                return this.gtk_day_selected(handle);
            }
            case 66: {
                return this.gtk_day_selected_double_click(handle);
            }
            case 24: {
                return this.gtk_hide(handle);
            }
            case 23: {
                return this.gtk_grab_focus(handle);
            }
            case 30: {
                return this.gtk_map(handle);
            }
            case 62: {
                return this.gtk_month_changed(handle);
            }
            case 36: {
                return this.gtk_output(handle);
            }
            case 38: {
                return this.gtk_popup_menu(handle);
            }
            case 39: {
                return this.gtk_preedit_changed(handle);
            }
            case 40: {
                return this.gtk_realize(handle);
            }
            case 69: {
                return this.gtk_start_interactive_search(handle);
            }
            case 44: {
                return this.gtk_select(handle);
            }
            case 68: {
                return this.gtk_selection_done(handle);
            }
            case 45: {
                return this.gtk_show(handle);
            }
            case 57: {
                return this.gtk_value_changed(handle);
            }
            case 54: {
                return this.gtk_unmap(handle);
            }
            case 56: {
                return this.gtk_unrealize(handle);
            }
        }
        return 0L;
    }

    long windowProc(long handle, long arg0, long user_data) {
        switch ((int)user_data) {
            case 19: {
                GdkEventExpose gdkEvent = new GdkEventExpose();
                OS.memmove(gdkEvent, arg0, (long)GdkEventExpose.sizeof);
                long paintWindow = this.paintWindow();
                long window = gdkEvent.window;
                if (window != paintWindow) {
                    return 0L;
                }
                return (this.state & 0x40) != 0 ? 1L : 0L;
            }
            case 3: 
            case 5: 
            case 34: {
                return 1L;
            }
            case 2: {
                return this.gtk_button_press_event(handle, arg0);
            }
            case 4: {
                return this.gtk_button_release_event(handle, arg0);
            }
            case 9: {
                return this.gtk_commit(handle, arg0);
            }
            case 10: {
                return this.gtk_configure_event(handle, arg0);
            }
            case 11: {
                return this.gtk_delete_event(handle, arg0);
            }
            case 14: {
                return this.gtk_enter_notify_event(handle, arg0);
            }
            case 15: {
                return this.gtk_event(handle, arg0);
            }
            case 16: {
                return this.gtk_event_after(handle, arg0);
            }
            case 18: {
                if (OS.GTK3) {
                    return this.gtk_draw(handle, arg0);
                }
                return this.gtk_expose_event(handle, arg0);
            }
            case 20: {
                return this.gtk_focus(handle, arg0);
            }
            case 21: {
                return this.gtk_focus_in_event(handle, arg0);
            }
            case 22: {
                return this.gtk_focus_out_event(handle, arg0);
            }
            case 27: {
                return this.gtk_key_press_event(handle, arg0);
            }
            case 28: {
                return this.gtk_key_release_event(handle, arg0);
            }
            case 25: {
                return this.gtk_input(handle, arg0);
            }
            case 29: {
                return this.gtk_leave_notify_event(handle, arg0);
            }
            case 31: {
                return this.gtk_map_event(handle, arg0);
            }
            case 32: {
                return this.gtk_mnemonic_activate(handle, arg0);
            }
            case 33: {
                return this.gtk_motion_notify_event(handle, arg0);
            }
            case 35: {
                return this.gtk_move_focus(handle, arg0);
            }
            case 37: {
                return this.gtk_populate_popup(handle, arg0);
            }
            case 43: {
                return this.gtk_scroll_event(handle, arg0);
            }
            case 46: {
                return this.gtk_show_help(handle, arg0);
            }
            case 47: {
                return this.gtk_size_allocate(handle, arg0);
            }
            case 48: {
                return this.gtk_style_set(handle, arg0);
            }
            case 53: {
                return this.gtk_toggled(handle, arg0);
            }
            case 55: {
                return this.gtk_unmap_event(handle, arg0);
            }
            case 58: {
                return this.gtk_visibility_notify_event(handle, arg0);
            }
            case 59: {
                return this.gtk_window_state_event(handle, arg0);
            }
            case 65: {
                return this.gtk_row_deleted(handle, arg0);
            }
        }
        return 0L;
    }

    long windowProc(long handle, long arg0, long arg1, long user_data) {
        switch ((int)user_data) {
            case 12: {
                return this.gtk_delete_range(handle, arg0, arg1);
            }
            case 13: {
                return this.gtk_delete_text(handle, arg0, arg1);
            }
            case 67: {
                return this.gtk_icon_release(handle, arg0, arg1);
            }
            case 41: {
                return this.gtk_row_activated(handle, arg0, arg1);
            }
            case 42: {
                return this.gtk_scroll_child(handle, arg0, arg1);
            }
            case 63: {
                return this.gtk_status_icon_popup_menu(handle, arg0, arg1);
            }
            case 49: {
                return this.gtk_switch_page(handle, arg0, arg1);
            }
            case 50: {
                return this.gtk_test_collapse_row(handle, arg0, arg1);
            }
            case 51: {
                return this.gtk_test_expand_row(handle, arg0, arg1);
            }
            case 64: {
                return this.gtk_row_inserted(handle, arg0, arg1);
            }
        }
        return 0L;
    }

    long windowProc(long handle, long arg0, long arg1, long arg2, long user_data) {
        switch ((int)user_data) {
            case 7: {
                return this.gtk_change_value(handle, arg0, arg1, arg2);
            }
            case 17: {
                return this.gtk_expand_collapse_cursor_row(handle, arg0, arg1, arg2);
            }
            case 26: {
                return this.gtk_insert_text(handle, arg0, arg1, arg2);
            }
            case 52: {
                return this.gtk_text_buffer_insert_text(handle, arg0, arg1, arg2);
            }
        }
        return 0L;
    }

    void gdk_cursor_unref(long cursor) {
        if (OS.GTK3) {
            OS.g_object_unref(cursor);
        } else {
            OS.gdk_cursor_unref(cursor);
        }
    }

    long gdk_window_get_device_position(long window, int[] x, int[] y, int[] mask) {
        if (OS.GTK3) {
            long display = 0L;
            if (window != 0L) {
                display = OS.gdk_window_get_display(window);
            } else {
                window = OS.gdk_get_default_root_window();
                display = OS.gdk_window_get_display(window);
            }
            long device_manager = OS.gdk_display_get_device_manager(display);
            long pointer = OS.gdk_device_manager_get_client_pointer(device_manager);
            return OS.gdk_window_get_device_position(window, pointer, x, y, mask);
        }
        return OS.gdk_window_get_pointer(window, x, y, mask);
    }

    void gtk_cell_renderer_get_preferred_size(long cell, long widget, int[] width, int[] height) {
        if (OS.GTK3) {
            GtkRequisition minimum_size = new GtkRequisition();
            OS.gtk_cell_renderer_get_preferred_size(cell, widget, minimum_size, null);
            if (width != null) {
                width[0] = minimum_size.width;
            }
            if (height != null) {
                height[0] = minimum_size.height;
            }
        } else {
            OS.gtk_cell_renderer_get_size(cell, widget, null, null, null, width, height);
        }
    }

    void gtk_widget_get_preferred_size(long widget, GtkRequisition requisition) {
        if (OS.GTK3) {
            OS.gtk_widget_get_preferred_size(widget, requisition, null);
        } else {
            OS.gtk_widget_size_request(widget, requisition);
        }
    }
}

