/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;

public final class Region
extends Resource {
    public long handle;

    public Region() {
        this(null);
    }

    public Region(Device device) {
        super(device);
        this.handle = OS.gdk_region_new();
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.init();
    }

    Region(Device device, long handle) {
        super(device);
        this.handle = handle;
    }

    static long gdk_region_polygon(int[] pointArray, int npoints, int fill_rule) {
        long cairo;
        int minY;
        int minX;
        if (!OS.GTK3) {
            return OS.gdk_region_polygon(pointArray, npoints, fill_rule);
        }
        int maxX = minX = pointArray[0];
        int maxY = minY = pointArray[1];
        int count = npoints * 2;
        for (int i = 2; i < count; i += 2) {
            int x = pointArray[i];
            int y = pointArray[i + 1];
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (y <= maxY) continue;
            maxY = y;
        }
        long surface = Cairo.cairo_image_surface_create(3, maxX - minX, maxY - minY);
        if (surface == 0L) {
            SWT.error(2);
        }
        if ((cairo = Cairo.cairo_create(surface)) == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_move_to(cairo, pointArray[0] - minX, pointArray[1] - minY);
        for (int i = 2; i < count; i += 2) {
            Cairo.cairo_line_to(cairo, pointArray[i] - minX, pointArray[i + 1] - minY);
        }
        Cairo.cairo_close_path(cairo);
        Cairo.cairo_set_source_rgb(cairo, 1.0, 1.0, 1.0);
        int cairo_rule = 0;
        if (fill_rule == 0) {
            cairo_rule = 1;
        }
        Cairo.cairo_set_fill_rule(cairo, cairo_rule);
        Cairo.cairo_fill(cairo);
        Cairo.cairo_destroy(cairo);
        long polyRgn = OS.gdk_cairo_region_create_from_surface(surface);
        OS.gdk_region_offset(polyRgn, minX, minY);
        Cairo.cairo_surface_destroy(surface);
        return polyRgn;
    }

    static void gdk_region_get_rectangles(long region, long[] rectangles, int[] n_rectangles) {
        if (!OS.GTK3) {
            OS.gdk_region_get_rectangles(region, rectangles, n_rectangles);
            return;
        }
        int num = Cairo.cairo_region_num_rectangles(region);
        if (n_rectangles != null) {
            n_rectangles[0] = num;
        }
        rectangles[0] = OS.g_malloc(GdkRectangle.sizeof * num);
        for (int n = 0; n < num; ++n) {
            Cairo.cairo_region_get_rectangle(region, n, rectangles[0] + (long)(n * GdkRectangle.sizeof));
        }
    }

    public void add(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if (pointArray.length < 6) {
            return;
        }
        long polyRgn = Region.gdk_region_polygon(pointArray, pointArray.length / 2, 0);
        OS.gdk_region_union(this.handle, polyRgn);
        OS.gdk_region_destroy(polyRgn);
    }

    public void add(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.add(rect.x, rect.y, rect.width, rect.height);
    }

    public void add(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        GdkRectangle gdkRect = new GdkRectangle();
        gdkRect.x = x;
        gdkRect.y = y;
        gdkRect.width = width;
        gdkRect.height = height;
        OS.gdk_region_union_with_rect(this.handle, gdkRect);
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_region_union(this.handle, region.handle);
    }

    public boolean contains(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.gdk_region_point_in(this.handle, x, y);
    }

    public boolean contains(Point pt) {
        if (pt == null) {
            SWT.error(4);
        }
        return this.contains(pt.x, pt.y);
    }

    void destroy() {
        OS.gdk_region_destroy(this.handle);
        this.handle = 0L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.handle == region.handle;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        GdkRectangle gdkRect = new GdkRectangle();
        OS.gdk_region_get_clipbox(this.handle, gdkRect);
        return new Rectangle(gdkRect.x, gdkRect.y, gdkRect.width, gdkRect.height);
    }

    public static Region gtk_new(Device device, long handle) {
        return new Region(device, handle);
    }

    public int hashCode() {
        return (int)this.handle;
    }

    public void intersect(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.intersect(rect.x, rect.y, rect.width, rect.height);
    }

    public void intersect(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        GdkRectangle gdkRect = new GdkRectangle();
        gdkRect.x = x;
        gdkRect.y = y;
        gdkRect.width = width;
        gdkRect.height = height;
        long rectRgn = OS.gdk_region_rectangle(gdkRect);
        OS.gdk_region_intersect(this.handle, rectRgn);
        OS.gdk_region_destroy(rectRgn);
    }

    public void intersect(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_region_intersect(this.handle, region.handle);
    }

    public boolean intersects(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        GdkRectangle gdkRect = new GdkRectangle();
        gdkRect.x = x;
        gdkRect.y = y;
        gdkRect.width = width;
        gdkRect.height = height;
        return OS.gdk_region_rect_in(this.handle, gdkRect) != 1L;
    }

    public boolean intersects(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        return this.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public boolean isEmpty() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.gdk_region_empty(this.handle);
    }

    public void subtract(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if (pointArray.length < 6) {
            return;
        }
        long polyRgn = Region.gdk_region_polygon(pointArray, pointArray.length / 2, 0);
        OS.gdk_region_subtract(this.handle, polyRgn);
        OS.gdk_region_destroy(polyRgn);
    }

    public void subtract(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.subtract(rect.x, rect.y, rect.width, rect.height);
    }

    public void subtract(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        GdkRectangle gdkRect = new GdkRectangle();
        gdkRect.x = x;
        gdkRect.y = y;
        gdkRect.width = width;
        gdkRect.height = height;
        long rectRgn = OS.gdk_region_rectangle(gdkRect);
        OS.gdk_region_subtract(this.handle, rectRgn);
        OS.gdk_region_destroy(rectRgn);
    }

    public void subtract(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_region_subtract(this.handle, region.handle);
    }

    public void translate(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.gdk_region_offset(this.handle, x, y);
    }

    public void translate(Point pt) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pt == null) {
            SWT.error(4);
        }
        this.translate(pt.x, pt.y);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

