/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.GtkTargetEntry;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class ClipboardProxy {
    Object[] clipboardData;
    Transfer[] clipboardDataTypes;
    Object[] primaryClipboardData;
    Transfer[] primaryClipboardDataTypes;
    long clipboardOwner = OS.gtk_window_new(0);
    Display display;
    Clipboard activeClipboard = null;
    Clipboard activePrimaryClipboard = null;
    Callback getFunc;
    Callback clearFunc;
    static String ID = "CLIPBOARD PROXY OBJECT";

    static ClipboardProxy _getInstance(final Display display) {
        ClipboardProxy proxy = (ClipboardProxy)display.getData(ID);
        if (proxy != null) {
            return proxy;
        }
        proxy = new ClipboardProxy(display);
        display.setData(ID, proxy);
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                ClipboardProxy clipbordProxy = (ClipboardProxy)display.getData(ID);
                if (clipbordProxy == null) {
                    return;
                }
                display.setData(ID, null);
                clipbordProxy.dispose();
            }
        });
        return proxy;
    }

    ClipboardProxy(Display display) {
        this.display = display;
        this.getFunc = new Callback(this, "getFunc", 4);
        if (this.getFunc.getAddress() == 0L) {
            SWT.error(3);
        }
        this.clearFunc = new Callback(this, "clearFunc", 2);
        if (this.clearFunc.getAddress() == 0L) {
            SWT.error(3);
        }
    }

    void clear(Clipboard owner, int clipboards) {
        if ((clipboards & 1) != 0 && this.activeClipboard == owner) {
            OS.gtk_clipboard_clear(Clipboard.GTKCLIPBOARD);
        }
        if ((clipboards & 2) != 0 && this.activePrimaryClipboard == owner) {
            OS.gtk_clipboard_clear(Clipboard.GTKPRIMARYCLIPBOARD);
        }
    }

    long clearFunc(long clipboard, long user_data_or_owner) {
        if (clipboard == Clipboard.GTKCLIPBOARD) {
            this.activeClipboard = null;
            this.clipboardData = null;
            this.clipboardDataTypes = null;
        }
        if (clipboard == Clipboard.GTKPRIMARYCLIPBOARD) {
            this.activePrimaryClipboard = null;
            this.primaryClipboardData = null;
            this.primaryClipboardDataTypes = null;
        }
        return 1L;
    }

    void dispose() {
        if (this.display == null) {
            return;
        }
        if (this.activeClipboard != null) {
            OS.gtk_clipboard_store(Clipboard.GTKCLIPBOARD);
        }
        if (this.activePrimaryClipboard != null) {
            OS.gtk_clipboard_store(Clipboard.GTKPRIMARYCLIPBOARD);
        }
        this.display = null;
        if (this.getFunc != null) {
            this.getFunc.dispose();
        }
        this.getFunc = null;
        if (this.clearFunc != null) {
            this.clearFunc.dispose();
        }
        this.clearFunc = null;
        this.clipboardData = null;
        this.clipboardDataTypes = null;
        this.primaryClipboardData = null;
        this.primaryClipboardDataTypes = null;
        if (this.clipboardOwner != 0L) {
            OS.gtk_widget_destroy(this.clipboardOwner);
        }
        this.clipboardOwner = 0L;
    }

    long getFunc(long clipboard, long selection_data, long info, long user_data_or_owner) {
        long target;
        if (selection_data == 0L) {
            return 0L;
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            target = OS.gtk_selection_data_get_target(selection_data);
        } else {
            GtkSelectionData selectionData = new GtkSelectionData();
            OS.memmove(selectionData, selection_data, (long)GtkSelectionData.sizeof);
            target = selectionData.target;
        }
        TransferData tdata = new TransferData();
        tdata.type = target;
        Transfer[] types = clipboard == Clipboard.GTKCLIPBOARD ? this.clipboardDataTypes : this.primaryClipboardDataTypes;
        int index = -1;
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].isSupportedType(tdata)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return 0L;
        }
        Object[] data = clipboard == Clipboard.GTKCLIPBOARD ? this.clipboardData : this.primaryClipboardData;
        types[index].javaToNative(data[index], tdata);
        if (tdata.format < 8 || tdata.format % 8 != 0) {
            return 0L;
        }
        OS.gtk_selection_data_set(selection_data, tdata.type, tdata.format, tdata.pValue, tdata.length);
        OS.g_free(tdata.pValue);
        return 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean setData(Clipboard owner, Object[] data, Transfer[] dataTypes, int clipboards) {
        boolean bl;
        long pTargetsList;
        GtkTargetEntry[] entries;
        block19: {
            boolean bl2;
            block18: {
                boolean bl3;
                block17: {
                    entries = new GtkTargetEntry[]{};
                    pTargetsList = 0L;
                    try {
                        for (int i = 0; i < dataTypes.length; ++i) {
                            Transfer transfer = dataTypes[i];
                            int[] typeIds = transfer.getTypeIds();
                            String[] typeNames = transfer.getTypeNames();
                            for (int j = 0; j < typeIds.length; ++j) {
                                GtkTargetEntry entry = new GtkTargetEntry();
                                entry.info = typeIds[j];
                                byte[] buffer = Converter.wcsToMbcs(null, typeNames[j], true);
                                long pName = OS.g_malloc(buffer.length);
                                OS.memmove(pName, buffer, (long)buffer.length);
                                entry.target = pName;
                                GtkTargetEntry[] tmp = new GtkTargetEntry[entries.length + 1];
                                System.arraycopy(entries, 0, tmp, 0, entries.length);
                                tmp[entries.length] = entry;
                                entries = tmp;
                            }
                        }
                        pTargetsList = OS.g_malloc(GtkTargetEntry.sizeof * entries.length);
                        int offset = 0;
                        for (int i = 0; i < entries.length; offset += GtkTargetEntry.sizeof, ++i) {
                            OS.memmove(pTargetsList + (long)offset, entries[i], (long)GtkTargetEntry.sizeof);
                        }
                        if ((clipboards & 1) != 0) {
                            long clearFuncProc;
                            this.clipboardData = data;
                            this.clipboardDataTypes = dataTypes;
                            long getFuncProc = this.getFunc.getAddress();
                            if (!OS.gtk_clipboard_set_with_owner(Clipboard.GTKCLIPBOARD, pTargetsList, entries.length, getFuncProc, clearFuncProc = this.clearFunc.getAddress(), this.clipboardOwner)) {
                                bl3 = false;
                                Object var19_24 = null;
                                break block17;
                            }
                            OS.gtk_clipboard_set_can_store(Clipboard.GTKCLIPBOARD, 0L, 0);
                            this.activeClipboard = owner;
                        }
                        if ((clipboards & 2) != 0) {
                            long clearFuncProc;
                            this.primaryClipboardData = data;
                            this.primaryClipboardDataTypes = dataTypes;
                            long getFuncProc = this.getFunc.getAddress();
                            if (!OS.gtk_clipboard_set_with_owner(Clipboard.GTKPRIMARYCLIPBOARD, pTargetsList, entries.length, getFuncProc, clearFuncProc = this.clearFunc.getAddress(), this.clipboardOwner)) {
                                bl2 = false;
                                break block18;
                            }
                            OS.gtk_clipboard_set_can_store(Clipboard.GTKPRIMARYCLIPBOARD, 0L, 0);
                            this.activePrimaryClipboard = owner;
                        }
                        bl = true;
                        break block19;
                    }
                    catch (Throwable throwable) {
                        Object var19_27 = null;
                        int i = 0;
                        while (true) {
                            if (i >= entries.length) {
                                if (pTargetsList == 0L) throw throwable;
                                OS.g_free(pTargetsList);
                                throw throwable;
                            }
                            GtkTargetEntry entry = entries[i];
                            if (entry.target != 0L) {
                                OS.g_free(entry.target);
                            }
                            ++i;
                        }
                    }
                }
                for (int i = 0; i < entries.length; ++i) {
                    GtkTargetEntry entry = entries[i];
                    if (entry.target == 0L) continue;
                    OS.g_free(entry.target);
                }
                if (pTargetsList == 0L) return bl3;
                OS.g_free(pTargetsList);
                return bl3;
            }
            Object var19_25 = null;
            for (int i = 0; i < entries.length; ++i) {
                GtkTargetEntry entry = entries[i];
                if (entry.target == 0L) continue;
                OS.g_free(entry.target);
            }
            if (pTargetsList == 0L) return bl2;
            OS.g_free(pTargetsList);
            return bl2;
        }
        Object var19_26 = null;
        int i = 0;
        while (true) {
            if (i >= entries.length) {
                if (pTargetsList == 0L) return bl;
                OS.g_free(pTargetsList);
                return bl;
            }
            GtkTargetEntry entry = entries[i];
            if (entry.target != 0L) {
                OS.g_free(entry.target);
            }
            ++i;
        }
    }
}

