/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtil {
    public static IResource getResourceForLocation(IPath location) {
        URI uri;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = ResourceUtil.getFileForLocationURI(root, uri = URIUtil.toURI((IPath)location));
        if (file != null) {
            return file;
        }
        IContainer[] containers = root.findContainersForLocationURI(uri);
        return ResourceUtil.getExistingResourceWithShortestPath((IResource[])containers);
    }

    public static IFile getFileForLocation(IPath location) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        URI uri = URIUtil.toURI((IPath)location);
        return ResourceUtil.getFileForLocationURI(root, uri);
    }

    public static IFile getFileForLocation(Repository repository, String repoRelativePath) {
        IPath path = new Path(repository.getWorkTree().getAbsolutePath()).append(repoRelativePath);
        return ResourceUtil.getFileForLocation(path);
    }

    public static Map<Repository, Collection<String>> splitResourcesByRepository(IResource[] resources) {
        HashMap<Repository, Collection<String>> result = new HashMap<Repository, Collection<String>>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping(resource);
            if (repositoryMapping != null) {
                String path = repositoryMapping.getRepoRelativePath(resource);
                ResourceUtil.addPathToMap(repositoryMapping, path, result);
            }
            ++n2;
        }
        return result;
    }

    public static Map<Repository, Collection<String>> splitPathsByRepository(Collection<IPath> paths) {
        HashMap<Repository, Collection<String>> result = new HashMap<Repository, Collection<String>>();
        for (IPath path : paths) {
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping(path);
            if (repositoryMapping == null) continue;
            String p = repositoryMapping.getRepoRelativePath(path);
            ResourceUtil.addPathToMap(repositoryMapping, p, result);
        }
        return result;
    }

    public static boolean isNonWorkspace(IResource resource) {
        return resource.getLocation() == null;
    }

    private static IFile getFileForLocationURI(IWorkspaceRoot root, URI uri) {
        IFile[] files = root.findFilesForLocationURI(uri);
        return (IFile)ResourceUtil.getExistingResourceWithShortestPath((IResource[])files);
    }

    private static <T extends IResource> T getExistingResourceWithShortestPath(T[] resources) {
        int shortestPathSegmentCount = Integer.MAX_VALUE;
        T shortestPath = null;
        T[] TArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IPath fullPath;
            int segmentCount;
            T resource = TArray[n2];
            if (resource.exists() && (segmentCount = (fullPath = resource.getFullPath()).segmentCount()) < shortestPathSegmentCount) {
                shortestPath = resource;
                shortestPathSegmentCount = segmentCount;
            }
            ++n2;
        }
        return shortestPath;
    }

    private static void addPathToMap(RepositoryMapping repositoryMapping, String path, Map<Repository, Collection<String>> result) {
        if (path != null) {
            Repository repository = repositoryMapping.getRepository();
            Collection<String> resourcesList = result.get(repository);
            if (resourcesList == null) {
                resourcesList = new ArrayList<String>();
                result.put(repository, resourcesList);
            }
            resourcesList.add(path);
        }
    }

    public static ResourceMapping[] getResourceMappings(IFile file, ResourceMappingContext context) {
        IModelProviderDescriptor[] modelDescriptors = ModelProvider.getModelProviderDescriptors();
        LinkedHashSet<ResourceMapping> mappings = new LinkedHashSet<ResourceMapping>();
        IModelProviderDescriptor[] iModelProviderDescriptorArray = modelDescriptors;
        int n = modelDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IModelProviderDescriptor candidate = iModelProviderDescriptorArray[n2];
            try {
                IResource[] resources = candidate.getMatchingResources(new IResource[]{file});
                if (resources.length > 0) {
                    ResourceMapping[] modelMappings;
                    ModelProvider model = candidate.getModelProvider();
                    ResourceMapping[] resourceMappingArray = modelMappings = model.getMappings((IResource)file, context, null);
                    int n3 = modelMappings.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ResourceMapping mapping = resourceMappingArray[n4];
                        mappings.add(mapping);
                        ++n4;
                    }
                }
            }
            catch (CoreException e) {
                Activator.logError(e.getMessage(), e);
            }
            ++n2;
        }
        return mappings.toArray(new ResourceMapping[mappings.size()]);
    }
}

