/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers.ui.quickfix;

import org.eclipse.cdt.codan.internal.checkers.ui.CheckersUiActivator;
import org.eclipse.cdt.codan.internal.checkers.ui.Messages;
import org.eclipse.cdt.codan.ui.AbstractCodanCMarkerResolution;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class CatchByReferenceQuickFix
extends AbstractCodanCMarkerResolution {
    public String getLabel() {
        return Messages.CatchByReferenceQuickFix_Message;
    }

    public void apply(IMarker marker, IDocument document) {
        CatchByReferenceQuickFix.applyCatchByReferenceQuickFix(marker, document, false);
    }

    static void applyCatchByReferenceQuickFix(IMarker marker, IDocument document, boolean addConst) {
        try {
            int left = marker.getAttribute("charStart", -1);
            int right = marker.getAttribute("charEnd", -1);
            String inStr = document.get(left, right - left);
            document.replace(left, right - left, CatchByReferenceQuickFix.getCatchByReferenceString(inStr, addConst));
        }
        catch (BadLocationException e) {
            CheckersUiActivator.log(e);
        }
    }

    private static String getCatchByReferenceString(String inStr, boolean addConst) {
        int space;
        StringBuilder stringBuilder = new StringBuilder(inStr.length() + 10);
        if (addConst) {
            stringBuilder.append("const ");
        }
        boolean hasDeclName = (space = inStr.lastIndexOf(32)) != -1;
        String typename = hasDeclName ? inStr.substring(0, space) : inStr;
        stringBuilder.append(typename);
        stringBuilder.append(" &");
        if (hasDeclName) {
            stringBuilder.append(" ");
            String declname = inStr.substring(space + 1);
            stringBuilder.append(declname);
        }
        return stringBuilder.toString();
    }
}

