/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Platform;
import com.sun.deploy.config.SecuritySettings;
import com.sun.deploy.panel.ControlPanel;
import com.sun.deploy.panel.SecurityLevel;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.UIFactory;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.EventListenerList;

class SecurityProperties {
    private static EventListenerList javaEnabledListeners = new EventListenerList();
    private static Boolean enableJavaInBrowserDesiredState = null;
    private static SecurityLevel currentSliderSecuritySetting = null;
    private static SecurityLevel proposedSliderSecuritySetting = null;
    private static final Properties properties = new Properties();
    static /* synthetic */ Class class$com$sun$deploy$panel$SecurityProperties$JavaEnableListener;

    SecurityProperties() {
    }

    static void addJavaEnableListener(JavaEnableListener javaEnableListener) {
        javaEnabledListeners.add(class$com$sun$deploy$panel$SecurityProperties$JavaEnableListener == null ? (class$com$sun$deploy$panel$SecurityProperties$JavaEnableListener = SecurityProperties.class$("com.sun.deploy.panel.SecurityProperties$JavaEnableListener")) : class$com$sun$deploy$panel$SecurityProperties$JavaEnableListener, javaEnableListener);
    }

    static void removeMyEventListener(JavaEnableListener javaEnableListener) {
        javaEnabledListeners.remove(class$com$sun$deploy$panel$SecurityProperties$JavaEnableListener == null ? (class$com$sun$deploy$panel$SecurityProperties$JavaEnableListener = SecurityProperties.class$("com.sun.deploy.panel.SecurityProperties$JavaEnableListener")) : class$com$sun$deploy$panel$SecurityProperties$JavaEnableListener, javaEnableListener);
    }

    private static void fireMyEvent(JavaEnableEvent javaEnableEvent) {
        Object[] objectArray = javaEnabledListeners.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != (class$com$sun$deploy$panel$SecurityProperties$JavaEnableListener == null ? SecurityProperties.class$("com.sun.deploy.panel.SecurityProperties$JavaEnableListener") : class$com$sun$deploy$panel$SecurityProperties$JavaEnableListener)) continue;
            ((JavaEnableListener)objectArray[i + 1]).javaEnableChanged(javaEnableEvent);
        }
    }

    static void enableJavaInBrowser(boolean bl) {
        enableJavaInBrowserDesiredState = bl;
        ControlPanel.propertyHasChanged();
    }

    public static void saveLevelProperites() {
        if (proposedSliderSecuritySetting != null) {
            currentSliderSecuritySetting = proposedSliderSecuritySetting;
            proposedSliderSecuritySetting = null;
            SecuritySettings.setSecurityLevel(currentSliderSecuritySetting.getConfigKey());
        }
        SecurityProperties.saveCustomProperties();
    }

    public static JavaEnableManager prepareToSaveJavaEnabled() {
        Platform.WebJavaSwitch webJavaSwitch = Platform.get().getWebJavaSwitch();
        Platform.WebJavaSwitch.WebJavaState webJavaState = webJavaSwitch.queryWebJavaState();
        JavaEnableManager javaEnableManager = new JavaEnableManager(webJavaState, enableJavaInBrowserDesiredState);
        enableJavaInBrowserDesiredState = null;
        return javaEnableManager;
    }

    static boolean isJavaInBrowserEnabled() {
        boolean bl = Platform.get().getWebJavaSwitch().isWebJavaEnabled();
        return bl;
    }

    static boolean isJavaInBrowserDisabledForUser() {
        return Platform.get().getWebJavaSwitch().queryWebJavaState() == Platform.WebJavaSwitch.WebJavaState.USER_DISABLED;
    }

    static SecurityLevel getProposedSecurityLevel() {
        if (proposedSliderSecuritySetting != null) {
            return proposedSliderSecuritySetting;
        }
        return SecurityProperties.getCurrentSecurityLevel();
    }

    static SecurityLevel getCurrentSecurityLevel() {
        if (currentSliderSecuritySetting == null) {
            String string = SecuritySettings.getSecurityLevel();
            currentSliderSecuritySetting = SecurityLevel.getLevel(string);
        }
        return currentSliderSecuritySetting;
    }

    static void setProposedSecurityLevel(int n) {
        proposedSliderSecuritySetting = SecurityLevel.getSliderSetting(n);
        if (proposedSliderSecuritySetting != currentSliderSecuritySetting) {
            ControlPanel.propertyHasChanged();
        }
    }

    private static void saveCustomProperties() {
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            SecuritySettings.setManagedPropertyValue((String)entry.getKey(), (String)entry.getValue());
        }
        properties.clear();
    }

    static void setCustomProperty(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        if (!string2.equals(properties.getProperty(string))) {
            ControlPanel.propertyHasChanged();
        }
        properties.setProperty(string, string2);
    }

    static String getCustomProperty(String string) {
        if (properties.getProperty(string) == null) {
            properties.setProperty(string, SecuritySettings.getManagedPropertyValue(string));
        }
        return properties.getProperty(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class JavaEnableManager {
        private final Platform.WebJavaSwitch.WebJavaState previousState;
        private final Boolean desiredState;
        final Platform.WebJavaSwitch webJavaSwitch = Platform.get().getWebJavaSwitch();

        JavaEnableManager(Platform.WebJavaSwitch.WebJavaState webJavaState, Boolean bl) {
            this.previousState = webJavaState;
            this.desiredState = bl;
        }

        public boolean isJavaEnableChanging() {
            return this.desiredState != null && this.desiredState != (this.previousState == Platform.WebJavaSwitch.WebJavaState.ENABLED);
        }

        public void saveIfEnabling() {
            if (this.isJavaBeingEnabled()) {
                this.doSave();
            }
        }

        public void saveIfDisabling() {
            if (this.isJavaBeingDisabled()) {
                this.doSave();
            }
        }

        private void showPluginChangedDialog() {
            UIFactory.showInformationDialog(null, this.getMessage("deployment.java.change.success.masthead"), this.getMessage("deployment.java.change.success.message"), this.getMessage("deployment.java.change.success.title"));
        }

        private void showDisabledForUserDialog() {
            UIFactory.showInformationDialog(null, this.getMessage("deployment.java.change.useronly.masthead"), this.getMessage("deployment.java.change.useronly.message"), this.getMessage("deployment.java.change.useronly.title"));
        }

        private String getMessage(String string) {
            return ResourceManager.getMessage(string);
        }

        private void showAppropriateDialog() {
            Platform.WebJavaSwitch.WebJavaState webJavaState = this.webJavaSwitch.queryWebJavaState();
            if (this.previousState == Platform.WebJavaSwitch.WebJavaState.ENABLED) {
                if (webJavaState == Platform.WebJavaSwitch.WebJavaState.DISABLED) {
                    this.showPluginChangedDialog();
                } else if (webJavaState == Platform.WebJavaSwitch.WebJavaState.USER_DISABLED) {
                    this.showDisabledForUserDialog();
                }
            } else if (this.previousState == Platform.WebJavaSwitch.WebJavaState.DISABLED && webJavaState == Platform.WebJavaSwitch.WebJavaState.ENABLED) {
                this.showPluginChangedDialog();
            }
        }

        private boolean isJavaBeingEnabled() {
            return this.isJavaEnableChanging() && this.desiredState != null && this.desiredState == true;
        }

        private boolean isJavaBeingDisabled() {
            return this.isJavaEnableChanging() && this.desiredState != null && this.desiredState == false;
        }

        private void doSave() {
            if (this.desiredState != null) {
                this.webJavaSwitch.setWebJavaEnabled(this.desiredState);
                this.showAppropriateDialog();
                SecurityProperties.fireMyEvent(new JavaEnableEvent(this.webJavaSwitch.isWebJavaEnabled()));
            }
        }
    }

    static interface JavaEnableListener
    extends EventListener {
        public void javaEnableChanged(JavaEnableEvent var1);
    }

    static class JavaEnableEvent {
        boolean enabled;

        public JavaEnableEvent(boolean bl) {
            this.enabled = bl;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

