/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui.templates;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.team.ui.FocusedTeamUiPlugin;
import org.eclipse.mylyn.internal.team.ui.templates.Messages;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.team.ui.AbstractCommitTemplateVariable;

public class CommitTemplateManager {
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_RECOGNIZED_KEYWORD = "recognizedKeyword";
    private static final String ELEM_TEMPLATE_HANDLER = "templateVariable";
    private static final String EXT_POINT_TEMPLATE_HANDLERS = "commitTemplates";

    public String generateComment(ITask task, String template) {
        return this.processKeywords(task, template);
    }

    public String getTaskIdFromCommentOrLabel(String comment) {
        try {
            Pattern pattern;
            Matcher matcher;
            String template = FocusedTeamUiPlugin.getDefault().getPreferenceStore().getString("org.eclipse.mylyn.team.commit.template");
            int templateNewline = template.indexOf(10);
            String templateFirstLineIndex = template;
            if (templateNewline != -1) {
                templateFirstLineIndex = template.substring(0, templateNewline - 1);
            }
            String regex = this.getTaskIdRegEx(templateFirstLineIndex);
            int commentNewlineIndex = comment.indexOf(10);
            String commentFirstLine = comment;
            if (commentNewlineIndex != -1) {
                commentFirstLine = comment.substring(0, commentNewlineIndex);
            }
            if ((matcher = (pattern = Pattern.compile(regex)).matcher(commentFirstLine)).find()) {
                return matcher.group(1);
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.team.ui", "Problem while parsing task id from comment", (Throwable)e));
        }
        return null;
    }

    public String getTaskIdRegEx(String template) {
        template = template.replaceFirst("\\$\\{task\\.id\\}", "\uffff");
        template = template.replaceFirst("\\$\\{task\\.key\\}", "\uffff");
        template = this.replaceKeywords(template, "\ufffe");
        template = this.quoteChars(template, " $()*+.< [\\]^{|}");
        template = template.replaceFirst("\uffff", "(\\\\d+)");
        template = template.replaceAll("\ufffe", ".*");
        return template;
    }

    private String replaceKeywords(String str, String placeholder) {
        String[] recognizedKeywords;
        String[] stringArray = recognizedKeywords = this.getRecognizedKeywords();
        int n = recognizedKeywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            str = str.replaceAll("\\$\\{" + keyword + "\\}", placeholder);
            ++n2;
        }
        return str;
    }

    private String quoteChars(String str, String charsToQuote) {
        StringBuilder builder = new StringBuilder(str.length() * 2);
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (charsToQuote.indexOf(c) != -1) {
                builder.append('\\');
            }
            builder.append(c);
            ++i;
        }
        return builder.toString();
    }

    public String[] getRecognizedKeywords() {
        final ArrayList result = new ArrayList();
        new ExtensionProcessor(){

            @Override
            protected Object processContribution(IConfigurationElement element, String keyword, String description, String className) throws Exception {
                result.add(keyword);
                return null;
            }
        }.run();
        return result.toArray(new String[result.size()]);
    }

    public String getHandlerDescription(final String keyword) {
        return (String)new ExtensionProcessor(){

            @Override
            protected Object processContribution(IConfigurationElement element, String foundKeyword, String description, String className) throws Exception {
                return keyword.equals(foundKeyword) ? description : null;
            }
        }.run();
    }

    public AbstractCommitTemplateVariable createHandler(final String keyword) {
        return (AbstractCommitTemplateVariable)new ExtensionProcessor(){

            @Override
            protected Object processContribution(IConfigurationElement element, String foundKeyword, String description, String className) throws Exception {
                if (keyword.equals(foundKeyword)) {
                    AbstractCommitTemplateVariable handler = (AbstractCommitTemplateVariable)element.createExecutableExtension(CommitTemplateManager.ATTR_CLASS);
                    if (handler != null) {
                        handler.setDescription(description);
                        handler.setRecognizedKeyword(foundKeyword);
                    }
                    return handler;
                }
                return null;
            }
        }.run();
    }

    private String processKeywords(ITask task, String template) {
        String[] segments = template.split("\\$\\{");
        Stack<String> evaluated = new Stack<String>();
        evaluated.add(segments[0]);
        int i = 1;
        while (i < segments.length) {
            String segment = segments[i];
            String value = null;
            int brace = segment.indexOf(125);
            if (brace > 0) {
                String keyword = segment.substring(0, brace);
                value = this.processKeyword(task, keyword);
            }
            String trailingCharacters = segment.substring(brace + 1);
            if (value != null) {
                evaluated.add(value);
                evaluated.add(trailingCharacters);
            } else if (!evaluated.isEmpty()) {
                evaluated.add(trailingCharacters);
            }
            ++i;
        }
        StringBuffer buffer = new StringBuffer();
        for (String string : evaluated) {
            buffer.append(string);
        }
        String commitTemplate = buffer.toString();
        return commitTemplate.replaceAll("[ ]+", " ");
    }

    private String processKeyword(ITask task, String keyword) {
        try {
            AbstractCommitTemplateVariable handler = this.createHandler(keyword);
            if (handler != null) {
                return handler.getValue(task);
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.team.ui", "Problem while dispatching to template handler for: " + keyword, (Throwable)e));
        }
        return null;
    }

    private static class ExtensionProcessor {
        private ExtensionProcessor() {
        }

        public Object run() {
            IExtension[] extensions;
            IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.mylyn.team.ui", CommitTemplateManager.EXT_POINT_TEMPLATE_HANDLERS);
            IExtension[] iExtensionArray = extensions = extPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (CommitTemplateManager.ELEM_TEMPLATE_HANDLER.equals(element.getName())) {
                        try {
                            Object result = this.processContribution(element);
                            if (result != null) {
                                return result;
                            }
                        }
                        catch (Exception e) {
                            String msg = MessageFormat.format(Messages.CommitTemplateManager_Error_while_processing_template_handler_contribution_X_from_plugin_X, element.getAttribute(CommitTemplateManager.ATTR_CLASS), element.getContributor().getName());
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.team.ui", msg, (Throwable)e));
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            return null;
        }

        protected Object processContribution(IConfigurationElement element) throws Exception {
            String keyword = element.getAttribute(CommitTemplateManager.ATTR_RECOGNIZED_KEYWORD);
            String description = element.getAttribute(CommitTemplateManager.ATTR_DESCRIPTION);
            String className = element.getAttribute(CommitTemplateManager.ATTR_CLASS);
            return this.processContribution(element, keyword, description, className);
        }

        protected Object processContribution(IConfigurationElement element, String keyword, String description, String className) throws Exception {
            return null;
        }
    }
}

