/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.graphing.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.linuxtools.internal.systemtap.ui.graphing.Localization;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.charts.AbstractChartBuilder;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.structures.listeners.ITabListener;
import org.eclipse.linuxtools.systemtap.ui.graphing.GraphDisplaySet;
import org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorEditor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class SaveGraphImageAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;
    private IAction action;

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction act) {
        AbstractChartBuilder g = this.getGraph();
        try {
            PlatformUI.getWorkbench().getDisplay().update();
        }
        catch (SWTException swte) {
            ExceptionErrorDialog.openError((String)Localization.getString("SaveGraphImageAction.UnableToSaveGraph"), (Exception)((Object)swte));
        }
        if (g == null) {
            this.displayError(Localization.getString("SaveGraphImageAction.CanNotGetGraph"));
            return;
        }
        ImageData image = this.getImage(g);
        if (image == null) {
            this.displayError(Localization.getString("SaveGraphImageAction.CanNotCreateImage"));
            return;
        }
        String path = this.getFile();
        if (path == null) {
            return;
        }
        this.save(image, path);
    }

    public AbstractChartBuilder getGraph() {
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorEditor");
        AbstractChartBuilder g = null;
        GraphDisplaySet gds = ((GraphSelectorEditor)ivp).getActiveDisplaySet();
        if (gds != null) {
            g = gds.getActiveGraph();
        }
        return g;
    }

    public ImageData getImage(AbstractChartBuilder canvas) {
        GC gc = new GC((Drawable)canvas);
        Image image = new Image((Device)canvas.getDisplay(), canvas.getSize().x, canvas.getSize().y);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        ImageData data = image.getImageData();
        image.dispose();
        return data;
    }

    public String getFile() {
        FileDialog dialog = new FileDialog(this.fWindow.getShell(), 8192);
        dialog.setText(Localization.getString("SaveGraphImageAction.NewFile"));
        return dialog.open();
    }

    public void save(ImageData image, String path) {
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image};
        loader.save(path, 4);
    }

    private void displayError(String message) {
        MessageDialog.openWarning((Shell)this.fWindow.getShell(), (String)Localization.getString("SaveGraphImageAction.Problem"), (String)message);
    }

    public void selectionChanged(IAction a, ISelection s) {
        this.action = a;
        this.action.setEnabled(false);
        this.buildEnablementChecks();
    }

    private void buildEnablementChecks() {
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorEditor");
        if (ivp != null) {
            final GraphSelectorEditor gsv = (GraphSelectorEditor)ivp;
            gsv.addTabListener(new ITabListener(){

                public void tabClosed() {
                    if (gsv.getActiveDisplaySet() == null || gsv.getActiveDisplaySet().getActiveGraph() == null) {
                        SaveGraphImageAction.this.action.setEnabled(false);
                    }
                }

                public void tabOpened() {
                    gsv.getActiveDisplaySet().addTabListener(new ITabListener(){

                        public void tabClosed() {
                            if (gsv.getActiveDisplaySet().getActiveGraph() == null) {
                                SaveGraphImageAction.this.action.setEnabled(false);
                            }
                        }

                        public void tabOpened() {
                            if (gsv.getActiveDisplaySet().getActiveGraph() != null) {
                                SaveGraphImageAction.this.action.setEnabled(true);
                            }
                        }

                        public void tabChanged() {
                            if (gsv.getActiveDisplaySet() == null || gsv.getActiveDisplaySet().getActiveGraph() == null) {
                                SaveGraphImageAction.this.action.setEnabled(false);
                            } else {
                                SaveGraphImageAction.this.action.setEnabled(true);
                            }
                        }
                    });
                }

                public void tabChanged() {
                    if (gsv.getActiveDisplaySet() == null || gsv.getActiveDisplaySet().getActiveGraph() == null) {
                        SaveGraphImageAction.this.action.setEnabled(false);
                    } else {
                        SaveGraphImageAction.this.action.setEnabled(true);
                    }
                }
            });
        }
    }

    public void dispose() {
        this.fWindow = null;
        this.action = null;
    }
}

