/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.graphing.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.internal.systemtap.ui.graphing.Localization;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataEntry;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.graphingapi.core.datasets.IDataSetParser;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.wizards.dataset.DataSetWizard;
import org.eclipse.linuxtools.systemtap.ui.graphing.GraphingConstants;
import org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorEditor;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class OpenScriptOutputAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;
    private IDataSet dataSet;
    private IDataSetParser parser;

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction act) {
        File f = this.queryFile();
        if (f == null) {
            return;
        }
        if (!f.exists()) {
            this.displayError(Localization.getString("OpenScriptOutputAction.SelectedFileDNE"));
        } else if (!f.canRead()) {
            this.displayError(Localization.getString("OpenScriptOutputAction.SelectedFileCanNotRead"));
        } else {
            StringBuilder sb = this.readFile(f);
            if (this.getChartingOptions(f.getAbsolutePath())) {
                IDataEntry output;
                while ((output = this.parser.parse(sb)) != null) {
                    this.dataSet.setData(output);
                }
                IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorEditor");
                ((GraphSelectorEditor)ivp).createScriptSet(f.getName(), this.dataSet);
            }
        }
    }

    private File queryFile() {
        FileDialog dialog = new FileDialog(this.fWindow.getShell(), 4096);
        dialog.setText(Localization.getString("OpenScriptOutputAction.OpenFile"));
        String path = dialog.open();
        if (path != null && path.length() > 0) {
            return new File(path);
        }
        return null;
    }

    private void displayError(String message) {
        MessageDialog.openWarning((Shell)this.fWindow.getShell(), (String)Localization.getString("OpenScriptOutputAction.Problem"), (String)message);
    }

    private StringBuilder readFile(File f) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
        }
        catch (FileNotFoundException fnfe) {
            ExceptionErrorDialog.openError((String)Localization.getString("OpenScriptOutputAction.ErrorReadingFile"), (Exception)fnfe);
        }
        catch (IOException ioe) {
            ExceptionErrorDialog.openError((String)Localization.getString("OpenScriptOutputAction.ErrorReadingFile"), (Exception)ioe);
        }
        return sb;
    }

    protected boolean getChartingOptions(String filePath) {
        DataSetWizard wizard = new DataSetWizard(GraphingConstants.DataSetMetaData, filePath);
        IWorkbench workbench = PlatformUI.getWorkbench();
        wizard.init(workbench, null);
        WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
        this.parser = wizard.getParser();
        this.dataSet = wizard.getDataSet();
        wizard.dispose();
        return this.parser != null && this.dataSet != null;
    }

    public void selectionChanged(IAction a, ISelection s) {
    }

    public void dispose() {
        this.fWindow = null;
        this.parser = null;
    }
}

