/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.graphingapi.ui.graphs;

import java.util.LinkedList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.linuxtools.internal.systemtap.graphingapi.ui.GraphingAPIUIPlugin;
import org.eclipse.linuxtools.internal.systemtap.graphingapi.ui.Localization;
import org.eclipse.linuxtools.systemtap.graphingapi.core.IGraphColorConstants;
import org.eclipse.linuxtools.systemtap.graphingapi.core.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.graphingapi.core.structures.DataPoint;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.graphs.AChart;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.GraphAxis;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.GraphAxis2;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.GraphComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;

public abstract class AGraph
extends AChart {
    private final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            IPreferenceStore store = GraphingAPIUIPlugin.getDefault().getPreferenceStore();
            if (event.getProperty().equals("MaxDataItems")) {
                maxItems = store.getInt("MaxDataItems");
            } else if (event.getProperty().equals("ViewableDataItems")) {
                viewableItems = store.getInt("ViewableDataItems");
            } else if (event.getProperty().equals("XSeriesTicks")) {
                xSeriesTicks = store.getInt("XSeriesTicks");
                for (GraphAxis a : AGraph.this.axes) {
                    if (1 != a.getType()) continue;
                    a.setTickCount(xSeriesTicks);
                }
            } else if (event.getProperty().equals("YSeriesTicks")) {
                ySeriesTicks = store.getInt("YSeriesTicks");
                for (GraphAxis a : AGraph.this.axes) {
                    if (a.getType() != 0) continue;
                    a.setTickCount(ySeriesTicks);
                }
            } else if (event.getProperty().equals("ShowXGridLines")) {
                AGraph.this.showXGrid = store.getBoolean("ShowXGridLines");
                AGraph.this.showGrid = AGraph.this.showXGrid || AGraph.this.showYGrid;
            } else if (event.getProperty().equals("ShowXGridLines")) {
                AGraph.this.showYGrid = store.getBoolean("ShowXGridLines");
                AGraph.this.showGrid = AGraph.this.showXGrid || AGraph.this.showYGrid;
            }
            AGraph.this.repaint();
        }
    };
    private SelectionListener gridListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            AGraph.this.showGrid = ((Button)e.getSource()).getSelection();
            AGraph.this.repaint();
        }
    };
    private SelectionListener normalizeListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            AGraph.this.normalize = ((Button)e.getSource()).getSelection();
            if (!AGraph.this.normalize) {
                AGraph.this.removeSeriesAxis();
            }
            AGraph.this.handleUpdateEvent();
        }
    };
    protected LinkedList<GraphAxis> axes;
    private IAdapter adapter;
    private boolean showYGrid;
    private boolean showXGrid;
    protected static int xSeriesTicks;
    protected static int ySeriesTicks;
    protected static int maxItems;
    protected static int viewableItems;
    protected int removedItems;
    public boolean showGrid;
    public boolean normalize;
    protected int selectedSeries;
    protected GraphAxis seriesAxis;

    public AGraph(GraphComposite parent, int style, String title, IAdapter adapt) {
        super(parent, style, title, adapt);
        this.adapter = adapt;
        this.axes = new LinkedList();
        IPreferenceStore store = GraphingAPIUIPlugin.getDefault().getPreferenceStore();
        xSeriesTicks = store.getInt("XSeriesTicks");
        ySeriesTicks = store.getInt("YSeriesTicks");
        maxItems = store.getInt("MaxDataItems");
        viewableItems = store.getInt("ViewableDataItems");
        this.createAxis(Localization.getString("AGraph.xAxis"), xSeriesTicks, 1);
        this.createAxis(Localization.getString("AGraph.yAxis"), ySeriesTicks, 0);
        GraphingAPIUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        parent.addCheckOption(Localization.getString("AGraph.GridLines"), this.gridListener);
        if (this.adapter.getSeriesCount() > 1) {
            parent.addCheckOption(Localization.getString("AGraph.Normalize"), this.normalizeListener);
        }
    }

    protected void createAxis(String title, int tickCount, int style) {
        this.axes.add(new GraphAxis(this, title, tickCount, style));
    }

    protected void createAxis2(String title, int tickCount, int style) {
        this.axes.add(new GraphAxis2(this, title, tickCount, style, this.axisColor));
    }

    public Rectangle getArea(int items) {
        int uBound = this.elementList[0].size();
        int lBound = uBound > items ? uBound - items : 0;
        int maxX = Integer.MIN_VALUE;
        int minX = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int j = 0;
        while (j < this.elementList.length) {
            int i = lBound;
            while (i < uBound) {
                Object o = this.elementList[j].get(i);
                DataPoint p = (DataPoint)o;
                if (p.x < (double)minX) {
                    minX = (int)p.x;
                }
                if (p.x > (double)maxX) {
                    maxX = (int)p.x;
                }
                if (p.y < (double)minY) {
                    minY = (int)p.y;
                }
                if (p.y > (double)maxY) {
                    maxY = (int)p.y;
                }
                ++i;
            }
            ++j;
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    private synchronized void rebound() {
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AGraph.this.setGlobalArea(AGraph.this.getArea(maxItems));
                AGraph.this.setLocalArea(AGraph.this.getArea(viewableItems));
            }
        });
    }

    @Override
    public synchronized void repaint() {
        this.rebound();
        super.repaint();
    }

    public void addSeriesAxis(int series) {
        if (this.selectedSeries != series + 1) {
            this.removeSeriesAxis();
            this.seriesAxis = new GraphAxis2(this, Localization.getString("AGraph.SeriesAxis"), ySeriesTicks, 46, new Color((Device)this.getDisplay(), IGraphColorConstants.COLORS[series]));
            this.selectedSeries = series + 1;
            this.axes.add(this.seriesAxis);
            this.repaint();
        }
    }

    public void removeSeriesAxis() {
        if (this.seriesAxis != null) {
            this.axes.remove(this.seriesAxis);
            this.seriesAxis = null;
            this.selectedSeries = -1;
            this.repaint();
        }
    }

    @Override
    protected void paintAll(GC gc) {
        for (GraphAxis axis : this.axes) {
            axis.paint(gc);
        }
        super.paintAll(gc);
    }

    @Override
    public void dispose() {
        GraphingAPIUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        this.parent.removeCheckOption(Localization.getString("AGraph.Normalize"));
        this.parent.removeCheckOption(Localization.getString("AGraph.GridLines"));
        this.normalizeListener = null;
        this.gridListener = null;
        this.parent = null;
        super.dispose();
    }
}

