/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.opxml.info;

import org.eclipse.linuxtools.internal.oprofile.core.daemon.OpInfo;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.OprofileSAXHandler;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.XMLProcessor;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.info.DefaultsProcessor;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.info.EventListProcessor;
import org.xml.sax.Attributes;

public class OpInfoProcessor
extends XMLProcessor {
    private DefaultsProcessor defaultsProc = new DefaultsProcessor();
    private EventListProcessor eventListProc = new EventListProcessor();
    public static final String NUM_COUNTERS_TAG = "num-counters";
    public static final String DEFAULTS_TAG = "defaults";
    public static final String EVENT_LIST_TAG = "event-list";
    public static final String CPU_FREQUENCY_TAG = "cpu-frequency";
    public static final String TIMER_MODE = "timer-mode";

    public void startElement(String name, Attributes attrs, Object callData) {
        if (name.equals(DEFAULTS_TAG)) {
            OprofileSAXHandler.getInstance(callData).push(this.defaultsProc);
        } else if (name.equals(EVENT_LIST_TAG)) {
            OprofileSAXHandler.getInstance(callData).push(this.eventListProc);
            this.eventListProc.startElement(name, attrs, callData);
        } else {
            super.startElement(name, attrs, callData);
        }
    }

    public void endElement(String name, Object callData) {
        if (name.equals(CPU_FREQUENCY_TAG)) {
            double speed = Double.parseDouble(this.characters);
            OpInfo info = (OpInfo)callData;
            info.setCPUSpeed(speed);
        } else if (name.equals(TIMER_MODE)) {
            boolean timerMode = Boolean.parseBoolean(this.characters);
            OpInfo info = (OpInfo)callData;
            info.setTimerMode(timerMode);
        } else if (name.equals(NUM_COUNTERS_TAG)) {
            int numCounters = 0;
            try {
                numCounters = Integer.parseInt(this.characters);
            }
            catch (NumberFormatException numberFormatException) {}
            OpInfo info = (OpInfo)callData;
            info.setNrCounters(numCounters);
        } else if (name.equals(EVENT_LIST_TAG)) {
            OpInfo info = (OpInfo)callData;
            info.setEvents(this.eventListProc.getCounterNum(), this.eventListProc.getEvents());
        }
    }
}

