/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.linux;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.internal.oprofile.core.IOpcontrolProvider;
import org.eclipse.linuxtools.internal.oprofile.core.OpcontrolException;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OprofileDaemonEvent;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OprofileDaemonOptions;
import org.eclipse.linuxtools.internal.oprofile.core.linux.OpControlErrorHandler;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.sessions.SessionManager;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.linuxtools.tools.launch.core.properties.LinuxtoolsPathProperty;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinuxOpcontrolProvider
implements IOpcontrolProvider {
    private static final String OPCONTROL_EXECUTABLE = "opcontrol";
    private static final int SUDO_TIMEOUT = 2000;
    private static final String OPCONTROL_REL_PATH = "natives/linux/scripts/opcontrol";
    private static boolean isInstalled;
    private static final String OPD_INIT_MODULE = "--init";
    private static final String OPD_SETUP = "--setup";
    private static final String OPD_HELP = "--help";
    private static final String OPD_SETUP_SEPARATE = "--separate=";
    private static final String OPD_SETUP_SEPARATE_SEPARATOR = ",";
    private static final String OPD_SETUP_SEPARATE_NONE = "none";
    private static final String OPD_SETUP_SEPARATE_LIBRARY = "library";
    private static final String OPD_SETUP_SEPARATE_KERNEL = "kernel";
    private static final String OPD_SETUP_SEPARATE_THREAD = "thread";
    private static final String OPD_SETUP_SEPARATE_CPU = "cpu";
    private static final String OPD_SETUP_EVENT = "--event=";
    private static final String OPD_SETUP_EVENT_SEPARATOR = ":";
    private static final String OPD_SETUP_EVENT_TRUE = "1";
    private static final String OPD_SETUP_EVENT_FALSE = "0";
    private static final String OPD_SETUP_EVENT_DEFAULT = "default";
    private static final String OPD_SETUP_IMAGE = "--image=";
    private static final String OPD_CALLGRAPH_DEPTH = "--callgraph=";
    private static final String OPD_KERNEL_NONE = "--no-vmlinux";
    private static final String OPD_KERNEL_FILE = "--vmlinux=";
    private static final String OPD_START_DAEMON = "--start-daemon";
    private static final String OPD_START_COLLECTION = "--start";
    private static final String OPD_DUMP = "--dump";
    private static final String OPD_STOP_COLLECTION = "--stop";
    private static final String OPD_SHUTDOWN = "--shutdown";
    private static final String OPD_RESET = "--reset";
    private static final String OPD_DEINIT_MODULE = "--deinit";
    private String verbosity = "";

    @Override
    public void deinitModule() throws OpcontrolException {
        this.runOpcontrol(OPD_DEINIT_MODULE);
    }

    @Override
    public void dumpSamples() throws OpcontrolException {
        this.runOpcontrol(OPD_DUMP);
    }

    @Override
    public void initModule() throws OpcontrolException {
        this.runOpcontrol(OPD_INIT_MODULE);
    }

    @Override
    public void reset() throws OpcontrolException {
        this.runOpcontrol(OPD_RESET);
    }

    @Override
    public void saveSession(String name) throws OpcontrolException {
        try {
            SessionManager sessMan = new SessionManager(SessionManager.SESSION_LOCATION);
            for (String event : sessMan.getSessionEvents("current")) {
                sessMan.addSession(name, event);
                String oldFile = String.valueOf(SessionManager.OPXML_PREFIX) + "model-data" + event + "current";
                String newFile = String.valueOf(SessionManager.OPXML_PREFIX) + "model-data" + event + name;
                Process p = Runtime.getRuntime().exec("cp " + oldFile + " " + newFile);
                p.waitFor();
            }
            sessMan.write();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteSession(String sessionName, String eventName) throws OpcontrolException {
        File file = new File(String.valueOf(SessionManager.OPXML_PREFIX) + "model-data" + eventName + sessionName);
        file.delete();
        SessionManager sessMan = new SessionManager(SessionManager.SESSION_LOCATION);
        sessMan.removeSession(sessionName, eventName);
        sessMan.write();
    }

    @Override
    public void setupDaemon(OprofileDaemonOptions options, OprofileDaemonEvent[] events) throws OpcontrolException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(OPD_SETUP);
        this.optionsToArguments(args, options);
        if (!Oprofile.getTimerMode()) {
            if (events == null || events.length == 0) {
                args.add("--event=default");
            } else {
                int i = 0;
                while (i < events.length) {
                    this.eventToArguments(args, events[i]);
                    ++i;
                }
            }
        }
        this.runOpcontrol(args);
    }

    @Override
    public void shutdownDaemon() throws OpcontrolException {
        this.runOpcontrol(OPD_SHUTDOWN);
    }

    @Override
    public void startCollection() throws OpcontrolException {
        this.runOpcontrol(OPD_START_COLLECTION);
    }

    @Override
    public void startDaemon() throws OpcontrolException {
        this.runOpcontrol(OPD_START_DAEMON);
    }

    @Override
    public void stopCollection() throws OpcontrolException {
        this.runOpcontrol(OPD_STOP_COLLECTION);
    }

    @Override
    public boolean status() throws OpcontrolException {
        return this.runOpcontrol(OPD_HELP);
    }

    private boolean runOpcontrol(String cmd) throws OpcontrolException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(cmd);
        return this.runOpcontrol(list);
    }

    private boolean runOpcontrol(ArrayList<String> args) throws OpcontrolException {
        IProject project = Oprofile.OprofileProject.getProject();
        args.add(0, this.findOpcontrolExecutable());
        String cmd = args.get(1);
        if (this.verbosity.length() > 0 && (cmd.equals(OPD_START_COLLECTION) || cmd.equals(OPD_START_DAEMON))) {
            args.add(this.verbosity);
        }
        String[] cmdArray = new String[args.size()];
        args.toArray(cmdArray);
        if (OprofileCorePlugin.isDebugMode()) {
            this.printOpcontrolCmd(cmdArray);
        }
        Process p = this.createOpcontrolProcess(cmdArray, project);
        return this.checkOpcontrolProcess(p);
    }

    protected Process createOpcontrolProcess(String[] cmdArray, IProject project) throws OpcontrolException {
        Process p;
        block4: {
            p = null;
            try {
                if (!LinuxtoolsPathProperty.getInstance().getLinuxtoolsPath(project).equals("")) {
                    p = RuntimeProcessFactory.getFactory().sudoExec(cmdArray, project);
                    break block4;
                }
                if (isInstalled) {
                    p = Runtime.getRuntime().exec(cmdArray);
                    break block4;
                }
                throw new OpcontrolException(OprofileCorePlugin.createErrorStatus("opcontrolProvider", null));
            }
            catch (IOException ioe) {
                throw new OpcontrolException(OprofileCorePlugin.createErrorStatus("opcontrolRun", ioe));
            }
        }
        return p;
    }

    protected boolean checkOpcontrolProcess(Process p) throws OpcontrolException {
        if (p != null) {
            BufferedReader errout = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            BufferedReader stdout = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String errOutput = "";
            String output = "";
            try {
                String s;
                while ((s = errout.readLine()) != null) {
                    errOutput = String.valueOf(errOutput) + s + "\n";
                }
                while ((s = stdout.readLine()) != null) {
                    output = String.valueOf(output) + s + "\n";
                }
                stdout.close();
                errout.close();
                int ret = p.waitFor();
                if (ret != 0) {
                    OpControlErrorHandler errHandler = OpControlErrorHandler.getInstance();
                    OpcontrolException ex = errHandler.handleError(output, errOutput);
                    throw ex;
                }
                if (errOutput.length() != 0) {
                    return true;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private void printOpcontrolCmd(String[] cmdArray) {
        StringBuffer buf = new StringBuffer();
        String[] stringArray = cmdArray;
        int n = cmdArray.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            buf.append(token);
            buf.append(" ");
            ++n2;
        }
        System.out.println("DEBUG: " + buf.toString());
    }

    protected String findOpcontrolExecutable() {
        IProject project = Oprofile.OprofileProject.getProject();
        if (!LinuxtoolsPathProperty.getInstance().getLinuxtoolsPath(project).equals("")) {
            return OPCONTROL_EXECUTABLE;
        }
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)OprofileCorePlugin.getId()), (IPath)new Path(OPCONTROL_REL_PATH), null);
        if (url != null) {
            try {
                isInstalled = true;
                return FileLocator.toFileURL((URL)url).getPath();
            }
            catch (IOException iOException) {}
        } else {
            isInstalled = false;
            return OPCONTROL_EXECUTABLE;
        }
        return null;
    }

    private void eventToArguments(ArrayList<String> args, OprofileDaemonEvent event) {
        StringBuilder spec = new StringBuilder();
        spec.append(OPD_SETUP_EVENT);
        spec.append(event.getEvent().getText());
        spec.append(OPD_SETUP_EVENT_SEPARATOR);
        spec.append(event.getResetCount());
        spec.append(OPD_SETUP_EVENT_SEPARATOR);
        spec.append(event.getEvent().getUnitMask().getMaskValue());
        spec.append(OPD_SETUP_EVENT_SEPARATOR);
        spec.append(event.getProfileKernel() ? OPD_SETUP_EVENT_TRUE : OPD_SETUP_EVENT_FALSE);
        spec.append(OPD_SETUP_EVENT_SEPARATOR);
        spec.append(event.getProfileUser() ? OPD_SETUP_EVENT_TRUE : OPD_SETUP_EVENT_FALSE);
        args.add(spec.toString());
    }

    private void optionsToArguments(ArrayList<String> args, OprofileDaemonOptions options) {
        int mask = options.getSeparateProfilesMask();
        StringBuilder separate = new StringBuilder();
        separate.append(OPD_SETUP_SEPARATE);
        if (mask == 0) {
            separate.append(OPD_SETUP_SEPARATE_NONE);
        } else {
            if ((mask & 1) != 0) {
                separate.append("library,");
            }
            if ((mask & 2) != 0) {
                separate.append("kernel,");
            }
            if ((mask & 4) != 0) {
                separate.append("thread,");
            }
            if ((mask & 8) != 0) {
                separate.append("cpu,");
            }
        }
        args.add(separate.toString());
        if (options.getKernelImageFile() == null || options.getKernelImageFile().length() == 0) {
            args.add(OPD_KERNEL_NONE);
        } else {
            args.add(OPD_KERNEL_FILE + options.getKernelImageFile());
        }
        args.add(OPD_SETUP_IMAGE + options.getBinaryImage());
        args.add(OPD_CALLGRAPH_DEPTH + options.getCallgraphDepth());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasPermissions(IProject project) throws OpcontrolException {
        String linuxtoolsPath = LinuxtoolsPathProperty.getInstance().getLinuxtoolsPath(project);
        try {
            String[] sudoLines;
            String opcontrolPath = null;
            if (linuxtoolsPath.equals("")) {
                if (this.isInstalled()) return true;
                throw new OpcontrolException(OprofileCorePlugin.createErrorStatus("opcontrolProvider", null));
            }
            opcontrolPath = linuxtoolsPath.endsWith("/") ? String.valueOf(linuxtoolsPath) + OPCONTROL_EXECUTABLE : String.valueOf(linuxtoolsPath) + "/opcontrol";
            final Process p = RuntimeProcessFactory.getFactory().exec("sudo -l", project);
            final StringBuffer buffer = new StringBuffer();
            if (p == null) {
                return false;
            }
            Thread t = new Thread(){

                public void run() {
                    try {
                        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        String s = null;
                        while ((s = input.readLine()) != null) {
                            buffer.append(s);
                            buffer.append('\n');
                        }
                        p.waitFor();
                        p.destroy();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            t.start();
            t.join(2000L);
            String[] stringArray = sudoLines = buffer.toString().split("\n");
            int n = sudoLines.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    System.out.println(buffer.toString());
                    return false;
                }
                String s = stringArray[n2];
                if (s.contains(opcontrolPath) && s.contains("NOPASSWD")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean isInstalled() {
        this.findOpcontrolExecutable();
        return isInstalled;
    }
}

