/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IMacroDefinition;
import org.eclipse.cdt.make.core.makefile.IParent;
import org.eclipse.cdt.make.core.makefile.IRule;
import org.eclipse.cdt.make.core.makefile.gnu.IConditional;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.editor.IReconcilingParticipant;
import org.eclipse.cdt.make.internal.ui.editor.MakefileEditor;
import org.eclipse.cdt.make.ui.IWorkingCopyManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class ProjectionMakefileUpdater
implements IProjectionListener {
    private IDocument fCachedDocument;
    private MakefileEditor fEditor;
    private IDirective fInput;
    private ProjectionViewer fViewer;
    private IReconcilingParticipant fParticipant;
    private boolean fAllowCollapsing = false;
    private boolean fCollapseMacroDef = false;
    private boolean fCollapseRule = false;
    private boolean fCollapseConditional = false;

    public void install(MakefileEditor editor, ProjectionViewer viewer) {
        this.fEditor = editor;
        this.fViewer = viewer;
        this.fViewer.addProjectionListener((IProjectionListener)this);
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.projectionDisabled();
            this.fViewer.removeProjectionListener((IProjectionListener)this);
            this.fViewer = null;
            this.fEditor = null;
        }
    }

    protected boolean isInstalled() {
        return this.fEditor != null;
    }

    public void projectionEnabled() {
        this.projectionDisabled();
        this.initialize();
        this.fParticipant = new ReconcilerParticipant();
        this.fEditor.addReconcilingParticipant(this.fParticipant);
    }

    public void projectionDisabled() {
        this.fCachedDocument = null;
        if (this.fParticipant != null) {
            this.fEditor.addReconcilingParticipant(this.fParticipant);
            this.fParticipant = null;
        }
    }

    public void initialize() {
        if (!this.isInstalled()) {
            return;
        }
        this.initializePreferences();
        try {
            ProjectionAnnotationModel model;
            IDocumentProvider provider = this.fEditor.getDocumentProvider();
            this.fCachedDocument = provider.getDocument((Object)this.fEditor.getEditorInput());
            this.fAllowCollapsing = true;
            IWorkingCopyManager manager = MakeUIPlugin.getDefault().getWorkingCopyManager();
            this.fInput = manager.getWorkingCopy(this.fEditor.getEditorInput());
            if (this.fInput != null && (model = (ProjectionAnnotationModel)this.fEditor.getAdapter(ProjectionAnnotationModel.class)) != null) {
                Map<MakefileProjectionAnnotation, Position> additions = this.computeAdditions((IParent)this.fInput);
                model.removeAllAnnotations();
                model.replaceAnnotations(null, additions);
            }
        }
        finally {
            this.fCachedDocument = null;
            this.fAllowCollapsing = false;
        }
    }

    private void initializePreferences() {
        IPreferenceStore store = MakeUIPlugin.getDefault().getPreferenceStore();
        this.fCollapseMacroDef = store.getBoolean("editor_folding_default_macrodef");
        this.fCollapseRule = store.getBoolean("editor_folding_default_rule");
        this.fCollapseConditional = store.getBoolean("editor_folding_default_conditional");
    }

    private Map<MakefileProjectionAnnotation, Position> computeAdditions(IParent parent) {
        HashMap<MakefileProjectionAnnotation, Position> map = new HashMap<MakefileProjectionAnnotation, Position>();
        this.computeAdditions(parent.getDirectives(), map);
        return map;
    }

    private void computeAdditions(IDirective[] elements, Map<MakefileProjectionAnnotation, Position> map) {
        int i = 0;
        while (i < elements.length) {
            IDirective element = elements[i];
            this.computeAdditions(element, map);
            if (element instanceof IParent) {
                IParent parent = (IParent)element;
                this.computeAdditions(parent.getDirectives(), map);
            }
            ++i;
        }
    }

    private void computeAdditions(IDirective element, Map<MakefileProjectionAnnotation, Position> map) {
        Position position;
        boolean createProjection = false;
        boolean collapse = false;
        if (element instanceof IConditional) {
            collapse = this.fAllowCollapsing && this.fCollapseConditional;
            createProjection = true;
        } else if (element instanceof IMacroDefinition) {
            collapse = this.fAllowCollapsing && this.fCollapseMacroDef;
            createProjection = true;
        } else if (element instanceof IRule) {
            collapse = this.fAllowCollapsing && this.fCollapseRule;
            createProjection = true;
        }
        if (createProjection && (position = this.createProjectionPosition(element)) != null) {
            map.put(new MakefileProjectionAnnotation(element, collapse, true), position);
        }
    }

    private Position createProjectionPosition(IDirective element) {
        if (this.fCachedDocument == null) {
            return null;
        }
        try {
            int startLine = element.getStartLine() - 1;
            int endLine = element.getEndLine() - 1;
            if (startLine != endLine) {
                int offset = this.fCachedDocument.getLineOffset(startLine);
                int endOffset = this.fCachedDocument.getLineOffset(endLine + 1);
                return new Position(offset, endOffset - offset);
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    public void processReconcile() {
        if (!this.isInstalled()) {
            return;
        }
        ProjectionAnnotationModel model = (ProjectionAnnotationModel)this.fEditor.getAdapter(ProjectionAnnotationModel.class);
        if (model == null) {
            return;
        }
        try {
            IDocumentProvider provider = this.fEditor.getDocumentProvider();
            this.fCachedDocument = provider.getDocument((Object)this.fEditor.getEditorInput());
            this.fAllowCollapsing = false;
            HashMap<MakefileProjectionAnnotation, Position> additions = new HashMap<MakefileProjectionAnnotation, Position>();
            ArrayList<MakefileProjectionAnnotation> deletions = new ArrayList<MakefileProjectionAnnotation>();
            ArrayList<MakefileProjectionAnnotation> updates = new ArrayList<MakefileProjectionAnnotation>();
            Map<MakefileProjectionAnnotation, Position> updated = this.computeAdditions((IParent)this.fInput);
            Map<IDirective, List<MakefileProjectionAnnotation>> previous = this.createAnnotationMap((IAnnotationModel)model);
            for (MakefileProjectionAnnotation makefileProjectionAnnotation : updated.keySet()) {
                IDirective element = makefileProjectionAnnotation.getElement();
                Position position = updated.get((Object)makefileProjectionAnnotation);
                List<MakefileProjectionAnnotation> annotations = previous.get(element);
                if (annotations == null) {
                    additions.put(makefileProjectionAnnotation, position);
                    continue;
                }
                Iterator<MakefileProjectionAnnotation> x = annotations.iterator();
                while (x.hasNext()) {
                    MakefileProjectionAnnotation a = x.next();
                    if (makefileProjectionAnnotation.isComment() != a.isComment()) continue;
                    Position p = model.getPosition((Annotation)a);
                    if (p != null && !position.equals((Object)p)) {
                        p.setOffset(position.getOffset());
                        p.setLength(position.getLength());
                        updates.add(a);
                    }
                    x.remove();
                    break;
                }
                if (!annotations.isEmpty()) continue;
                previous.remove(element);
            }
            for (List list : previous.values()) {
                int size = list.size();
                int i = 0;
                while (i < size) {
                    deletions.add((MakefileProjectionAnnotation)((Object)list.get(i)));
                    ++i;
                }
            }
            this.match(model, deletions, additions, updates);
            Annotation[] annotationArray = new Annotation[deletions.size()];
            deletions.toArray(annotationArray);
            Annotation[] changes = new Annotation[updates.size()];
            updates.toArray(changes);
            model.modifyAnnotations(annotationArray, additions, changes);
        }
        finally {
            this.fCachedDocument = null;
            this.fAllowCollapsing = true;
        }
    }

    private void match(ProjectionAnnotationModel model, List<MakefileProjectionAnnotation> deletions, Map<MakefileProjectionAnnotation, Position> additions, List<MakefileProjectionAnnotation> changes) {
        if (deletions.isEmpty() || additions.isEmpty() && changes.isEmpty()) {
            return;
        }
        ArrayList<MakefileProjectionAnnotation> newDeletions = new ArrayList<MakefileProjectionAnnotation>();
        ArrayList<MakefileProjectionAnnotation> newChanges = new ArrayList<MakefileProjectionAnnotation>();
        Iterator<MakefileProjectionAnnotation> deletionIterator = deletions.iterator();
        block0: while (deletionIterator.hasNext()) {
            MakefileProjectionAnnotation deleted = deletionIterator.next();
            Position deletedPosition = model.getPosition((Annotation)deleted);
            if (deletedPosition == null) continue;
            Iterator<MakefileProjectionAnnotation> changesIterator = changes.iterator();
            while (changesIterator.hasNext()) {
                Position changedPosition;
                MakefileProjectionAnnotation changed = changesIterator.next();
                if (deleted.isComment() != changed.isComment() || (changedPosition = model.getPosition((Annotation)changed)) == null || deletedPosition.getOffset() != changedPosition.getOffset()) continue;
                deletedPosition.setLength(changedPosition.getLength());
                deleted.setElement(changed.getElement());
                deletionIterator.remove();
                newChanges.add(deleted);
                changesIterator.remove();
                newDeletions.add(changed);
                continue block0;
            }
            Iterator<MakefileProjectionAnnotation> additionsIterator = additions.keySet().iterator();
            while (additionsIterator.hasNext()) {
                MakefileProjectionAnnotation added = additionsIterator.next();
                if (deleted.isComment() != added.isComment()) continue;
                Position addedPosition = additions.get((Object)added);
                if (deletedPosition.getOffset() != addedPosition.getOffset()) continue;
                deletedPosition.setLength(addedPosition.getLength());
                deleted.setElement(added.getElement());
                deletionIterator.remove();
                newChanges.add(deleted);
                additionsIterator.remove();
                continue block0;
            }
        }
        deletions.addAll(newDeletions);
        changes.addAll(newChanges);
    }

    private Map<IDirective, List<MakefileProjectionAnnotation>> createAnnotationMap(IAnnotationModel model) {
        HashMap<IDirective, List<MakefileProjectionAnnotation>> map = new HashMap<IDirective, List<MakefileProjectionAnnotation>>();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Object annotation = e.next();
            if (!(annotation instanceof MakefileProjectionAnnotation)) continue;
            MakefileProjectionAnnotation directive = (MakefileProjectionAnnotation)((Object)annotation);
            ArrayList<MakefileProjectionAnnotation> list = (ArrayList<MakefileProjectionAnnotation>)map.get(directive.getElement());
            if (list == null) {
                list = new ArrayList<MakefileProjectionAnnotation>(2);
                map.put(directive.getElement(), list);
            }
            list.add(directive);
        }
        return map;
    }

    private static class MakefileProjectionAnnotation
    extends ProjectionAnnotation {
        private IDirective fDirective;
        private boolean fIsComment;

        public MakefileProjectionAnnotation(IDirective element, boolean isCollapsed, boolean isComment) {
            super(isCollapsed);
            this.fDirective = element;
            this.fIsComment = isComment;
        }

        public IDirective getElement() {
            return this.fDirective;
        }

        public void setElement(IDirective element) {
            this.fDirective = element;
        }

        public boolean isComment() {
            return this.fIsComment;
        }
    }

    private class ReconcilerParticipant
    implements IReconcilingParticipant {
        private ReconcilerParticipant() {
        }

        @Override
        public void reconciled() {
            ProjectionMakefileUpdater.this.processReconcile();
        }
    }
}

