/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.structures;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.StringOutputStream;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.Messages;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.structures.listeners.IUpdateListener;
import org.eclipse.linuxtools.systemtap.structures.process.SystemtapProcessFactory;
import org.eclipse.linuxtools.systemtap.structures.runnable.StringStreamGobbler;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class TapsetParser
extends Job {
    private ArrayList<IUpdateListener> listeners;
    private String[] tapsets;
    protected boolean cancelRequested;

    protected TapsetParser(String[] tapsets, String jobTitle) {
        super(jobTitle);
        this.tapsets = Arrays.copyOf(tapsets, tapsets.length);
        this.listeners = new ArrayList();
        this.cancelRequested = false;
    }

    protected void canceling() {
        super.canceling();
        this.cancelRequested = true;
    }

    public void addListener(IUpdateListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IUpdateListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    protected void fireUpdateEvent() {
        for (IUpdateListener listener : this.listeners) {
            listener.handleUpdateEvent();
        }
    }

    protected String runStap(String[] options, String probe) {
        int i;
        String[] args = null;
        int size = 2;
        if (this.tapsets != null && this.tapsets.length > 0 && this.tapsets[0].trim().length() > 0) {
            size += this.tapsets.length << 1;
        }
        if (options != null && options.length > 0 && options[0].trim().length() > 0) {
            size += options.length;
        }
        args = new String[size];
        args[0] = "stap";
        args[size - 1] = probe;
        args[size - 2] = "";
        if (this.tapsets != null && this.tapsets.length > 0 && this.tapsets[0].trim().length() > 0) {
            i = 0;
            while (i < this.tapsets.length) {
                args[2 + (i << 1)] = "-I";
                args[3 + (i << 1)] = this.tapsets[i];
                ++i;
            }
        }
        if (options != null && options.length > 0 && options[0].trim().length() > 0) {
            i = 0;
            while (i < options.length) {
                args[args.length - options.length - 1 + i] = options[i];
                ++i;
            }
        }
        String output = null;
        try {
            if (IDEPlugin.getDefault().getPreferenceStore().getBoolean("RemoteProbes")) {
                String password;
                String host;
                StringOutputStream str = new StringOutputStream();
                StringOutputStream strErr = new StringOutputStream();
                IPreferenceStore p = ConsoleLogPlugin.getDefault().getPreferenceStore();
                String user = p.getString("scpuser");
                Channel channel = SystemtapProcessFactory.execRemoteAndWait((String[])args, (OutputStream)str, (OutputStream)strErr, (String)user, (String)(host = p.getString("host")), (String)(password = p.getString("scppassword")));
                if (channel == null) {
                    this.displayError(Messages.TapsetParser_CannotRunStapTitle, Messages.TapsetParser_CannotRunStapMessage);
                }
                output = str.toString();
            } else {
                Process process = SystemtapProcessFactory.exec((String[])args, null);
                if (process == null) {
                    this.displayError(Messages.TapsetParser_CannotRunStapTitle, Messages.TapsetParser_CannotRunStapMessage);
                    return output;
                }
                StringStreamGobbler gobbler = new StringStreamGobbler(process.getInputStream());
                gobbler.start();
                process.waitFor();
                output = gobbler.getOutput().toString();
            }
        }
        catch (JSchException e) {
            ExceptionErrorDialog.openError((String)Messages.TapsetParser_ErrorRunningSystemtap, (Exception)((Object)e));
        }
        catch (IOException e) {
            ExceptionErrorDialog.openError((String)Messages.TapsetParser_ErrorRunningSystemtap, (Exception)e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return output;
    }

    private void displayError(final String title, final String error) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                MessageDialog.openWarning((Shell)window.getShell(), (String)title, (String)error);
            }
        });
    }
}

