/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.structures;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TapsetParser;
import org.eclipse.linuxtools.systemtap.graphingapi.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.structures.TreeDefinitionNode;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;

public class ProbeParser
extends TapsetParser {
    private TreeNode probes = new TreeNode((Object)"", false);
    static ProbeParser parser = null;

    public static ProbeParser getInstance() {
        if (parser != null) {
            return parser;
        }
        String[] tapsets = IDEPlugin.getDefault().getPreferenceStore().getString("TapsetPreference").split(File.pathSeparator);
        parser = new ProbeParser(tapsets);
        return parser;
    }

    private ProbeParser(String[] tapsets) {
        super(tapsets, "Probe Parser");
    }

    public synchronized TreeNode getProbes() {
        return this.probes;
    }

    protected IStatus run(IProgressMonitor monitor) {
        String s = this.collect(null);
        s = this.addStaticProbes(s);
        if (this.cancelRequested) {
            return new Status(0, "org.eclipse.linuxtools.systemtap.ui.ide", "");
        }
        this.parseProbes(s);
        this.probes.sortTree();
        this.fireUpdateEvent();
        return new Status(0, "org.eclipse.linuxtools.systemtap.ui.ide", "");
    }

    private String collect(String script) {
        String[] options;
        if (script == null) {
            script = "**";
            options = new String[]{"-L"};
        } else {
            options = null;
        }
        String s = this.runStap(options, script);
        if (s == null) {
            return "";
        }
        return s;
    }

    private void parseProbes(String s) {
        String token = null;
        StringBuilder prev = new StringBuilder("");
        TreeDefinitionNode currentProbe = null;
        TreeNode group = null;
        StringTokenizer st = new StringTokenizer(s, "\n", false);
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        while (st.hasMoreTokens() && !this.cancelRequested) {
            String tokenString = st.nextToken();
            if (tokenString.startsWith("_")) continue;
            int firstDotIndex = tokenString.indexOf(46);
            String groupName = tokenString;
            if (firstDotIndex > 0) {
                groupName = tokenString.substring(0, firstDotIndex);
            }
            if (group == null || !group.getData().equals(groupName)) {
                group = this.probes.getChildByName(groupName);
            }
            if (group == null) {
                group = new TreeNode((Object)groupName, groupName, true);
                this.probes.add(group);
            }
            StringTokenizer probe = new StringTokenizer(tokenString);
            prev.setLength(0);
            token = probe.nextToken();
            currentProbe = new TreeDefinitionNode((Object)("probe " + token), token, null, true);
            group.add((TreeNode)currentProbe);
            while (probe.hasMoreTokens()) {
                token = probe.nextToken();
                if (token.contains(":") && prev.length() > 0) {
                    prev.setLength(prev.length() - 1);
                    currentProbe.add(new TreeNode((Object)prev.toString(), prev.toString(), false));
                    prev.setLength(0);
                }
                prev.append(String.valueOf(token) + " ");
            }
            if (prev.length() <= 0) continue;
            prev.setLength(prev.length() - 1);
            currentProbe.add(new TreeNode((Object)prev.toString(), prev.toString(), false));
        }
    }

    private String addStaticProbes(String probeList) {
        BufferedReader input;
        StringBuilder probes;
        block6: {
            if (this.cancelRequested) {
                return "";
            }
            probes = new StringBuilder(probeList);
            input = null;
            if (IDEPlugin.getDefault() != null) break block6;
            return "";
        }
        try {
            URL location = IDEPlugin.getDefault().getBundle().getEntry("completion/static_probe_list.properties");
            location = FileLocator.toFileURL((URL)location);
            input = new BufferedReader(new FileReader(new File(location.getFile())));
            String line = input.readLine();
            while (line != null && !this.cancelRequested) {
                probes.append('\n');
                probes.append(line);
                line = input.readLine();
            }
            input.close();
        }
        catch (FileNotFoundException e) {
            ExceptionErrorDialog.openError((String)Messages.ProbeParser_errorInitializingStaticProbes, (Exception)e);
        }
        catch (IOException e) {
            ExceptionErrorDialog.openError((String)Messages.ProbeParser_errorInitializingStaticProbes, (Exception)e);
        }
        return probes.toString();
    }

    public void dispose() {
        this.probes.dispose();
    }
}

