/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.structures;

import java.io.File;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TapsetParser;
import org.eclipse.linuxtools.systemtap.structures.TreeDefinitionNode;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;

public class FunctionParser
extends TapsetParser {
    private TreeNode functions = new TreeNode((Object)"", false);
    static FunctionParser parser = null;

    public static FunctionParser getInstance() {
        if (parser != null) {
            return parser;
        }
        String[] tapsets = IDEPlugin.getDefault().getPreferenceStore().getString("TapsetPreference").split(File.pathSeparator);
        parser = new FunctionParser(tapsets);
        return parser;
    }

    private FunctionParser(String[] tapsets) {
        super(tapsets, "Function Parser");
    }

    public synchronized TreeNode getFunctions() {
        return this.functions;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.runPass2Functions();
        this.functions.sortTree();
        this.fireUpdateEvent();
        return new Status(0, "org.eclipse.linuxtools.systemtap.ui.ide", "");
    }

    private void runPass2Functions() {
        int i = 0;
        String script = "probe begin{}";
        String result = this.runStap(new String[]{"-v", "-p1", "-e"}, script);
        if (result == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(result, "\n", false);
        st.nextToken();
        String tok = "";
        String regex = "^function .*\\)\n$";
        Pattern p = Pattern.compile(regex, 13);
        Pattern secondp = Pattern.compile("[\\W]");
        Pattern underscorep = Pattern.compile("^function _.*");
        Pattern allCaps = Pattern.compile("[A-Z_1-9]*");
        while (st.hasMoreTokens()) {
            tok = st.nextToken().toString();
            Matcher m = p.matcher(tok);
            while (m.find()) {
                String[] us;
                String[] stringArray = us = underscorep.split(m.group().toString());
                int n = us.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    String[] test = secondp.split(s);
                    i = 0;
                    String[] stringArray2 = test;
                    int n3 = test.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String t = stringArray2[n4];
                        if (i == 1 && !allCaps.matcher(t).matches()) {
                            this.functions.add(new TreeNode((Object)t, t, true));
                        } else if (i > 1 && t.length() >= 1) {
                            TreeNode parent = this.functions.getChildAt(this.functions.getChildCount() - 1);
                            parent.add((TreeNode)new TreeDefinitionNode((Object)("function " + t), t, parent.getData().toString(), false));
                        }
                        ++i;
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        this.functions.sortTree();
    }

    public void dispose() {
        this.functions.dispose();
    }
}

