/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPColorConstants;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences.IDEPreferenceConstants;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.swt.graphics.RGB;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final String[] KERNEL_SOURCE_PATH = new String[]{"/usr/src/kernels/{kernel_version}", "/usr/src/linux", "/usr/src/linux-{kernel_version}"};

    public void initializeDefaultPreferences() {
        IPreferenceStore store = IDEPlugin.getDefault().getPreferenceStore();
        store.setDefault("UseStoredTreePreference", false);
        store.setDefault("RemoteProbes", false);
        store.setDefault("KernelSourcePreference", this.getKernelSourceLocation());
        store.setDefault("ExcludedKernelSource", "CVS/" + File.pathSeparator + ".svn/" + File.pathSeparator + "{arch}/" + File.pathSeparator + ".arch-ids/" + File.pathSeparator + ".bzr/" + File.pathSeparator + "debian/" + File.pathSeparator + ".git/");
        store.setDefault("RemoteLocalKernelSource", "local");
        store.setDefault("TapsetPreference", "");
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"EditorBackgroundPreference", (RGB)new RGB(255, 255, 255));
        store.setDefault("ShowLineNumbers", false);
        store.setDefault("UseCodeAssistPreference", true);
        store.setDefault("CompletionPreference", "CompletionInsertPreference");
        store.setDefault("ActivationDelayPreference", 200);
        store.setDefault("ActivationTriggerPreference", ".");
        store.setDefault("ConditionalFilters", "if(pid=currentpid)" + File.pathSeparator + "if(execname=cmdname)" + File.pathSeparator + "if(cpu=0)" + File.pathSeparator + "if(caller=functionname)");
        int i = 0;
        while (i < IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS.length) {
            store.setDefault(IDEPreferenceConstants.STAP_BOOLEAN_OPTIONS[i][2], false);
            ++i;
        }
        i = 0;
        while (i < IDEPreferenceConstants.STAP_STRING_OPTIONS.length) {
            store.setDefault(IDEPreferenceConstants.STAP_STRING_OPTIONS[i][2], "");
            ++i;
        }
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"stpDefaultColorPreference", (RGB)STPColorConstants.DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"stpKeywordColorPreference", (RGB)STPColorConstants.KEYWORD);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"stpEmbeddedCColorPreference", (RGB)STPColorConstants.EMBEDDEDC);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"stpEmbeddedColorPreference", (RGB)STPColorConstants.EMBEDDED);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"stpCommentColorPreference", (RGB)STPColorConstants.COMMENT);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"stpTypeColorPreference", (RGB)STPColorConstants.TYPE);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"stpStringColorPreference", (RGB)STPColorConstants.STP_STRING);
    }

    private String getKernelSourceLocation() {
        String version = "";
        try {
            Process process = RuntimeProcessFactory.getFactory().exec("uname -r", null, null);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            version = reader.readLine();
        }
        catch (IOException iOException) {}
        String[] stringArray = KERNEL_SOURCE_PATH;
        int n = KERNEL_SOURCE_PATH.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File file = new File(String.valueOf(path = path.replace("{kernel_version}", version)) + "/System.map");
            if (file.exists()) {
                return path;
            }
            ++n2;
        }
        return "";
    }
}

