/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp;

import java.util.ArrayList;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TapsetLibrary;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;

public class STPMetadataSingleton {
    public static String[] NO_MATCHES = new String[0];
    private static STPMetadataSingleton instance = null;

    protected STPMetadataSingleton() {
        TapsetLibrary.init();
    }

    public static STPMetadataSingleton getInstance() {
        if (instance == null) {
            instance = new STPMetadataSingleton();
        }
        return instance;
    }

    public void waitForInitialization() {
        TapsetLibrary.waitForInitialization();
    }

    public String[] getCompletionResults(String match) {
        boolean tapsetAndProbeIncluded = match.indexOf(46) >= 0;
        TreeNode node = TapsetLibrary.getProbes();
        if (node == null) {
            return NO_MATCHES;
        }
        if (tapsetAndProbeIncluded) {
            if ((node = node.getChildByName(this.getTapset(match))) == null) {
                return NO_MATCHES;
            }
            return this.getMatchingChildren(node, match);
        }
        return this.getMatchingChildren(node, match);
    }

    public String[] getFunctionCompletions(String prefix) {
        TreeNode node = TapsetLibrary.getFunctions();
        return this.getMatchingChildren(node, prefix);
    }

    public String[] getProbeVariableCompletions(String probe, String prefix) {
        TreeNode node = TapsetLibrary.getProbes();
        if (node == null) {
            return NO_MATCHES;
        }
        if ((node = node.getChildByName(this.getTapset(probe))) == null) {
            return NO_MATCHES;
        }
        if ((node = node.getChildByName(probe)) == null) {
            return NO_MATCHES;
        }
        return this.getMatchingChildren(node, prefix);
    }

    private String[] getMatchingChildren(TreeNode node, String prefix) {
        ArrayList<String> matches = new ArrayList<String>();
        int n = node.getChildCount();
        int i = 0;
        while (i < n) {
            if (node.getChildAt(i).toString().startsWith(prefix)) {
                matches.add(node.getChildAt(i).toString());
            }
            ++i;
        }
        return matches.toArray(new String[0]);
    }

    private String getTapset(String data) {
        int i = data.indexOf(46);
        if (i < 0) {
            return data;
        }
        return data.substring(0, data.indexOf(46));
    }
}

