/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPEditor;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.ProbeAliasBrowserView;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;
import org.eclipse.linuxtools.systemtap.ui.editor.actions.file.NewFileAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class ProbeAliasAction
extends Action
implements ISelectionListener,
IDoubleClickListener {
    private final IWorkbenchWindow window;
    private final ProbeAliasBrowserView viewer;
    private static final String ID = "org.eclipse.linuxtools.systemtap.ui.ide.ProbeAliasAction";
    private IStructuredSelection selection;

    public ProbeAliasAction(IWorkbenchWindow window, ProbeAliasBrowserView view) {
        this.window = window;
        this.setId(ID);
        this.setActionDefinitionId(ID);
        this.setText(Localization.getString("ProbeAliasAction.Insert"));
        this.setToolTipText(Localization.getString("ProbeAliasAction.InsertSelectedProbe"));
        window.getSelectionService().addSelectionListener((ISelectionListener)this);
        this.viewer = view;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection incoming) {
        if (incoming instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)incoming;
            this.setEnabled(this.selection.size() == 1);
        } else {
            this.setEnabled(false);
        }
    }

    public void dispose() {
        this.window.getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    public void run() {
        ISelection incoming;
        IStructuredSelection selection;
        Object o;
        IWorkbenchPage page = this.window.getActivePage();
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            NewFileAction action = new NewFileAction();
            action.run();
            editor = page.getWorkbenchWindow().getActivePage().getActiveEditor();
        }
        if ((o = (selection = (IStructuredSelection)(incoming = this.viewer.getViewer().getSelection())).getFirstElement()) instanceof TreeNode) {
            TreeNode t = (TreeNode)o;
            if (editor instanceof STPEditor) {
                STPEditor stpeditor = (STPEditor)editor;
                StringBuilder s = new StringBuilder("\nprobe " + t.toString());
                if (!t.isClickable()) {
                    if (t.getChildCount() > 0) {
                        s.append(".*");
                    } else {
                        return;
                    }
                }
                s.append("\n{\n");
                if (t.isClickable() && t.getChildCount() > 0) {
                    s.append("\t/*\n\t * " + Localization.getString("ProbeAliasAction.AvailableVariables") + "\n\t * ");
                    boolean first = true;
                    int i = 0;
                    while (i < t.getChildCount()) {
                        if (first) {
                            first = false;
                        } else {
                            s.append(", ");
                        }
                        s.append(t.getChildAt(i).toString());
                        ++i;
                    }
                    s.append("\n\t */\n");
                }
                s.append("\n}\n");
                stpeditor.insertText(s.toString());
            }
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        this.run();
    }
}

