/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDECloseMonitor;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TapsetLibrary;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ScriptConsole;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class IDEPlugin
extends AbstractUIPlugin {
    private IWorkbenchListener workbenchListener;
    private static IDEPlugin plugin;
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.systemtap.ui.ide";

    public IDEPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.workbenchListener = new IDECloseMonitor();
        plugin.getWorkbench().addWorkbenchListener(this.workbenchListener);
        TapsetLibrary.init();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        TapsetLibrary.stop();
        ScriptConsole.stopAll();
        plugin.getWorkbench().removeWorkbenchListener(this.workbenchListener);
        plugin = null;
    }

    public static IDEPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public URI createRemoteUri(String path) {
        IPreferenceStore p = ConsoleLogPlugin.getDefault().getPreferenceStore();
        String user = p.getString("scpuser");
        String host = p.getString("host");
        if (path == null) {
            path = "";
        }
        try {
            URI uri = new URI("ssh", user, host, -1, path, null, null);
            return uri;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

