/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.disassembly.dsf;

import java.math.BigInteger;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMixedInstruction;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.IDisassembly;
import org.eclipse.cdt.debug.core.model.IDisassemblyBlock;
import org.eclipse.cdt.debug.internal.core.model.DisassemblyBlock;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.IDisassemblyRetrieval;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.swt.widgets.Display;

public class CDIDisassemblyRetrieval
implements IDisassemblyRetrieval {
    private ICDebugTarget fDebugTarget;

    public CDIDisassemblyRetrieval(ICDebugTarget debugTarget) {
        this.fDebugTarget = debugTarget;
    }

    @Override
    public void asyncGetDisassembly(final BigInteger startAddress, final BigInteger endAddress, final String file, final int lineNumber, final int lines, final boolean mixed, final IDisassemblyRetrieval.DisassemblyRequest disassemblyRequest) {
        Runnable op = new Runnable(){

            @Override
            public void run() {
                ICDITarget cdiTarget = (ICDITarget)CDIDisassemblyRetrieval.this.fDebugTarget.getAdapter(ICDITarget.class);
                try {
                    try {
                        ICDIMixedInstruction[] mixedInstructions = null;
                        ICDIInstruction[] asmInstructions = null;
                        if (file != null) {
                            if (mixed) {
                                mixedInstructions = cdiTarget.getMixedInstructions(file, lineNumber, lines);
                            } else {
                                asmInstructions = cdiTarget.getInstructions(file, lineNumber, lines);
                            }
                        } else if (startAddress != null) {
                            if (mixed) {
                                mixedInstructions = cdiTarget.getMixedInstructions(startAddress, endAddress);
                            }
                            if (mixedInstructions == null || mixedInstructions.length == 0) {
                                mixedInstructions = null;
                                asmInstructions = cdiTarget.getInstructions(startAddress, endAddress);
                            } else if (mixedInstructions.length == 1 && mixedInstructions[0].getInstructions().length == 0) {
                                mixedInstructions = null;
                                asmInstructions = cdiTarget.getInstructions(startAddress, endAddress);
                            }
                        }
                        if (mixedInstructions != null) {
                            DisassemblyBlock block = DisassemblyBlock.create((IDisassembly)CDIDisassemblyRetrieval.this.fDebugTarget.getDisassembly(), mixedInstructions);
                            disassemblyRequest.setDisassemblyBlock((IDisassemblyBlock)block);
                        } else if (asmInstructions != null) {
                            DisassemblyBlock block = DisassemblyBlock.create((IDisassembly)CDIDisassemblyRetrieval.this.fDebugTarget.getDisassembly(), (ICDIInstruction[])asmInstructions);
                            disassemblyRequest.setDisassemblyBlock((IDisassemblyBlock)block);
                        }
                    }
                    catch (CDIException exc) {
                        disassemblyRequest.setStatus((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), exc.getDetailMessage(), (Throwable)exc));
                        disassemblyRequest.done();
                    }
                    catch (DebugException exc) {
                        disassemblyRequest.setStatus((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), exc.getMessage(), (Throwable)exc));
                        disassemblyRequest.done();
                    }
                }
                finally {
                    disassemblyRequest.done();
                }
            }
        };
        Display.getDefault().asyncExec(op);
    }

    @Override
    public void asyncGetFrameAddress(final IStackFrame stackFrame, final IDisassemblyRetrieval.AddressRequest addressRequest) {
        Runnable op = new Runnable(){

            @Override
            public void run() {
                if (stackFrame instanceof ICStackFrame) {
                    IAddress address = ((ICStackFrame)stackFrame).getAddress();
                    if (address != null) {
                        addressRequest.setAddress(address.getValue());
                    } else {
                        addressRequest.setStatus((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), "Internal error: Cannot retrieve frame address"));
                    }
                } else {
                    addressRequest.cancel();
                }
                addressRequest.done();
            }
        };
        Display.getDefault().asyncExec(op);
    }
}

