/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.search;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.mylyn.commons.ui.dialogs.IInPlaceDialogListener;
import org.eclipse.mylyn.commons.ui.dialogs.InPlaceDialogEvent;
import org.eclipse.mylyn.commons.workbench.InPlaceCheckBoxTreeDialog;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.commons.workbench.forms.SectionComposite;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCustomField;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaSearch;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.bugzilla.ui.BugzillaUiPlugin;
import org.eclipse.mylyn.internal.bugzilla.ui.search.Chart;
import org.eclipse.mylyn.internal.bugzilla.ui.search.ChartExpression;
import org.eclipse.mylyn.internal.bugzilla.ui.search.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage2;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BugzillaSearchPage
extends AbstractRepositoryQueryPage2
implements Listener {
    private static final int HEIGHT_ATTRIBUTE_COMBO = 30;
    private static ArrayList<BugzillaSearchData> previousSummaryPatterns = new ArrayList(20);
    private static ArrayList<BugzillaSearchData> previousEmailPatterns = new ArrayList(20);
    private static ArrayList<BugzillaSearchData> previousEmailPatterns2 = new ArrayList(20);
    private static ArrayList<BugzillaSearchData> previousCommentPatterns = new ArrayList(20);
    private static ArrayList<BugzillaSearchData> previousKeywords = new ArrayList(20);
    private static ArrayList<BugzillaSearchData> previousWhiteboardPatterns = new ArrayList(20);
    private boolean firstTime = true;
    private IDialogSettings fDialogSettings;
    private static final String[] patternOperationText = new String[]{Messages.BugzillaSearchPage_OperationText_allwordssubstr, Messages.BugzillaSearchPage_OperationText_anywordssubstr, Messages.BugzillaSearchPage_OperationText_substring, Messages.BugzillaSearchPage_OperationText_casesubstring, Messages.BugzillaSearchPage_OperationText_allwords, Messages.BugzillaSearchPage_OperationText_anywords, Messages.BugzillaSearchPage_OperationText_regexp, Messages.BugzillaSearchPage_OperationText_notregexp};
    private static final String[] patternOperationValues = new String[]{"allwordssubstr", "anywordssubstr", "substring", "casesubstring", "allwords", "anywords", "regexp", "notregexp"};
    private static final String[] emailOperationText = new String[]{Messages.BugzillaSearchPage_EmailOperation_substring, Messages.BugzillaSearchPage_EmailOperation_exact, Messages.BugzillaSearchPage_EmailOperation_notequals, Messages.BugzillaSearchPage_EmailOperation_regexp, Messages.BugzillaSearchPage_EmailOperation_notregexp};
    private static final String[] emailOperationValues = new String[]{"substring", "exact", "notequals", "regexp", "notregexp"};
    private static final String[] keywordOperationText = new String[]{Messages.BugzillaSearchPage_all, Messages.BugzillaSearchPage_any, Messages.BugzillaSearchPage_none};
    private static final String[] keywordOperationValues = new String[]{"allwords", "anywords", "nowords"};
    private static final String[] emailRoleValues = new String[]{"emailassigned_to1", "emailreporter1", "emailcc1", "emaillongdesc1", "emailqa_contact1"};
    private static final String[] emailRoleValues2 = new String[]{"emailassigned_to2", "emailreporter2", "emailcc2", "emaillongdesc2", "emailqa_contact2"};
    private static final ArrayList<String> chartFieldTextDefault = new ArrayList<String>(){
        private static final long serialVersionUID = 1974092160992399001L;
        {
            this.add(Messages.BugzillaSearchPage_Field_Noop);
            this.add(Messages.BugzillaSearchPage_Field_Alias);
            this.add(Messages.BugzillaSearchPage_Field_AssignedTo);
            this.add(Messages.BugzillaSearchPage_Field_Attachment_creator);
            this.add(Messages.BugzillaSearchPage_Field_Attachment_data);
            this.add(Messages.BugzillaSearchPage_Field_Attachment_description);
            this.add(Messages.BugzillaSearchPage_Field_Attachment_filename);
            this.add(Messages.BugzillaSearchPage_Field_Attachment_is_a_URL);
            this.add(Messages.BugzillaSearchPage_Field_Attachment_is_obsolete);
            this.add(Messages.BugzillaSearchPage_Field_Attachment_is_patch);
            this.add(Messages.BugzillaSearchPage_Field_Attachment_is_private);
            this.add(Messages.BugzillaSearchPage_Field_Attachment_mime_type);
            this.add(Messages.BugzillaSearchPage_Field_Blocks);
            this.add(Messages.BugzillaSearchPage_Field_Bug);
            this.add(Messages.BugzillaSearchPage_Field_CC);
            this.add(Messages.BugzillaSearchPage_Field_CC_Accessible);
            this.add(Messages.BugzillaSearchPage_Field_Classification);
            this.add(Messages.BugzillaSearchPage_Field_Comment);
            this.add(Messages.BugzillaSearchPage_Field_Comment_is_private);
            this.add(Messages.BugzillaSearchPage_Field_Commenter);
            this.add(Messages.BugzillaSearchPage_Field_Component);
            this.add(Messages.BugzillaSearchPage_Field_Content);
            this.add(Messages.BugzillaSearchPage_Field_Creation_date);
            this.add(Messages.BugzillaSearchPage_Field_Days_since_bug_changed);
            this.add(Messages.BugzillaSearchPage_Field_Depends_on);
            this.add(Messages.BugzillaSearchPage_Field_drop_down_custom_field);
            this.add(Messages.BugzillaSearchPage_Field_Ever_Confirmed);
            this.add(Messages.BugzillaSearchPage_Field_Flag);
            this.add(Messages.BugzillaSearchPage_Field_Flag_Requestee);
            this.add(Messages.BugzillaSearchPage_Field_Flag_Setter);
            this.add(Messages.BugzillaSearchPage_Field_free_text_custom_field);
            this.add(Messages.BugzillaSearchPage_Field_Group);
            this.add(Messages.BugzillaSearchPage_Field_Keywords);
            this.add(Messages.BugzillaSearchPage_Field_Last_changed_date);
            this.add(Messages.BugzillaSearchPage_Field_OS_Version);
            this.add(Messages.BugzillaSearchPage_Field_Platform);
            this.add(Messages.BugzillaSearchPage_Field_Priority);
            this.add(Messages.BugzillaSearchPage_Field_Product);
            this.add(Messages.BugzillaSearchPage_Field_QAContact);
            this.add(Messages.BugzillaSearchPage_Field_ReportedBy);
            this.add(Messages.BugzillaSearchPage_Field_Reporter_Accessible);
            this.add(Messages.BugzillaSearchPage_Field_Resolution);
            this.add(Messages.BugzillaSearchPage_Field_Severity);
            this.add(Messages.BugzillaSearchPage_Field_Status);
            this.add(Messages.BugzillaSearchPage_Field_Status_Whiteboard);
            this.add(Messages.BugzillaSearchPage_Field_Summary);
            this.add(Messages.BugzillaSearchPage_Field_Target_Milestone);
            this.add(Messages.BugzillaSearchPage_Field_Time_Since_Assignee_Touched);
            this.add(Messages.BugzillaSearchPage_Field_URL);
            this.add(Messages.BugzillaSearchPage_Field_Version);
            this.add(Messages.BugzillaSearchPage_Field_Votes);
        }
    };
    private static final ArrayList<String> chartFieldValuesDefault = new ArrayList<String>(){
        private static final long serialVersionUID = 9135403539678279982L;
        {
            this.add("noop");
            this.add("alias");
            this.add("assigned_to");
            this.add("attachments.submitter");
            this.add("attach_data.thedata");
            this.add("attachments.description");
            this.add("attachments.filename");
            this.add("attachments.isurl");
            this.add("attachments.isobsolete");
            this.add("attachments.ispatch");
            this.add("attachments.isprivate");
            this.add("attachments.mimetype");
            this.add("blocked");
            this.add("bug_id");
            this.add("cc");
            this.add("cclist_accessible");
            this.add("classification");
            this.add("longdesc");
            this.add("longdescs.isprivate");
            this.add("commenter");
            this.add("component");
            this.add("content");
            this.add("creation_ts");
            this.add("days_elapsed");
            this.add("dependson");
            this.add("cf_dropdown");
            this.add("everconfirmed");
            this.add("flagtypes.name");
            this.add("requestees.login_name");
            this.add("setters.login_name");
            this.add("cf_freetext");
            this.add("bug_group");
            this.add("keywords");
            this.add("delta_ts");
            this.add("op_sys");
            this.add("rep_platform");
            this.add("priority");
            this.add("product");
            this.add("qa_contact");
            this.add("reporter");
            this.add("reporter_accessible");
            this.add("resolution");
            this.add("bug_severity");
            this.add("bug_status");
            this.add("status_whiteboard");
            this.add("short_desc");
            this.add("target_milestone");
            this.add("owner_idle_time");
            this.add("bug_file_loc");
            this.add("version");
            this.add("votes");
        }
    };
    private static final String[] chartOperationText = new String[]{Messages.BugzillaSearchPage_Operation_Noop, Messages.BugzillaSearchPage_Operation_is_equal_to, Messages.BugzillaSearchPage_Operation_is_not_equal_to, Messages.BugzillaSearchPage_Operation_is_equal_to_any_of_the_strings, Messages.BugzillaSearchPage_Operation_contains_the_string, Messages.BugzillaSearchPage_Operation_contains_the_string_exact_case, Messages.BugzillaSearchPage_Operation_does_not_contain_the_string, Messages.BugzillaSearchPage_Operation_contains_any_of_the_strings, Messages.BugzillaSearchPage_Operation_contains_all_of_the_strings, Messages.BugzillaSearchPage_Operation_contains_none_of_the_strings, Messages.BugzillaSearchPage_Operation_contains_regexp, Messages.BugzillaSearchPage_Operation_does_not_contain_regexp, Messages.BugzillaSearchPage_Operation_is_less_than, Messages.BugzillaSearchPage_Operation_is_greater_than, Messages.BugzillaSearchPage_Operation_contains_any_of_he_words, Messages.BugzillaSearchPage_Operation_contains_all_of_the_words, Messages.BugzillaSearchPage_Operation_contains_none_of_the_words, Messages.BugzillaSearchPage_Operation_changed_before, Messages.BugzillaSearchPage_Operation_changed_after, Messages.BugzillaSearchPage_Operation_changed_from, Messages.BugzillaSearchPage_Operation_changed_to, Messages.BugzillaSearchPage_Operation_changed_by, Messages.BugzillaSearchPage_Operation_matches};
    private static final String[] chartOperationValues = new String[]{"noop", "equals", "notequals", "anyexact", "substring", "casesubstring", "notsubstring", "anywordssubstr", "allwordssubstr", "nowordssubstr", "regexp", "notregexp", "lessthan", "greaterthan", "anywords", "allwords", "nowords", "changedbefore", "changedafter", "changedfrom", "changedto", "changedby", "matches"};
    private static final String REGEXP_CHART_EXPR = "(field|type|value)([0-9]+)-([0-9]+)-([0-9]+)";
    private static final Pattern PATTERN_CHART_EXPR = Pattern.compile("(field|type|value)([0-9]+)-([0-9]+)-([0-9]+)", 2);
    private static final String REGEXP_CHART_NEGATE = "(negate)([0-9]+)";
    private static final Pattern PATTERN_CHART_NEGATE = Pattern.compile("(negate)([0-9]+)", 2);
    private IRepositoryQuery originalQuery = null;
    protected boolean restoring = false;
    private boolean restoreQueryOptions = true;
    protected Combo summaryPattern;
    protected Combo summaryOperation;
    protected org.eclipse.swt.widgets.List product;
    protected org.eclipse.swt.widgets.List os;
    protected org.eclipse.swt.widgets.List hardware;
    protected org.eclipse.swt.widgets.List priority;
    protected org.eclipse.swt.widgets.List severity;
    protected org.eclipse.swt.widgets.List resolution;
    protected org.eclipse.swt.widgets.List status;
    protected Combo commentOperation;
    protected Combo commentPattern;
    protected org.eclipse.swt.widgets.List component;
    protected org.eclipse.swt.widgets.List version;
    protected org.eclipse.swt.widgets.List target;
    protected Combo emailOperation;
    protected Combo emailOperation2;
    protected Combo emailPattern;
    protected Combo emailPattern2;
    protected Button[] emailButtons;
    protected Button[] emailButtons2;
    private Combo keywords;
    private Combo keywordsOperation;
    protected Combo whiteboardPattern;
    private Combo whiteboardOperation;
    protected Text daysText;
    protected String[] chartFieldText;
    protected String[] chartFieldValues;
    protected int selIndex;
    protected static final String PAGE_NAME = "BugzillaSearchPage";
    private final FormToolkit toolkit;
    private ExpandableComposite moreOptionsSection;
    private ExpandableComposite chartSection;
    private SectionComposite scrolledComposite;
    private final ArrayList<Chart> charts = new ArrayList(1);
    private final ArrayList<ControlDecoration> errorDecorations = new ArrayList();
    private final ArrayList<ArrayList<ArrayList<ChartControls>>> chartControls = new ArrayList();
    private final ArrayList<Button> negateButtons = new ArrayList();
    private final SelectionAdapter updateActionSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (BugzillaSearchPage.this.isControlCreated()) {
                BugzillaSearchPage.this.setPageComplete(BugzillaSearchPage.this.isPageComplete());
            }
        }
    };

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
        if (this.getSearchContainer() != null) {
            this.getSearchContainer().setPerformActionEnabled(complete);
        }
    }

    protected void createButtons(Composite control) {
        if (this.originalQuery != null) {
            return;
        }
        super.createButtons(control);
    }

    public void doClearControls() {
        this.product.deselectAll();
        this.component.deselectAll();
        this.version.deselectAll();
        this.target.deselectAll();
        this.status.deselectAll();
        this.resolution.deselectAll();
        this.severity.deselectAll();
        this.priority.deselectAll();
        this.hardware.deselectAll();
        this.os.deselectAll();
        this.summaryOperation.select(0);
        this.commentOperation.select(0);
        this.emailOperation.select(0);
        Button[] buttonArray = this.emailButtons;
        int n = this.emailButtons.length;
        int n2 = 0;
        while (n2 < n) {
            Button emailButton = buttonArray[n2];
            emailButton.setSelection(false);
            ++n2;
        }
        this.summaryPattern.setText("");
        this.commentPattern.setText("");
        this.emailPattern.setText("");
        this.emailOperation2.select(0);
        buttonArray = this.emailButtons2;
        n = this.emailButtons2.length;
        n2 = 0;
        while (n2 < n) {
            Button element = buttonArray[n2];
            element.setSelection(false);
            ++n2;
        }
        this.emailPattern2.setText("");
        this.keywords.setText("");
        this.keywordsOperation.select(0);
        this.whiteboardPattern.setText("");
        this.whiteboardOperation.select(0);
        this.daysText.setText("");
        this.charts.clear();
        this.charts.add(0, new Chart());
        this.recreateChartControls();
    }

    protected void createPageContent(SectionComposite parent) {
        this.scrolledComposite = parent;
        Composite scrolledBodyComposite = this.scrolledComposite.getContent();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        scrolledBodyComposite.setLayout((Layout)layout);
        this.basicCompositeCreate(scrolledBodyComposite);
        this.createMoreOptionsSection(scrolledBodyComposite);
        this.createChartSection(scrolledBodyComposite);
        Point p = scrolledBodyComposite.computeSize(-1, -1, true);
        this.scrolledComposite.setMinSize(p);
    }

    private void basicCompositeCreate(Composite parent) {
        Composite basicComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        basicComposite.setLayout((Layout)layout);
        GridData g = new GridData(4, 4, true, true);
        g.widthHint = 500;
        basicComposite.setLayoutData((Object)g);
        Dialog.applyDialogFont((Control)basicComposite);
        Label labelSummary = new Label(basicComposite, 16384);
        labelSummary.setText(Messages.BugzillaSearchPage_Summary);
        this.summaryPattern = new Combo(basicComposite, 2052);
        this.summaryPattern.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.summaryPattern.addModifyListener((ModifyListener)new ModifyListenerImplementation());
        this.summaryPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.handleWidgetSelected(BugzillaSearchPage.this.summaryPattern, BugzillaSearchPage.this.summaryOperation, previousSummaryPatterns);
            }
        });
        this.summaryOperation = new Combo(basicComposite, 2060);
        this.summaryOperation.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.summaryOperation.setItems(patternOperationText);
        this.summaryOperation.setText(patternOperationText[0]);
        this.summaryOperation.select(0);
        Label labelEmail = new Label(basicComposite, 16384);
        labelEmail.setText(Messages.BugzillaSearchPage_Email);
        this.emailPattern = new Combo(basicComposite, 2052);
        this.emailPattern.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.emailPattern.addModifyListener((ModifyListener)new ModifyListenerImplementation());
        this.emailPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.handleWidgetSelected(BugzillaSearchPage.this.emailPattern, BugzillaSearchPage.this.emailOperation, previousEmailPatterns);
            }
        });
        IContentProposalProvider proposalProvider = TasksUi.getUiFactory().createPersonContentProposalProvider(this.getTaskRepository());
        ILabelProvider proposalLabelProvider = TasksUi.getUiFactory().createPersonContentProposalLabelProvider(this.getTaskRepository());
        ContentAssistCommandAdapter adapter = new ContentAssistCommandAdapter((Control)this.emailPattern, (IControlContentAdapter)new ComboContentAdapter(), proposalProvider, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
        adapter.setLabelProvider(proposalLabelProvider);
        adapter.setProposalAcceptanceStyle(2);
        this.emailOperation = new Combo(basicComposite, 2060);
        this.emailOperation.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.emailOperation.setItems(emailOperationText);
        this.emailOperation.setText(emailOperationText[0]);
        this.emailOperation.select(0);
        new Label(basicComposite, 0);
        Composite emailComposite = new Composite(basicComposite, 0);
        emailComposite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        GridLayout emailLayout = new GridLayout();
        emailLayout.marginWidth = 0;
        emailLayout.marginHeight = 0;
        emailLayout.horizontalSpacing = 2;
        emailLayout.numColumns = 5;
        emailComposite.setLayout((Layout)emailLayout);
        Button button0 = new Button(emailComposite, 32);
        button0.setText(Messages.BugzillaSearchPage_owner);
        Button button1 = new Button(emailComposite, 32);
        button1.setText(Messages.BugzillaSearchPage_reporter);
        Button button2 = new Button(emailComposite, 32);
        button2.setText(Messages.BugzillaSearchPage_cc);
        Button button3 = new Button(emailComposite, 32);
        button3.setText(Messages.BugzillaSearchPage_commenter);
        Button button4 = new Button(emailComposite, 32);
        button4.setText(Messages.BugzillaSearchPage_qacontact);
        button0.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.setPageComplete(BugzillaSearchPage.this.isPageComplete());
            }
        });
        button1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.setPageComplete(BugzillaSearchPage.this.isPageComplete());
            }
        });
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.setPageComplete(BugzillaSearchPage.this.isPageComplete());
            }
        });
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.setPageComplete(BugzillaSearchPage.this.isPageComplete());
            }
        });
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.setPageComplete(BugzillaSearchPage.this.isPageComplete());
            }
        });
        this.emailButtons = new Button[]{button0, button1, button2, button3, button4};
        new Label(basicComposite, 0);
        GridLayout sashFormLayout = new GridLayout();
        sashFormLayout.numColumns = 4;
        sashFormLayout.marginHeight = 5;
        sashFormLayout.marginWidth = 5;
        sashFormLayout.horizontalSpacing = 5;
        SashForm sashForm = new SashForm(basicComposite, 512);
        sashForm.setLayout((Layout)sashFormLayout);
        GridData gd_sashForm = new GridData(4, 4, true, true, 4, 1);
        gd_sashForm.widthHint = 400;
        gd_sashForm.heightHint = 80;
        sashForm.setLayoutData((Object)gd_sashForm);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 4;
        SashForm topForm = new SashForm((Composite)sashForm, 0);
        GridData topLayoutData = new GridData(4, 4, true, true, 3, 1);
        topLayoutData.widthHint = 0;
        topLayoutData.heightHint = 60;
        topForm.setLayoutData((Object)topLayoutData);
        topForm.setLayout((Layout)topLayout);
        GridLayout productLayout = new GridLayout();
        productLayout.marginWidth = 0;
        productLayout.marginHeight = 0;
        productLayout.horizontalSpacing = 0;
        Composite productComposite = new Composite((Composite)topForm, 0);
        productComposite.setLayout((Layout)productLayout);
        Label productLabel = new Label(productComposite, 16384);
        productLabel.setText(Messages.BugzillaSearchPage_Product);
        productLabel.setLayoutData((Object)new GridData(768));
        GridData productLayoutData = new GridData(4, 4, true, true);
        productLayoutData.heightHint = 30;
        this.product = new org.eclipse.swt.widgets.List(productComposite, 2562);
        this.product.setLayoutData((Object)productLayoutData);
        this.product.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.updateAttributesBasedOnProductSelection(BugzillaSearchPage.this.product.getSelection(), BugzillaSearchPage.this.getRepositoryConfiguration());
                BugzillaSearchPage.this.setPageComplete(BugzillaSearchPage.this.isPageComplete());
            }
        });
        GridLayout componentLayout = new GridLayout();
        componentLayout.marginWidth = 0;
        componentLayout.marginHeight = 0;
        componentLayout.horizontalSpacing = 0;
        Composite componentComposite = new Composite((Composite)topForm, 0);
        componentComposite.setLayout((Layout)componentLayout);
        Label componentLabel = new Label(componentComposite, 16384);
        componentLabel.setText(Messages.BugzillaSearchPage_Component);
        componentLabel.setLayoutData((Object)new GridData(768));
        this.component = new org.eclipse.swt.widgets.List(componentComposite, 2562);
        GridData componentLayoutData = new GridData(4, 4, true, true);
        componentLayoutData.heightHint = 30;
        this.component.setLayoutData((Object)componentLayoutData);
        this.component.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        Composite statusComposite = new Composite((Composite)topForm, 0);
        GridLayout statusLayout = new GridLayout();
        statusLayout.marginWidth = 0;
        statusLayout.horizontalSpacing = 0;
        statusLayout.marginHeight = 0;
        statusComposite.setLayout((Layout)statusLayout);
        Label statusLabel = new Label(statusComposite, 16384);
        statusLabel.setText(Messages.BugzillaSearchPage_Status);
        statusLabel.setLayoutData((Object)new GridData(768));
        this.status = new org.eclipse.swt.widgets.List(statusComposite, 2562);
        GridData gd_status = new GridData(4, 4, true, true);
        gd_status.heightHint = 30;
        this.status.setLayoutData((Object)gd_status);
        this.status.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        Composite severityComposite = new Composite((Composite)topForm, 0);
        GridLayout severityLayout = new GridLayout();
        severityLayout.marginWidth = 0;
        severityLayout.marginHeight = 0;
        severityLayout.horizontalSpacing = 0;
        severityComposite.setLayout((Layout)severityLayout);
        Label severityLabel = new Label(severityComposite, 16384);
        severityLabel.setText(Messages.BugzillaSearchPage_Severity);
        severityLabel.setLayoutData((Object)new GridData(768));
        this.severity = new org.eclipse.swt.widgets.List(severityComposite, 2562);
        GridData gd_severity = new GridData(4, 4, true, true);
        gd_severity.heightHint = 30;
        this.severity.setLayoutData((Object)gd_severity);
        this.severity.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
    }

    private void createMoreOptionsSection(Composite parent) {
        this.moreOptionsSection = this.scrolledComposite.createSection(Messages.BugzillaSearchPage_More_Options, 290, true);
        GridData g = new GridData(4, 2, true, false);
        g.horizontalSpan = 4;
        this.moreOptionsSection.setLayoutData((Object)g);
        Composite moreOptionsComposite = new Composite((Composite)this.moreOptionsSection, 0);
        GridLayout optionsLayout = new GridLayout(4, false);
        optionsLayout.marginHeight = 0;
        optionsLayout.marginWidth = 0;
        moreOptionsComposite.setLayout((Layout)optionsLayout);
        this.moreOptionsSection.setClient((Control)moreOptionsComposite);
        this.createMoreOptionsContent(moreOptionsComposite);
        this.createMoreOptionsChangedInFilter(moreOptionsComposite);
    }

    private void createChartSection(Composite parent) {
        this.chartFieldText = chartFieldTextDefault.toArray(new String[chartFieldTextDefault.size()]);
        this.chartFieldValues = chartFieldValuesDefault.toArray(new String[chartFieldValuesDefault.size()]);
        this.chartSection = this.scrolledComposite.createSection(Messages.BugzillaSearchPage_BooleanChart, 290, false);
        GridData g = new GridData(4, 1, true, false);
        g.horizontalSpan = 4;
        this.chartSection.setLayoutData((Object)g);
        this.charts.add(0, new Chart());
        this.recreateChartControls();
    }

    private void createMoreOptionsContent(Composite advancedComposite) {
        Label labelComment = new Label(advancedComposite, 16384);
        labelComment.setText(Messages.BugzillaSearchPage_Comment);
        this.commentPattern = new Combo(advancedComposite, 2052);
        this.commentPattern.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.commentPattern.addModifyListener((ModifyListener)new ModifyListenerImplementation());
        this.commentPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.handleWidgetSelected(BugzillaSearchPage.this.commentPattern, BugzillaSearchPage.this.commentOperation, previousCommentPatterns);
            }
        });
        this.commentOperation = new Combo(advancedComposite, 2060);
        this.commentOperation.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.commentOperation.setItems(patternOperationText);
        this.commentOperation.setText(patternOperationText[0]);
        this.commentOperation.select(0);
        Label labelEmail2 = new Label(advancedComposite, 16384);
        labelEmail2.setText(Messages.BugzillaSearchPage_Email_2);
        this.emailPattern2 = new Combo(advancedComposite, 2052);
        this.emailPattern2.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.emailPattern2.addModifyListener((ModifyListener)new ModifyListenerImplementation());
        this.emailPattern2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.handleWidgetSelected(BugzillaSearchPage.this.emailPattern2, BugzillaSearchPage.this.emailOperation2, previousEmailPatterns2);
            }
        });
        IContentProposalProvider proposalProvider = TasksUi.getUiFactory().createPersonContentProposalProvider(this.getTaskRepository());
        ILabelProvider proposalLabelProvider = TasksUi.getUiFactory().createPersonContentProposalLabelProvider(this.getTaskRepository());
        ContentAssistCommandAdapter adapter2 = new ContentAssistCommandAdapter((Control)this.emailPattern2, (IControlContentAdapter)new ComboContentAdapter(), proposalProvider, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
        adapter2.setLabelProvider(proposalLabelProvider);
        adapter2.setProposalAcceptanceStyle(2);
        this.emailOperation2 = new Combo(advancedComposite, 2060);
        this.emailOperation2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.emailOperation2.setItems(emailOperationText);
        this.emailOperation2.setText(emailOperationText[0]);
        this.emailOperation2.select(0);
        new Label(advancedComposite, 0);
        Composite emailComposite2 = new Composite(advancedComposite, 0);
        emailComposite2.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        GridLayout emailLayout2 = new GridLayout();
        emailLayout2.marginWidth = 0;
        emailLayout2.marginHeight = 0;
        emailLayout2.horizontalSpacing = 2;
        emailLayout2.numColumns = 5;
        emailComposite2.setLayout((Layout)emailLayout2);
        Button e2button0 = new Button(emailComposite2, 32);
        e2button0.setText(Messages.BugzillaSearchPage_owner);
        Button e2button1 = new Button(emailComposite2, 32);
        e2button1.setText(Messages.BugzillaSearchPage_reporter);
        Button e2button2 = new Button(emailComposite2, 32);
        e2button2.setText(Messages.BugzillaSearchPage_cc);
        Button e2button3 = new Button(emailComposite2, 32);
        e2button3.setText(Messages.BugzillaSearchPage_commenter);
        Button e2button4 = new Button(emailComposite2, 32);
        e2button4.setText(Messages.BugzillaSearchPage_qacontact);
        e2button0.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.setPageComplete(BugzillaSearchPage.this.isPageComplete());
            }
        });
        e2button1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.setPageComplete(BugzillaSearchPage.this.isPageComplete());
            }
        });
        e2button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.setPageComplete(BugzillaSearchPage.this.isPageComplete());
            }
        });
        e2button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.setPageComplete(BugzillaSearchPage.this.isPageComplete());
            }
        });
        e2button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.setPageComplete(BugzillaSearchPage.this.isPageComplete());
            }
        });
        this.emailButtons2 = new Button[]{e2button0, e2button1, e2button2, e2button3, e2button4};
        new Label(advancedComposite, 0);
        Label whiteboardLabel = new Label(advancedComposite, 0);
        whiteboardLabel.setText(Messages.BugzillaSearchPage_Whiteboard);
        this.whiteboardPattern = new Combo(advancedComposite, 2052);
        this.whiteboardPattern.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.whiteboardPattern.addModifyListener((ModifyListener)new ModifyListenerImplementation());
        this.whiteboardPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.handleWidgetSelected(BugzillaSearchPage.this.whiteboardPattern, BugzillaSearchPage.this.whiteboardOperation, previousWhiteboardPatterns);
            }
        });
        this.whiteboardOperation = new Combo(advancedComposite, 8);
        this.whiteboardOperation.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.whiteboardOperation.setItems(patternOperationText);
        this.whiteboardOperation.setText(patternOperationText[0]);
        this.whiteboardOperation.select(0);
        Label keywordsLabel = new Label(advancedComposite, 0);
        keywordsLabel.setText(Messages.BugzillaSearchPage_Keywords);
        Composite keywordsComposite = new Composite(advancedComposite, 0);
        keywordsComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        GridLayout keywordsLayout = new GridLayout();
        keywordsLayout.marginWidth = 0;
        keywordsLayout.marginHeight = 0;
        keywordsLayout.numColumns = 3;
        keywordsComposite.setLayout((Layout)keywordsLayout);
        this.keywordsOperation = new Combo(keywordsComposite, 8);
        this.keywordsOperation.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.keywordsOperation.setItems(keywordOperationText);
        this.keywordsOperation.setText(keywordOperationText[0]);
        this.keywordsOperation.select(0);
        this.keywords = new Combo(keywordsComposite, 0);
        this.keywords.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.keywords.addModifyListener((ModifyListener)new ModifyListenerImplementation());
        this.keywords.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BugzillaSearchPage.this.handleWidgetSelected(BugzillaSearchPage.this.keywords, BugzillaSearchPage.this.keywordsOperation, previousKeywords);
            }
        });
        final Button keywordsSelectButton = new Button(keywordsComposite, 0);
        keywordsSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final ArrayList<String> values = new ArrayList<String>();
                String[] stringArray = BugzillaSearchPage.this.keywords.getText().split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    values.add(string.trim());
                    ++n2;
                }
                HashMap<String, String> validValues = new HashMap<String, String>();
                if (BugzillaSearchPage.this.getRepositoryConfiguration() != null) {
                    for (String string : BugzillaSearchPage.this.getRepositoryConfiguration().getOptionValues(BugzillaAttribute.KEYWORDS)) {
                        validValues.put(string, string);
                    }
                }
                final InPlaceCheckBoxTreeDialog selectionDialog = new InPlaceCheckBoxTreeDialog(WorkbenchUtil.getShell(), (Control)keywordsSelectButton, values, validValues, "");
                selectionDialog.addEventListener(new IInPlaceDialogListener(){

                    public void buttonPressed(InPlaceDialogEvent event) {
                        if (event.getReturnCode() == 0) {
                            Set newValues = selectionDialog.getSelectedValues();
                            if (!new HashSet(values).equals(newValues)) {
                                String erg = "";
                                for (String string : newValues) {
                                    erg = erg.equals("") ? string : String.valueOf(erg) + ", " + string;
                                }
                                BugzillaSearchPage.this.keywords.setText(erg);
                            }
                        } else if (event.getReturnCode() == 1025) {
                            BugzillaSearchPage.this.keywords.setText("");
                        }
                    }
                });
                selectionDialog.open();
            }
        });
        keywordsSelectButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        keywordsSelectButton.setText(Messages.BugzillaSearchPage_Select_);
        SashForm bottomForm = new SashForm(advancedComposite, 0);
        GridLayout bottomLayout = new GridLayout();
        bottomLayout.numColumns = 6;
        bottomForm.setLayout((Layout)bottomLayout);
        GridData bottomLayoutData = new GridData(4, 4, true, true, 4, 1);
        bottomLayoutData.heightHint = 80;
        bottomLayoutData.widthHint = 400;
        bottomForm.setLayoutData((Object)bottomLayoutData);
        Composite priorityComposite = new Composite((Composite)bottomForm, 0);
        GridLayout priorityLayout = new GridLayout();
        priorityLayout.marginWidth = 0;
        priorityLayout.marginHeight = 0;
        priorityLayout.horizontalSpacing = 0;
        priorityComposite.setLayout((Layout)priorityLayout);
        Label priorityLabel = new Label(priorityComposite, 16384);
        priorityLabel.setText(Messages.BugzillaSearchPage_PROORITY);
        priorityLabel.setLayoutData((Object)new GridData(768));
        this.priority = new org.eclipse.swt.widgets.List(priorityComposite, 2562);
        GridData gd_priority = new GridData(4, 4, true, true);
        gd_priority.heightHint = 30;
        this.priority.setLayoutData((Object)gd_priority);
        this.priority.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        Composite resolutionComposite = new Composite((Composite)bottomForm, 0);
        GridLayout resolutionLayout = new GridLayout();
        resolutionLayout.marginWidth = 0;
        resolutionLayout.marginHeight = 0;
        resolutionLayout.horizontalSpacing = 0;
        resolutionComposite.setLayout((Layout)resolutionLayout);
        Label resolutionLabel = new Label(resolutionComposite, 16384);
        resolutionLabel.setText(Messages.BugzillaSearchPage_Resolution);
        resolutionLabel.setLayoutData((Object)new GridData(768));
        this.resolution = new org.eclipse.swt.widgets.List(resolutionComposite, 2562);
        GridData gd_resolution = new GridData(4, 4, true, true);
        gd_resolution.heightHint = 30;
        this.resolution.setLayoutData((Object)gd_resolution);
        this.resolution.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        Composite versionComposite = new Composite((Composite)bottomForm, 0);
        GridLayout versionLayout = new GridLayout();
        versionLayout.marginWidth = 0;
        versionLayout.marginHeight = 0;
        versionLayout.horizontalSpacing = 0;
        versionComposite.setLayout((Layout)versionLayout);
        Label versionLabel = new Label(versionComposite, 16384);
        versionLabel.setText(Messages.BugzillaSearchPage_Version);
        versionLabel.setLayoutData((Object)new GridData(768));
        this.version = new org.eclipse.swt.widgets.List(versionComposite, 2562);
        GridData versionLayoutData = new GridData(4, 4, true, true);
        versionLayoutData.heightHint = 30;
        this.version.setLayoutData((Object)versionLayoutData);
        this.version.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        Composite milestoneComposite = new Composite((Composite)bottomForm, 0);
        GridLayout milestoneLayout = new GridLayout();
        milestoneLayout.marginWidth = 0;
        milestoneLayout.marginHeight = 0;
        milestoneLayout.horizontalSpacing = 0;
        milestoneComposite.setLayout((Layout)milestoneLayout);
        Label milestoneLabel = new Label(milestoneComposite, 16384);
        milestoneLabel.setText(Messages.BugzillaSearchPage_Milestone);
        milestoneLabel.setLayoutData((Object)new GridData(768));
        this.target = new org.eclipse.swt.widgets.List(milestoneComposite, 2562);
        GridData targetLayoutData = new GridData(4, 4, true, true);
        targetLayoutData.heightHint = 30;
        this.target.setLayoutData((Object)targetLayoutData);
        this.target.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        Composite hardwareComposite = new Composite((Composite)bottomForm, 0);
        GridLayout hardwareLayout = new GridLayout();
        hardwareLayout.marginWidth = 0;
        hardwareLayout.marginHeight = 0;
        hardwareLayout.horizontalSpacing = 0;
        hardwareComposite.setLayout((Layout)hardwareLayout);
        Label hardwareLabel = new Label(hardwareComposite, 16384);
        hardwareLabel.setText(Messages.BugzillaSearchPage_Hardware);
        hardwareLabel.setLayoutData((Object)new GridData(768));
        this.hardware = new org.eclipse.swt.widgets.List(hardwareComposite, 2562);
        GridData gd_hardware = new GridData(4, 4, true, true);
        gd_hardware.heightHint = 30;
        this.hardware.setLayoutData((Object)gd_hardware);
        this.hardware.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
        Composite osComposite = new Composite((Composite)bottomForm, 0);
        GridLayout osLayout = new GridLayout();
        osLayout.marginWidth = 0;
        osLayout.marginHeight = 0;
        osLayout.horizontalSpacing = 0;
        osComposite.setLayout((Layout)osLayout);
        Label osLabel = new Label(osComposite, 16384);
        osLabel.setText(Messages.BugzillaSearchPage_Operating_System);
        osLabel.setLayoutData((Object)new GridData(768));
        this.os = new org.eclipse.swt.widgets.List(osComposite, 2562);
        GridData gd_os = new GridData(4, 4, true, true);
        gd_os.heightHint = 30;
        this.os.setLayoutData((Object)gd_os);
        this.os.addSelectionListener((SelectionListener)this.updateActionSelectionAdapter);
    }

    private void createMoreOptionsChangedInFilter(Composite control) {
        Composite composite = new Composite(control, 0);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 4;
        composite.setLayoutData((Object)gd);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 7;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        Label changedInTheLabel = new Label(composite, 16384);
        changedInTheLabel.setLayoutData((Object)new GridData());
        changedInTheLabel.setText(Messages.BugzillaSearchPage_Changed_in);
        Composite updateComposite = new Composite(composite, 0);
        updateComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout updateLayout = new GridLayout(2, false);
        updateLayout.marginWidth = 0;
        updateLayout.horizontalSpacing = 0;
        updateLayout.marginHeight = 0;
        updateComposite.setLayout((Layout)updateLayout);
        this.daysText = new Text(updateComposite, 2048);
        this.daysText.setLayoutData((Object)new GridData(40, -1));
        this.daysText.setTextLimit(5);
        this.daysText.addListener(24, (Listener)this);
        Label label = new Label(updateComposite, 16384);
        label.setText(Messages.BugzillaSearchPage_days);
    }

    protected Control createSaveQuery(Composite control) {
        Group group = new Group(control, 0);
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(769);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        return group;
    }

    private void handleWidgetSelected(Combo widget, Combo operation, ArrayList<BugzillaSearchData> history) {
        if (widget.getSelectionIndex() < 0) {
            return;
        }
        int index = history.size() - 1 - widget.getSelectionIndex();
        BugzillaSearchData patternData = history.get(index);
        if (patternData == null || !widget.getText().equals(patternData.pattern)) {
            return;
        }
        widget.setText(patternData.pattern);
        operation.setText(operation.getItem(patternData.operation));
    }

    public boolean performSearch() {
        if (this.restoreQueryOptions) {
            this.saveState();
        }
        this.getPatternData(this.summaryPattern, this.summaryOperation, previousSummaryPatterns);
        this.getPatternData(this.commentPattern, this.commentOperation, previousCommentPatterns);
        this.getPatternData(this.emailPattern, this.emailOperation, previousEmailPatterns);
        this.getPatternData(this.emailPattern2, this.emailOperation2, previousEmailPatterns2);
        this.getPatternData(this.keywords, this.keywordsOperation, previousKeywords);
        this.getPatternData(this.whiteboardPattern, this.whiteboardOperation, previousWhiteboardPatterns);
        String summaryText = this.summaryPattern.getText();
        BugzillaUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.bugzilla.query.last", summaryText);
        return super.performSearch();
    }

    public void setVisible(boolean visible) {
        if (visible && this.summaryPattern != null && this.firstTime) {
            String email;
            this.firstTime = false;
            String[] stringArray = this.getPreviousPatterns(previousSummaryPatterns);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String searchPattern = stringArray[n2];
                this.summaryPattern.add(searchPattern);
                ++n2;
            }
            stringArray = this.getPreviousPatterns(previousCommentPatterns);
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String comment = stringArray[n2];
                this.commentPattern.add(comment);
                ++n2;
            }
            stringArray = this.getPreviousPatterns(previousEmailPatterns);
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                email = stringArray[n2];
                this.emailPattern.add(email);
                ++n2;
            }
            stringArray = this.getPreviousPatterns(previousEmailPatterns2);
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                email = stringArray[n2];
                this.emailPattern2.add(email);
                ++n2;
            }
            stringArray = this.getPreviousPatterns(previousKeywords);
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String keyword = stringArray[n2];
                this.keywords.add(keyword);
                ++n2;
            }
        }
        super.setVisible(visible);
    }

    private boolean canQuery() {
        if (this.isControlCreated()) {
            return this.product.getSelectionCount() > 0 || this.component.getSelectionCount() > 0 || this.version.getSelectionCount() > 0 || this.target.getSelectionCount() > 0 || this.status.getSelectionCount() > 0 || this.resolution.getSelectionCount() > 0 || this.severity.getSelectionCount() > 0 || this.priority.getSelectionCount() > 0 || this.hardware.getSelectionCount() > 0 || this.os.getSelectionCount() > 0 || this.summaryPattern.getText().length() > 0 || this.commentPattern.getText().length() > 0 || this.emailPattern.getText().length() > 0 || this.emailPattern2.getText().length() > 0 || this.keywords.getText().length() > 0;
        }
        return false;
    }

    public boolean isPageComplete() {
        String email2;
        FieldDecorationRegistry registry;
        Button button;
        Button[] buttonArray;
        String email;
        String days;
        this.setMessage("");
        if (this.errorDecorations.size() > 0) {
            for (ControlDecoration decoration : this.errorDecorations) {
                decoration.hide();
                decoration.dispose();
            }
            this.errorDecorations.clear();
        }
        if (this.daysText != null && (days = this.daysText.getText()).length() > 0) {
            try {
                if (Integer.parseInt(days) < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (this.getContainer() != null) {
                    this.setMessage(NLS.bind((String)Messages.BugzillaSearchPage_Number_of_days_must_be_a_positive_integer, (Object)days), 3);
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)Messages.BugzillaSearchPage_ValidationTitle, (String)Messages.BugzillaSearchPage_Number_of_days_is_invalid, (IStatus)new Status(4, "org.eclipse.mylyn.bugzilla.ui", NLS.bind((String)Messages.BugzillaSearchPage_days_must_be_an_positve_integer_value_but_is, (Object)days)));
                }
                return false;
            }
        }
        if (this.emailPattern != null && (email = this.emailPattern.getText()).length() > 0) {
            boolean selectionMade = false;
            buttonArray = this.emailButtons;
            int n = this.emailButtons.length;
            int n2 = 0;
            while (n2 < n) {
                button = buttonArray[n2];
                if (button.getSelection()) {
                    selectionMade = true;
                    break;
                }
                ++n2;
            }
            if (!selectionMade) {
                registry = FieldDecorationRegistry.getDefault();
                FieldDecoration fieldDecoration = registry.getFieldDecoration("DEC_ERROR");
                ControlDecoration decoration = new ControlDecoration((Control)this.emailPattern, 17408);
                decoration.setImage(fieldDecoration.getImage());
                decoration.setDescriptionText(NLS.bind((String)Messages.BugzillaSearchPage_ValidationMessage, (Object[])new String[]{Messages.BugzillaSearchPage_Email.replace('&', ' '), Messages.BugzillaSearchPage_owner, Messages.BugzillaSearchPage_reporter, Messages.BugzillaSearchPage_cc, Messages.BugzillaSearchPage_commenter, Messages.BugzillaSearchPage_qacontact}));
                this.errorDecorations.add(decoration);
                if (this.getContainer() != null) {
                    this.setMessage(NLS.bind((String)Messages.BugzillaSearchPage_ValidationMessage, (Object[])new String[]{Messages.BugzillaSearchPage_Email.replace('&', ' '), Messages.BugzillaSearchPage_owner, Messages.BugzillaSearchPage_reporter, Messages.BugzillaSearchPage_cc, Messages.BugzillaSearchPage_commenter, Messages.BugzillaSearchPage_qacontact}), 3);
                }
                return false;
            }
        }
        if (this.emailPattern2 != null && (email2 = this.emailPattern2.getText()).length() > 0) {
            boolean selectionMade = false;
            buttonArray = this.emailButtons2;
            int decoration = this.emailButtons2.length;
            int fieldDecoration = 0;
            while (fieldDecoration < decoration) {
                button = buttonArray[fieldDecoration];
                if (button.getSelection()) {
                    selectionMade = true;
                    break;
                }
                ++fieldDecoration;
            }
            if (!selectionMade) {
                registry = FieldDecorationRegistry.getDefault();
                FieldDecoration fieldDecoration2 = registry.getFieldDecoration("DEC_ERROR");
                ControlDecoration decoration2 = new ControlDecoration((Control)this.emailPattern, 17408);
                decoration2.setImage(fieldDecoration2.getImage());
                decoration2.setDescriptionText(NLS.bind((String)Messages.BugzillaSearchPage_ValidationMessage, (Object[])new String[]{Messages.BugzillaSearchPage_Email_2.replace('&', ' '), Messages.BugzillaSearchPage_owner, Messages.BugzillaSearchPage_reporter, Messages.BugzillaSearchPage_cc, Messages.BugzillaSearchPage_commenter, Messages.BugzillaSearchPage_qacontact}));
                this.errorDecorations.add(decoration2);
                if (this.getContainer() != null) {
                    this.setMessage(NLS.bind((String)Messages.BugzillaSearchPage_ValidationMessage, (Object[])new String[]{Messages.BugzillaSearchPage_Email_2.replace('&', ' '), Messages.BugzillaSearchPage_owner, Messages.BugzillaSearchPage_reporter, Messages.BugzillaSearchPage_cc, Messages.BugzillaSearchPage_commenter, Messages.BugzillaSearchPage_qacontact}), 3);
                }
                return false;
            }
        }
        if (this.getWizard() == null) {
            return this.canQuery();
        }
        return super.isPageComplete() && this.canQuery();
    }

    private BugzillaSearchData getPatternData(Combo widget, Combo operation, ArrayList<BugzillaSearchData> previousSearchQueryData) {
        String pattern = widget.getText();
        if (pattern == null || pattern.trim().equals("")) {
            return null;
        }
        BugzillaSearchData match = null;
        int i = previousSearchQueryData.size() - 1;
        while (i >= 0) {
            match = previousSearchQueryData.get(i);
            if (pattern.equals(match.pattern)) break;
            --i;
        }
        if (i >= 0 && match != null) {
            match.operation = operation.getSelectionIndex();
            previousSearchQueryData.remove(match);
        } else {
            match = new BugzillaSearchData(widget.getText(), operation.getSelectionIndex());
        }
        previousSearchQueryData.add(match);
        return match;
    }

    private String[] getPreviousPatterns(ArrayList<BugzillaSearchData> patternHistory) {
        int size = patternHistory.size();
        String[] patterns = new String[size];
        int i = 0;
        while (i < size) {
            patterns[i] = patternHistory.get((int)(size - 1 - i)).pattern;
            ++i;
        }
        return patterns;
    }

    public String getSearchURL(TaskRepository repository) {
        return this.getQueryURL(repository, this.getQueryParameters());
    }

    protected String getQueryURL(TaskRepository repository, StringBuilder params) {
        StringBuilder url = new StringBuilder(this.getQueryURLStart(repository).toString());
        url.append((CharSequence)params);
        url.append("&order=Importance");
        return url.toString();
    }

    private StringBuilder getQueryURLStart(TaskRepository repository) {
        StringBuilder sb = new StringBuilder(repository.getRepositoryUrl());
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        sb.append("buglist.cgi?");
        return sb;
    }

    protected StringBuilder getQueryParameters() {
        Button[] buttonArray;
        boolean selectionMade;
        int element;
        int[] selected;
        StringBuilder sb = new StringBuilder();
        sb.append("short_desc_type=");
        sb.append(patternOperationValues[this.summaryOperation.getSelectionIndex()]);
        this.appendToBuffer(sb, "&short_desc=", this.summaryPattern.getText());
        int[] nArray = selected = this.product.getSelectionIndices();
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            element = nArray[n2];
            this.appendToBuffer(sb, "&product=", this.product.getItem(element));
            ++n2;
        }
        nArray = selected = this.component.getSelectionIndices();
        n = selected.length;
        n2 = 0;
        while (n2 < n) {
            element = nArray[n2];
            this.appendToBuffer(sb, "&component=", this.component.getItem(element));
            ++n2;
        }
        nArray = selected = this.version.getSelectionIndices();
        n = selected.length;
        n2 = 0;
        while (n2 < n) {
            element = nArray[n2];
            this.appendToBuffer(sb, "&version=", this.version.getItem(element));
            ++n2;
        }
        nArray = selected = this.target.getSelectionIndices();
        n = selected.length;
        n2 = 0;
        while (n2 < n) {
            element = nArray[n2];
            this.appendToBuffer(sb, "&target_milestone=", this.target.getItem(element));
            ++n2;
        }
        sb.append("&long_desc_type=");
        sb.append(patternOperationValues[this.commentOperation.getSelectionIndex()]);
        this.appendToBuffer(sb, "&long_desc=", this.commentPattern.getText());
        nArray = selected = this.status.getSelectionIndices();
        n = selected.length;
        n2 = 0;
        while (n2 < n) {
            element = nArray[n2];
            this.appendToBuffer(sb, "&bug_status=", this.status.getItem(element));
            ++n2;
        }
        nArray = selected = this.resolution.getSelectionIndices();
        n = selected.length;
        n2 = 0;
        while (n2 < n) {
            element = nArray[n2];
            this.appendToBuffer(sb, "&resolution=", this.resolution.getItem(element));
            ++n2;
        }
        nArray = selected = this.severity.getSelectionIndices();
        n = selected.length;
        n2 = 0;
        while (n2 < n) {
            element = nArray[n2];
            this.appendToBuffer(sb, "&bug_severity=", this.severity.getItem(element));
            ++n2;
        }
        nArray = selected = this.priority.getSelectionIndices();
        n = selected.length;
        n2 = 0;
        while (n2 < n) {
            element = nArray[n2];
            this.appendToBuffer(sb, "&priority=", this.priority.getItem(element));
            ++n2;
        }
        nArray = selected = this.hardware.getSelectionIndices();
        n = selected.length;
        n2 = 0;
        while (n2 < n) {
            element = nArray[n2];
            this.appendToBuffer(sb, "&rep_platform=", this.hardware.getItem(element));
            ++n2;
        }
        nArray = selected = this.os.getSelectionIndices();
        n = selected.length;
        n2 = 0;
        while (n2 < n) {
            element = nArray[n2];
            this.appendToBuffer(sb, "&op_sys=", this.os.getItem(element));
            ++n2;
        }
        if (this.emailPattern.getText() != null && !this.emailPattern.getText().trim().equals("")) {
            selectionMade = false;
            buttonArray = this.emailButtons;
            int n3 = this.emailButtons.length;
            n = 0;
            while (n < n3) {
                Button button = buttonArray[n];
                if (button.getSelection()) {
                    selectionMade = true;
                    break;
                }
                ++n;
            }
            if (selectionMade) {
                int i = 0;
                while (i < this.emailButtons.length) {
                    if (this.emailButtons[i].getSelection()) {
                        sb.append("&");
                        sb.append(emailRoleValues[i]);
                        sb.append("=1");
                    }
                    ++i;
                }
                sb.append("&emailtype1=");
                sb.append(emailOperationValues[this.emailOperation.getSelectionIndex()]);
                this.appendToBuffer(sb, "&email1=", this.emailPattern.getText());
            }
        }
        if (this.emailPattern2.getText() != null && !this.emailPattern2.getText().trim().equals("")) {
            selectionMade = false;
            buttonArray = this.emailButtons2;
            int n4 = this.emailButtons2.length;
            n = 0;
            while (n < n4) {
                Button button = buttonArray[n];
                if (button.getSelection()) {
                    selectionMade = true;
                    break;
                }
                ++n;
            }
            if (selectionMade) {
                int i = 0;
                while (i < this.emailButtons2.length) {
                    if (this.emailButtons2[i].getSelection()) {
                        sb.append("&");
                        sb.append(emailRoleValues2[i]);
                        sb.append("=1");
                    }
                    ++i;
                }
                sb.append("&emailtype2=");
                sb.append(emailOperationValues[this.emailOperation2.getSelectionIndex()]);
                this.appendToBuffer(sb, "&email2=", this.emailPattern2.getText());
            }
        }
        if (this.daysText.getText() != null && !this.daysText.getText().equals("")) {
            try {
                Integer.parseInt(this.daysText.getText());
                this.appendToBuffer(sb, "&changedin=", this.daysText.getText());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this.keywords.getText() != null && !this.keywords.getText().trim().equals("")) {
            sb.append("&keywords_type=");
            sb.append(keywordOperationValues[this.keywordsOperation.getSelectionIndex()]);
            this.appendToBuffer(sb, "&keywords=", this.keywords.getText().replace(',', ' '));
        }
        sb.append("&status_whiteboard_type=");
        sb.append(patternOperationValues[this.whiteboardOperation.getSelectionIndex()]);
        this.appendToBuffer(sb, "&status_whiteboard=", this.whiteboardPattern.getText());
        int indexMax = this.charts.size();
        int index = 0;
        while (index < indexMax) {
            Chart chart = this.charts.get(index);
            if (chart.isNegate()) {
                sb.append("&negate" + index + "=1");
            }
            int rowMax = chart.getRowSize();
            int row = 0;
            while (row < rowMax) {
                int columnMax = chart.getColumnSize(row);
                int column = 0;
                while (column < columnMax) {
                    ChartExpression chartExpression = chart.getChartExpression(row, column);
                    if (chartExpression.getFieldName() != 0) {
                        sb.append("&field" + index + "-" + row + "-" + column + "=" + this.chartFieldValues[chartExpression.getFieldName()]);
                        sb.append("&type" + index + "-" + row + "-" + column + "=" + chartOperationValues[chartExpression.getOperation()]);
                        sb.append("&value" + index + "-" + row + "-" + column + "=" + chartExpression.getValue());
                    }
                    ++column;
                }
                ++row;
            }
            ++index;
        }
        return sb;
    }

    private void appendToBuffer(StringBuilder sb, String key, String value) {
        sb.append(key);
        try {
            sb.append(URLEncoder.encode(value, this.getTaskRepository().getCharacterEncoding()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            sb.append(value);
        }
    }

    public IDialogSettings getDialogSettings() {
        IDialogSettings settings = BugzillaUiPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(PAGE_NAME);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(PAGE_NAME);
        }
        return this.fDialogSettings;
    }

    private void updateAttributesFromConfiguration(String[] selectedProducts) {
        RepositoryConfiguration repositoryConfiguration = this.getRepositoryConfiguration();
        if (repositoryConfiguration != null) {
            String[] saved_status = this.status.getSelection();
            String[] saved_resolution = this.resolution.getSelection();
            String[] saved_severity = this.severity.getSelection();
            String[] saved_priority = this.priority.getSelection();
            String[] saved_hardware = this.hardware.getSelection();
            String[] saved_os = this.os.getSelection();
            List products = repositoryConfiguration.getOptionValues(BugzillaAttribute.PRODUCT);
            String[] productsList = products.toArray(new String[products.size()]);
            Arrays.sort(productsList, String.CASE_INSENSITIVE_ORDER);
            this.product.setItems(productsList);
            this.updateAttributesBasedOnProductSelection(selectedProducts, repositoryConfiguration);
            this.status.setItems(this.convertStringListToArray(repositoryConfiguration.getOptionValues(BugzillaAttribute.BUG_STATUS)));
            this.resolution.setItems(this.convertStringListToArray(repositoryConfiguration.getOptionValues(BugzillaAttribute.RESOLUTION)));
            this.severity.setItems(this.convertStringListToArray(repositoryConfiguration.getOptionValues(BugzillaAttribute.BUG_SEVERITY)));
            this.priority.setItems(this.convertStringListToArray(repositoryConfiguration.getOptionValues(BugzillaAttribute.PRIORITY)));
            this.hardware.setItems(this.convertStringListToArray(repositoryConfiguration.getOptionValues(BugzillaAttribute.REP_PLATFORM)));
            this.os.setItems(this.convertStringListToArray(repositoryConfiguration.getOptionValues(BugzillaAttribute.OP_SYS)));
            this.setSelection(this.product, selectedProducts);
            this.setSelection(this.status, saved_status);
            this.setSelection(this.resolution, saved_resolution);
            this.setSelection(this.severity, saved_severity);
            this.setSelection(this.priority, saved_priority);
            this.setSelection(this.hardware, saved_hardware);
            this.setSelection(this.os, saved_os);
            ArrayList fieldText = (ArrayList)chartFieldTextDefault.clone();
            ArrayList fieldValue = (ArrayList)chartFieldValuesDefault.clone();
            for (BugzillaCustomField bugzillaCustomField : repositoryConfiguration.getCustomFields()) {
                fieldValue.add(bugzillaCustomField.getName());
                fieldText.add(bugzillaCustomField.getDescription());
            }
            this.chartFieldText = fieldText.toArray(new String[fieldText.size()]);
            this.chartFieldValues = fieldValue.toArray(new String[fieldValue.size()]);
            this.recreateChartControls();
        }
    }

    private void updateAttributesBasedOnProductSelection(String[] selectedProducts, RepositoryConfiguration repositoryConfiguration) {
        if (repositoryConfiguration == null) {
            return;
        }
        if (selectedProducts != null && selectedProducts.length == 0) {
            selectedProducts = null;
        }
        String[] saved_component = this.component.getSelection();
        String[] saved_version = this.version.getSelection();
        String[] saved_target = this.target.getSelection();
        String[] componentsList = BugzillaUiPlugin.getQueryOptions("org.eclipse.mylyn.bugzilla.values.component", selectedProducts, repositoryConfiguration);
        Arrays.sort(componentsList, String.CASE_INSENSITIVE_ORDER);
        this.component.setItems(componentsList);
        this.version.setItems(BugzillaUiPlugin.getQueryOptions("org.eclipse.mylyn.bugzilla.values.version", selectedProducts, repositoryConfiguration));
        this.target.setItems(BugzillaUiPlugin.getQueryOptions("org.eclipse.mylyn.bugzilla.values.target", selectedProducts, repositoryConfiguration));
        this.setSelection(this.component, saved_component);
        this.setSelection(this.version, saved_version);
        this.setSelection(this.target, saved_target);
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void handleEvent(Event event) {
        if (this.getWizard() != null) {
            this.getWizard().getContainer().updateButtons();
        } else {
            this.isPageComplete();
        }
    }

    public void restoreStateFromUrl(String queryUrl) throws UnsupportedEncodingException {
        BugzillaSearch search = new BugzillaSearch(this.getTaskRepository(), queryUrl);
        for (BugzillaSearch.Entry entry : search.getParameters("product")) {
            String value = entry.value;
            String[] sel = this.product.getSelection();
            List<String> selList = Arrays.asList(sel);
            selList = new ArrayList<String>(selList);
            selList.add(value);
            sel = new String[selList.size()];
            this.product.setSelection(selList.toArray(sel));
        }
        this.updateAttributesBasedOnProductSelection(this.product.getSelection(), this.getRepositoryConfiguration());
        boolean adjustChart = false;
        block5: for (BugzillaSearch.Entry entry : search.getParameters()) {
            int index;
            Matcher mb;
            List<String> selList;
            String item;
            int n;
            String[] stringArray;
            String key = entry.key;
            String value = entry.value;
            if (key.equals("short_desc")) {
                this.summaryPattern.setText(value);
                continue;
            }
            if (key.equals("short_desc_type")) {
                int index2 = 0;
                stringArray = patternOperationValues;
                int n2 = patternOperationValues.length;
                n = 0;
                while (n < n2) {
                    item = stringArray[n];
                    if (item.compareTo(value) == 0) break;
                    ++index2;
                    ++n;
                }
                if (index2 >= this.summaryOperation.getItemCount()) continue;
                this.summaryOperation.select(index2);
                continue;
            }
            if (key.equals("product")) continue;
            if (key.equals("component")) {
                String[] sel = this.component.getSelection();
                selList = Arrays.asList(sel);
                selList = new ArrayList<String>(selList);
                selList.add(value);
                sel = new String[selList.size()];
                this.component.setSelection(selList.toArray(sel));
                continue;
            }
            if (key.equals("version")) {
                String[] sel = this.version.getSelection();
                selList = Arrays.asList(sel);
                selList = new ArrayList<String>(selList);
                selList.add(value);
                sel = new String[selList.size()];
                this.version.setSelection(selList.toArray(sel));
                continue;
            }
            if (key.equals("target_milestone")) {
                String[] sel = this.target.getSelection();
                selList = Arrays.asList(sel);
                selList = new ArrayList<String>(selList);
                selList.add(value);
                sel = new String[selList.size()];
                this.target.setSelection(selList.toArray(sel));
                continue;
            }
            if (key.equals("version")) {
                String[] sel = this.version.getSelection();
                selList = Arrays.asList(sel);
                selList = new ArrayList<String>(selList);
                selList.add(value);
                sel = new String[selList.size()];
                this.version.setSelection(selList.toArray(sel));
                continue;
            }
            if (key.equals("long_desc_type")) {
                int index3 = 0;
                stringArray = patternOperationValues;
                int n3 = patternOperationValues.length;
                n = 0;
                while (n < n3) {
                    item = stringArray[n];
                    if (item.compareTo(value) == 0) break;
                    ++index3;
                    ++n;
                }
                if (index3 >= this.commentOperation.getItemCount()) continue;
                this.commentOperation.select(index3);
                continue;
            }
            if (key.equals("long_desc")) {
                this.commentPattern.setText(value);
                continue;
            }
            if (key.equals("bug_status")) {
                String[] sel = this.status.getSelection();
                selList = Arrays.asList(sel);
                selList = new ArrayList<String>(selList);
                selList.add(value);
                sel = new String[selList.size()];
                this.status.setSelection(selList.toArray(sel));
                continue;
            }
            if (key.equals("resolution")) {
                String[] sel = this.resolution.getSelection();
                selList = Arrays.asList(sel);
                selList = new ArrayList<String>(selList);
                selList.add(value);
                sel = new String[selList.size()];
                this.resolution.setSelection(selList.toArray(sel));
                continue;
            }
            if (key.equals("bug_severity")) {
                String[] sel = this.severity.getSelection();
                selList = Arrays.asList(sel);
                selList = new ArrayList<String>(selList);
                selList.add(value);
                sel = new String[selList.size()];
                this.severity.setSelection(selList.toArray(sel));
                continue;
            }
            if (key.equals("priority")) {
                String[] sel = this.priority.getSelection();
                selList = Arrays.asList(sel);
                selList = new ArrayList<String>(selList);
                selList.add(value);
                sel = new String[selList.size()];
                this.priority.setSelection(selList.toArray(sel));
                continue;
            }
            if (key.equals("rep_platform")) {
                String[] sel = this.hardware.getSelection();
                selList = Arrays.asList(sel);
                selList = new ArrayList<String>(selList);
                selList.add(value);
                sel = new String[selList.size()];
                this.hardware.setSelection(selList.toArray(sel));
                continue;
            }
            if (key.equals("op_sys")) {
                String[] sel = this.os.getSelection();
                selList = Arrays.asList(sel);
                selList = new ArrayList<String>(selList);
                selList.add(value);
                sel = new String[selList.size()];
                this.os.setSelection(selList.toArray(sel));
                continue;
            }
            if (key.equals("emailassigned_to1")) {
                if (value.equals("1")) {
                    this.emailButtons[0].setSelection(true);
                    continue;
                }
                this.emailButtons[0].setSelection(false);
                continue;
            }
            if (key.equals("emailreporter1")) {
                if (value.equals("1")) {
                    this.emailButtons[1].setSelection(true);
                    continue;
                }
                this.emailButtons[1].setSelection(false);
                continue;
            }
            if (key.equals("emailcc1")) {
                if (value.equals("1")) {
                    this.emailButtons[2].setSelection(true);
                    continue;
                }
                this.emailButtons[2].setSelection(false);
                continue;
            }
            if (key.equals("emaillongdesc1")) {
                if (value.equals("1")) {
                    this.emailButtons[3].setSelection(true);
                    continue;
                }
                this.emailButtons[3].setSelection(false);
                continue;
            }
            if (key.equals("emailqa_contact1")) {
                if (value.equals("1")) {
                    this.emailButtons[4].setSelection(true);
                    continue;
                }
                this.emailButtons[4].setSelection(false);
                continue;
            }
            if (key.equals("emailtype1")) {
                int index4 = 0;
                while (index4 < emailOperationValues.length) {
                    item = emailOperationValues[index4];
                    if (item.compareTo(value) == 0) break;
                    ++index4;
                }
                if (index4 >= this.emailOperation.getItemCount()) continue;
                this.emailOperation.select(index4);
                continue;
            }
            if (key.equals("email1")) {
                this.emailPattern.setText(value);
                continue;
            }
            if (key.equals("emailassigned_to2")) {
                if (value.equals("1")) {
                    this.emailButtons2[0].setSelection(true);
                    continue;
                }
                this.emailButtons2[0].setSelection(false);
                continue;
            }
            if (key.equals("emailreporter2")) {
                if (value.equals("1")) {
                    this.emailButtons2[1].setSelection(true);
                    continue;
                }
                this.emailButtons2[1].setSelection(false);
                continue;
            }
            if (key.equals("emailcc2")) {
                if (value.equals("1")) {
                    this.emailButtons2[2].setSelection(true);
                    continue;
                }
                this.emailButtons2[2].setSelection(false);
                continue;
            }
            if (key.equals("emaillongdesc2")) {
                if (value.equals("1")) {
                    this.emailButtons2[3].setSelection(true);
                    continue;
                }
                this.emailButtons2[3].setSelection(false);
                continue;
            }
            if (key.equals("emailqa_contact2")) {
                if (value.equals("1")) {
                    this.emailButtons2[4].setSelection(true);
                    continue;
                }
                this.emailButtons2[4].setSelection(false);
                continue;
            }
            if (key.equals("emailtype2")) {
                int index5 = 0;
                while (index5 < emailOperationValues.length) {
                    item = emailOperationValues[index5];
                    if (item.compareTo(value) == 0) break;
                    ++index5;
                }
                if (index5 >= this.emailOperation2.getItemCount()) continue;
                this.emailOperation2.select(index5);
                continue;
            }
            if (key.equals("email2")) {
                this.emailPattern2.setText(value);
                continue;
            }
            if (key.equals("changedin")) {
                this.daysText.setText(value);
                continue;
            }
            if (key.equals("keywords")) {
                this.keywords.setText(value.replace(' ', ','));
                continue;
            }
            if (key.equals("keywords_type")) {
                int index6 = 0;
                stringArray = keywordOperationValues;
                int n4 = keywordOperationValues.length;
                n = 0;
                while (n < n4) {
                    item = stringArray[n];
                    if (item.equals(value)) {
                        this.keywordsOperation.select(index6);
                        continue block5;
                    }
                    ++index6;
                    ++n;
                }
                continue;
            }
            if (key.equals("status_whiteboard_type")) {
                int index7 = 0;
                stringArray = patternOperationValues;
                int n5 = patternOperationValues.length;
                n = 0;
                while (n < n5) {
                    item = stringArray[n];
                    if (item.compareTo(value) == 0) break;
                    ++index7;
                    ++n;
                }
                if (index7 >= this.whiteboardOperation.getItemCount()) continue;
                this.whiteboardOperation.select(index7);
                continue;
            }
            if (key.equals("status_whiteboard")) {
                this.whiteboardPattern.setText(value);
                continue;
            }
            if (key.matches(REGEXP_CHART_EXPR)) {
                String item2;
                int n6;
                int n7;
                String[] stringArray2;
                int index1;
                int column;
                int row;
                int chartNumber;
                Matcher mb2 = PATTERN_CHART_EXPR.matcher(key);
                if (!mb2.find()) continue;
                String g1 = mb2.group(1);
                String g2 = mb2.group(2);
                String g3 = mb2.group(3);
                String g4 = mb2.group(4);
                try {
                    chartNumber = Integer.parseInt(g2);
                    row = Integer.parseInt(g3);
                    column = Integer.parseInt(g4);
                }
                catch (Exception exception) {
                    chartNumber = -1;
                    row = -1;
                    column = -1;
                }
                int i = this.charts.size();
                while (i <= chartNumber) {
                    this.charts.add(new Chart());
                    adjustChart = true;
                    ++i;
                }
                i = this.charts.get(chartNumber).getRowSize();
                while (i <= row) {
                    this.charts.get(chartNumber).addExpression(i, 0);
                    adjustChart = true;
                    ++i;
                }
                i = this.charts.get(chartNumber).getColumnSize(row);
                while (i <= column) {
                    this.charts.get(chartNumber).addExpression(row, i);
                    adjustChart = true;
                    ++i;
                }
                ChartExpression ex = this.charts.get(chartNumber).getChartExpression(row, column);
                if ("field".equals(g1)) {
                    index1 = 0;
                    stringArray2 = this.chartFieldValues;
                    n7 = this.chartFieldValues.length;
                    n6 = 0;
                    while (n6 < n7) {
                        item2 = stringArray2[n6];
                        if (item2.compareTo(value) == 0) break;
                        ++index1;
                        ++n6;
                    }
                    if (index1 >= this.chartFieldValues.length) continue;
                    ex.setFieldName(index1);
                    continue;
                }
                if ("type".equals(g1)) {
                    index1 = 0;
                    stringArray2 = chartOperationValues;
                    n7 = chartOperationValues.length;
                    n6 = 0;
                    while (n6 < n7) {
                        item2 = stringArray2[n6];
                        if (item2.compareTo(value) == 0) break;
                        ++index1;
                        ++n6;
                    }
                    if (index1 >= chartOperationValues.length) continue;
                    ex.setOperation(index1);
                    continue;
                }
                if (!"value".equals(g1)) continue;
                ex.setValue(value);
                continue;
            }
            if (!key.matches(REGEXP_CHART_NEGATE) || !(mb = PATTERN_CHART_NEGATE.matcher(key)).find()) continue;
            String g2 = mb.group(2);
            try {
                index = Integer.parseInt(g2);
            }
            catch (Exception exception) {
                index = -1;
            }
            Chart ch = this.charts.get(index);
            ch.setNegate("1".equals(value));
        }
        if (adjustChart) {
            this.recreateChartControls();
        }
    }

    public int getProductCount() throws Exception {
        return this.product.getItemCount();
    }

    public boolean isRestoreQueryOptions() {
        return this.restoreQueryOptions;
    }

    public void setRestoreQueryOptions(boolean restoreQueryOptions) {
        this.restoreQueryOptions = restoreQueryOptions;
    }

    private String[] convertStringListToArray(List<String> stringList) {
        return stringList.toArray(new String[stringList.size()]);
    }

    private void setSelection(org.eclipse.swt.widgets.List listControl, String[] selection) {
        listControl.setSelection(selection);
    }

    public void dispose() {
        if (this.toolkit != null && this.toolkit.getColors() != null) {
            this.toolkit.dispose();
        }
        super.dispose();
    }

    private void refreshChartControls() {
        int chartNumMax = this.chartControls.size();
        int chartNum = 0;
        while (chartNum < chartNumMax) {
            int chartRowMax = this.chartControls.get(chartNum).size();
            int chartRow = 0;
            while (chartRow < chartRowMax) {
                int chartColumnMax = this.chartControls.get(chartNum).get(chartRow).size();
                int chartColumn = 0;
                while (chartColumn < chartColumnMax) {
                    ChartExpression expression = this.charts.get(chartNum).getChartExpression(chartRow, chartColumn);
                    ChartControls controls = this.chartControls.get(chartNum).get(chartRow).get(chartColumn);
                    controls.getField().setText(this.chartFieldText[expression.getFieldName()]);
                    controls.getOperation().setText(chartOperationText[expression.getOperation()]);
                    controls.getValue().setText(expression.getValue());
                    ++chartColumn;
                }
                ++chartRow;
            }
            ++chartNum;
        }
        int negButtonMax = this.negateButtons.size();
        int chartNum2 = 0;
        while (chartNum2 < negButtonMax) {
            Button b = this.negateButtons.get(chartNum2);
            Chart c = this.charts.get(chartNum2);
            b.setSelection(c.isNegate());
            ++chartNum2;
        }
        this.scrolledComposite.reflow(true);
    }

    private void recreateChartControls() {
        if (this.chartSection.getClient() != null) {
            this.chartSection.getClient().dispose();
        }
        this.chartControls.clear();
        this.negateButtons.clear();
        Composite chartGroup = new Composite((Composite)this.chartSection, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        chartGroup.setLayout((Layout)layout);
        this.chartSection.setClient((Control)chartGroup);
        int chartNumMax = this.charts.size();
        int chartNumber = 0;
        while (chartNumber < chartNumMax) {
            GridData gd;
            final int chartNum = chartNumber;
            Composite chartGroup0 = new Composite(chartGroup, 0);
            if (chartNum > 0) {
                Label sep = new Label(chartGroup0, 0);
                sep.setText(" ");
                gd = new GridData(4, 2, true, false, 3, 1);
                sep.setLayoutData((Object)gd);
            }
            layout = new GridLayout(3, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            chartGroup0.setLayout((Layout)layout);
            gd = new GridData(4, 4, true, true, 3, 1);
            chartGroup0.setLayoutData((Object)gd);
            int chartRowMax = this.charts.get(chartNum).getRowSize();
            int chartRowNumber = 0;
            while (chartRowNumber < chartRowMax) {
                final int chartRow = chartRowNumber;
                int chartColumnMax = this.charts.get(chartNum).getColumnSize(chartRow);
                Group chartGroup1 = new Group(chartGroup0, 0);
                layout = new GridLayout(4, false);
                chartGroup1.setLayout((Layout)layout);
                gd = new GridData(4, 4, true, true, 3, 1);
                chartGroup1.setLayoutData((Object)gd);
                int chartColumnNumber = 0;
                while (chartColumnNumber < chartColumnMax) {
                    int chart2;
                    final int chartColumn = chartColumnNumber;
                    final Combo comboField = new Combo((Composite)chartGroup1, 2052);
                    comboField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                    comboField.addModifyListener((ModifyListener)new ModifyListenerImplementation());
                    comboField.setItems(this.chartFieldText);
                    comboField.setText(this.chartFieldText[0]);
                    comboField.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ChartExpression chartExpression = ((Chart)BugzillaSearchPage.this.charts.get(chartNum)).getChartExpression(chartRow, chartColumn);
                            chartExpression.setFieldName(comboField.getSelectionIndex());
                            comboField.getShell().layout(true);
                            comboField.getShell().redraw();
                        }
                    });
                    comboField.setToolTipText(Messages.BugzillaSearchPage_Tooltip_Custom_fields_at_end);
                    final Combo comboOperation = new Combo((Composite)chartGroup1, 2060);
                    comboOperation.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                    comboOperation.setItems(chartOperationText);
                    comboOperation.setText(chartOperationText[0]);
                    comboOperation.select(0);
                    comboOperation.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ChartExpression chartExpression = ((Chart)BugzillaSearchPage.this.charts.get(chartNum)).getChartExpression(chartRow, chartColumn);
                            chartExpression.setOperation(comboOperation.getSelectionIndex());
                        }
                    });
                    final Combo comboValue = new Combo((Composite)chartGroup1, 2052);
                    gd = new GridData(4, 2, true, false);
                    gd.widthHint = 150;
                    comboValue.setLayoutData((Object)gd);
                    comboValue.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            ChartExpression chartExpression = ((Chart)BugzillaSearchPage.this.charts.get(chartNum)).getChartExpression(chartRow, chartColumn);
                            chartExpression.setValue(comboValue.getText());
                            if (BugzillaSearchPage.this.isControlCreated()) {
                                BugzillaSearchPage.this.setPageComplete(BugzillaSearchPage.this.isPageComplete());
                            }
                        }
                    });
                    Button orButton = new Button((Composite)chartGroup1, 8);
                    orButton.setText(Messages.BugzillaSearchPage_OR_Button);
                    gd = new GridData(16384, 0x1000000, false, false);
                    orButton.setLayoutData((Object)gd);
                    orButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (e.stateMask == 131072) {
                                if (BugzillaSearchPage.this.charts.size() == 1 && ((Chart)BugzillaSearchPage.this.charts.get(0)).getRowSize() == 1 && ((Chart)BugzillaSearchPage.this.charts.get(0)).getColumnSize(0) == 1) {
                                    return;
                                }
                                ((Chart)BugzillaSearchPage.this.charts.get(chartNum)).removeColumn(chartRow, chartColumn);
                                if (((Chart)BugzillaSearchPage.this.charts.get(chartNum)).getRowSize() == 0 && chartNum != 0) {
                                    BugzillaSearchPage.this.charts.remove(chartNum);
                                }
                            } else {
                                ((Chart)BugzillaSearchPage.this.charts.get(chartNum)).addExpression(chartRow, chartColumn + 1);
                            }
                            BugzillaSearchPage.this.recreateChartControls();
                        }
                    });
                    orButton.setToolTipText(Messages.BugzillaSearchPage_Tooltip_remove_row);
                    ChartControls chartControl = new ChartControls(comboField, comboOperation, comboValue);
                    int chart1 = this.chartControls.size();
                    if (chart1 < chartNum + 1) {
                        this.chartControls.add(new ArrayList());
                    }
                    if ((chart2 = this.chartControls.get(chartNum).size()) < chartRow + 1) {
                        this.chartControls.get(chartNum).add(new ArrayList());
                    }
                    this.chartControls.get(chartNum).get(chartRow).add(chartControl);
                    ++chartColumnNumber;
                }
                if (chartRowNumber < chartRowMax - 1) {
                    Label lable = new Label(chartGroup0, 0);
                    lable.setText(Messages.BugzillaSearchPage_AND_Button);
                    GridData g = new GridData(16384, 0x1000000, false, false, 4, 1);
                    lable.setLayoutData((Object)g);
                } else {
                    Button andButton = new Button(chartGroup0, 8);
                    andButton.setText(Messages.BugzillaSearchPage_AND_Button);
                    gd = new GridData(16384, 0x1000000, false, false, 1, 1);
                    andButton.setLayoutData((Object)gd);
                    final Button newButton = new Button(chartGroup0, 8);
                    newButton.setText(Messages.BugzillaSearchPage_Add_Chart_Button);
                    gd = new GridData(16384, 0x1000000, false, false, 1, 1);
                    newButton.setLayoutData((Object)gd);
                    final Button negateButton = new Button(chartGroup0, 32);
                    negateButton.setText(Messages.BugzillaSearchPage_Negate_Button);
                    this.negateButtons.add(negateButton);
                    gd = new GridData(16384, 0x1000000, false, false, 1, 1);
                    negateButton.setLayoutData((Object)gd);
                    negateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            Chart chart = (Chart)BugzillaSearchPage.this.charts.get(chartNum);
                            chart.setNegate(negateButton.getSelection());
                        }
                    });
                    newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            newButton.setVisible(false);
                            newButton.dispose();
                            BugzillaSearchPage.this.charts.add(chartNum + 1, new Chart());
                            BugzillaSearchPage.this.recreateChartControls();
                        }
                    });
                    andButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ((Chart)BugzillaSearchPage.this.charts.get(chartNum)).addExpression(chartRow + 1, 0);
                            BugzillaSearchPage.this.recreateChartControls();
                        }
                    });
                }
                ++chartRowNumber;
            }
            ++chartNumber;
        }
        this.chartSection.layout(true);
        this.scrolledComposite.reflow(true);
        this.refreshChartControls();
        Dialog.applyDialogFont((Control)this.chartSection);
    }

    public BugzillaSearchPage(TaskRepository repository) {
        this(repository, null);
    }

    public BugzillaSearchPage(TaskRepository repository, IRepositoryQuery origQuery) {
        super(Messages.BugzillaSearchPage_Bugzilla_Query, repository, origQuery);
        this.originalQuery = origQuery;
        this.setNeedsClear(true);
        this.setDescription(Messages.BugzillaSearchPage_Select_the_Bugzilla_query_parameters);
        this.setMessage(Messages.BugzillaSearchPage_Enter_search_option);
        this.toolkit = new FormToolkit(Display.getCurrent());
    }

    protected boolean hasRepositoryConfiguration() {
        return this.getRepositoryConfiguration() != null;
    }

    public RepositoryConfiguration getRepositoryConfiguration() {
        return ((BugzillaRepositoryConnector)this.getConnector()).getRepositoryConfiguration(this.getTaskRepository().getUrl());
    }

    protected void doRefreshControls() {
        this.updateAttributesFromConfiguration(this.product.getSelection());
    }

    protected boolean restoreState(IRepositoryQuery query) {
        if (query != null) {
            try {
                this.restoreStateFromUrl(query.getUrl());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        boolean reflow = false;
        if (this.commentPattern.getText().length() > 0 || this.emailPattern2.getText().length() > 0 || this.keywords.getText().length() > 0 || this.whiteboardPattern.getText().length() > 0 || this.priority.getSelection().length > 0 || this.resolution.getSelection().length > 0 || this.version.getSelection().length > 0 || this.target.getSelection().length > 0 || this.hardware.getSelection().length > 0 || this.os.getSelection().length > 0) {
            this.moreOptionsSection.setExpanded(true);
            reflow = true;
        }
        if (this.charts.size() > 0 && this.charts.get(0).getChartExpression(0, 0).getFieldName() > 0) {
            this.chartSection.setExpanded(true);
            reflow = true;
        }
        if (reflow) {
            this.scrolledComposite.reflow(true);
        }
        this.refreshChartControls();
        this.setPageComplete(this.isPageComplete());
        return true;
    }

    public void applyTo(IRepositoryQuery query) {
        query.setUrl(this.getQueryURL(this.getTaskRepository(), this.getQueryParameters()));
        query.setSummary(this.getQueryTitle());
    }

    private static class BugzillaSearchData {
        String pattern;
        int operation;

        BugzillaSearchData(String pattern, int operation) {
            this.pattern = pattern;
            this.operation = operation;
        }
    }

    private class ChartControls {
        private final Combo field;
        private final Combo operation;
        private final Combo value;

        public ChartControls(Combo field, Combo operation, Combo value) {
            this.field = field;
            this.operation = operation;
            this.value = value;
        }

        public Combo getField() {
            return this.field;
        }

        public Combo getOperation() {
            return this.operation;
        }

        public Combo getValue() {
            return this.value;
        }
    }

    private final class ModifyListenerImplementation
    implements ModifyListener {
        private ModifyListenerImplementation() {
        }

        public void modifyText(ModifyEvent e) {
            if (BugzillaSearchPage.this.isControlCreated()) {
                BugzillaSearchPage.this.setPageComplete(BugzillaSearchPage.this.isPageComplete());
            }
        }
    }
}

