/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.viewers.statistics.model;

import org.eclipse.linuxtools.tmf.ui.viewers.statistics.model.Messages;
import org.eclipse.linuxtools.tmf.ui.viewers.statistics.model.TmfStatisticsTreeNode;

public class TmfStatisticsTree {
    public static final String HEADER_EVENT_TYPES = Messages.TmfStatisticsData_EventTypes;
    private final TmfStatisticsTreeNode rootNode = new TmfStatisticsTreeNode(this, null, new String[0]);

    public TmfStatisticsTreeNode getRootNode() {
        return this.rootNode;
    }

    public TmfStatisticsTreeNode getNode(String ... path) {
        TmfStatisticsTreeNode curNode = this.rootNode;
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String pathElem = stringArray[n2];
            if ((curNode = curNode.getChild(pathElem)) == null) break;
            ++n2;
        }
        return curNode;
    }

    public TmfStatisticsTreeNode getOrCreateNode(String ... path) {
        TmfStatisticsTreeNode curNode = this.rootNode;
        String[] stringArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String pathElem = stringArray[n2];
            TmfStatisticsTreeNode nextNode = curNode.getChild(pathElem);
            if (nextNode == null) {
                nextNode = curNode.addChild(pathElem);
            }
            curNode = nextNode;
            ++n2;
        }
        return curNode;
    }

    public void setTotal(String traceName, boolean isGlobal, long qty) {
        String[][] paths;
        String[][] stringArray = paths = this.getNormalPaths(traceName);
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String[] path = stringArray[n2];
            this.getOrCreateNode(path).getValues().setValue(isGlobal, qty);
            ++n2;
        }
    }

    public void setTypeCount(String traceName, String type, boolean isGlobal, long qty) {
        String[][] paths;
        String[][] stringArray = paths = this.getTypePaths(traceName, type);
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String[] path = stringArray[n2];
            this.getOrCreateNode(path).getValues().setValue(isGlobal, qty);
            ++n2;
        }
    }

    protected String[][] getTypePaths(String traceName, String type) {
        String[][] paths = new String[][]{{traceName, HEADER_EVENT_TYPES, type}};
        return paths;
    }

    protected String[][] getNormalPaths(String traceName) {
        String[][] paths = new String[][]{{traceName}};
        return paths;
    }

    protected static String mergeString(String ... strings) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            builder.append(s);
            ++n2;
        }
        return builder.toString();
    }
}

