/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace.AbstractImportTraceWizardPage;
import org.eclipse.linuxtools.tmf.ui.project.wizards.importtrace.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;

public class ImportTraceWizardPageOptions
extends AbstractImportTraceWizardPage {
    private List fProjects;
    private final Map<String, IProject> fProjectsMap = new LinkedHashMap<String, IProject>();

    public ImportTraceWizardPageOptions(IWorkbench workbench, IStructuredSelection selection) {
        super(workbench, selection);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        IFolder originalFolder = this.getBatchWizard().getTargetFolder();
        IProject proj = null;
        if (originalFolder != null) {
            proj = originalFolder.getProject();
        }
        Composite optionPane = (Composite)this.getControl();
        optionPane.setLayout((Layout)new GridLayout());
        optionPane.setLayoutData((Object)new GridData(16384, 128, true, true));
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.fProjects = new List(optionPane, 0);
        this.fProjects.setLayoutData((Object)new GridData(4, 4, true, true));
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.getNature("org.eclipse.linuxtools.tmf.project.nature") != null) {
                    String name = project.getName();
                    this.fProjectsMap.put(name, project);
                    this.fProjects.add(name);
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        this.fProjects.getSelection();
        this.fProjects.addSelectionListener(new SelectionListener(){
            private static final String TRACE = "Traces";

            public void widgetSelected(SelectionEvent e) {
                String listItem = ImportTraceWizardPageOptions.this.fProjects.getSelection()[0];
                IFolder folder = ((IProject)ImportTraceWizardPageOptions.this.fProjectsMap.get(listItem)).getFolder(TRACE);
                ImportTraceWizardPageOptions.this.getBatchWizard().setTraceFolder(folder);
                ImportTraceWizardPageOptions.this.setErrorMessage(null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                String listItem = ImportTraceWizardPageOptions.this.fProjects.getSelection()[0];
                IFolder folder = ((IProject)ImportTraceWizardPageOptions.this.fProjectsMap.get(listItem)).getFolder(TRACE);
                ImportTraceWizardPageOptions.this.getBatchWizard().setTraceFolder(folder);
                ImportTraceWizardPageOptions.this.setErrorMessage(null);
            }
        });
        if (proj != null) {
            this.fProjects.setSelection(this.fProjects.indexOf(proj.getName()));
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(Messages.SharedSelectProject);
        }
        this.setTitle(Messages.ImportTraceWizardPageOptionsTitle);
    }
}

