/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;

public class TmfProjectRegistry {
    private static Map<IProject, TmfProjectElement> registry = new HashMap<IProject, TmfProjectElement>();

    public static synchronized TmfProjectElement getProject(IProject project) {
        return TmfProjectRegistry.getProject(project, false);
    }

    public static synchronized TmfProjectElement getProject(IProject project, boolean force) {
        TmfProjectElement element = registry.get(project);
        if (element == null && force) {
            registry.put(project, new TmfProjectElement(project.getName(), project, null));
            element = registry.get(project);
        }
        return element;
    }

    public static IProject createProject(String projectName, URI projectLocation, IProgressMonitor monitor) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(projectName);
        try {
            IProjectDescription description;
            if (!project.exists()) {
                description = workspace.newProjectDescription(project.getName());
                if (projectLocation != null) {
                    description.setLocationURI(projectLocation);
                }
                project.create(description, monitor);
            }
            if (!project.isOpen()) {
                project.open(monitor);
            }
            description = project.getDescription();
            description.setNatureIds(new String[]{"org.eclipse.linuxtools.tmf.project.nature"});
            project.setDescription(description, null);
            IFolder folder = project.getFolder("Traces");
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            if (!(folder = project.getFolder("Experiments")).exists()) {
                folder.create(true, true, null);
            }
            if (!(folder = project.getFolder(".tracing")).exists()) {
                folder.create(true, true, null);
            }
            return project;
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error creating TMF project " + project.getName(), e);
            return null;
        }
    }
}

