/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.launch;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMEvent;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.DelayedStackRefreshUpdatePolicy;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.ExpandStackEvent;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.FullStackRefreshEvent;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.LaunchRootVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.StackFramesVMNode;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.cdt.dsf.ui.viewmodel.IRootVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.update.AutomaticUpdatePolicy;
import org.eclipse.cdt.dsf.ui.viewmodel.update.IVMUpdatePolicy;
import org.eclipse.cdt.dsf.ui.viewmodel.update.ManualUpdatePolicy;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class AbstractLaunchVMProvider
extends AbstractDMVMProvider
implements IDebugEventSetListener,
ILaunchesListener2 {
    private static final int FRAME_UPDATE_DELAY = 200;
    private final Map<IRunControl.IExecutionDMContext, ScheduledFuture<?>> fRefreshStackFramesFutures = new HashMap();
    private IPropertyChangeListener fPreferencesListener;

    @ThreadSafe
    public AbstractLaunchVMProvider(AbstractVMAdapter adapter, IPresentationContext presentationContext, DsfSession session) {
        super(adapter, presentationContext, session);
        final IPreferenceStore store = DsfUIPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("stackFrameLimitEnable")) {
            this.getPresentationContext().setProperty("stackFrameLimit", (Object)store.getInt("stackFrameLimit"));
        }
        this.fPreferencesListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                AbstractLaunchVMProvider.this.handlePropertyChanged(store, event);
            }
        };
        store.addPropertyChangeListener(this.fPreferencesListener);
        IPreferenceStore cStore = CDebugUIPlugin.getDefault().getPreferenceStore();
        this.getPresentationContext().setProperty("org.eclipse.debug.ui.DebugView.org.eclipse.cdt.debug.ui.cDebug.show_full_paths", (Object)cStore.getBoolean("org.eclipse.debug.ui.DebugView.org.eclipse.cdt.debug.ui.cDebug.show_full_paths"));
        cStore.addPropertyChangeListener(this.fPreferencesListener);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    @Override
    protected IVMUpdatePolicy[] createUpdateModes() {
        return new IVMUpdatePolicy[]{new DelayedStackRefreshUpdatePolicy(new AutomaticUpdatePolicy()), new DelayedStackRefreshUpdatePolicy(new ManualUpdatePolicy())};
    }

    public void handleDebugEvents(final DebugEvent[] events) {
        if (this.isDisposed()) {
            return;
        }
        try {
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    if (AbstractLaunchVMProvider.this.isDisposed()) {
                        return;
                    }
                    DebugEvent[] debugEventArray = events;
                    int n = events.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DebugEvent event = debugEventArray[n2];
                        AbstractLaunchVMProvider.this.handleEvent(event);
                        ++n2;
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
    }

    @Override
    public void handleEvent(Object event, RequestMonitor rm) {
        IRunControl.IExecutionDMContext exeContext;
        ScheduledFuture<?> refreshStackFramesFuture;
        if (event instanceof DoubleClickEvent && !this.isDisposed()) {
            Object element;
            ISelection selection = ((DoubleClickEvent)event).getSelection();
            if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof StackFramesVMNode.IncompleteStackVMContext) {
                StackFramesVMNode.IncompleteStackVMContext incStackVmc = (StackFramesVMNode.IncompleteStackVMContext)element;
                IVMNode node = incStackVmc.getVMNode();
                if (node instanceof StackFramesVMNode && node.getVMProvider() == this) {
                    IRunControl.IExecutionDMContext exeCtx = incStackVmc.getExecutionDMContext();
                    ((StackFramesVMNode)node).incrementStackFrameLimit(exeCtx);
                    final ExpandStackEvent expandStackEvent = new ExpandStackEvent(exeCtx);
                    this.getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            AbstractLaunchVMProvider.this.handleEvent((Object)expandStackEvent, null);
                        }
                    });
                }
                if (rm != null) {
                    rm.done();
                }
                return;
            }
        } else if (event instanceof IRunControl.ISuspendedDMEvent) {
            final IRunControl.IExecutionDMContext exeContext2 = (IRunControl.IExecutionDMContext)((IRunControl.ISuspendedDMEvent)event).getDMContext();
            ScheduledFuture refreshStackFramesFuture2 = this.getRefreshFuture(exeContext2);
            if (refreshStackFramesFuture2 != null) {
                refreshStackFramesFuture2.cancel(false);
            }
            try {
                refreshStackFramesFuture2 = this.getSession().getExecutor().schedule((Runnable)new DsfRunnable(){

                    public void run() {
                        if (AbstractLaunchVMProvider.this.getSession().isActive()) {
                            AbstractLaunchVMProvider.this.getExecutor().execute(new Runnable(){

                                @Override
                                public void run() {
                                    ScheduledFuture future = (ScheduledFuture)AbstractLaunchVMProvider.this.fRefreshStackFramesFutures.get(exeContext2);
                                    if (future != null && !AbstractLaunchVMProvider.this.isDisposed()) {
                                        AbstractLaunchVMProvider.this.fRefreshStackFramesFutures.remove(exeContext2);
                                        AbstractLaunchVMProvider.this.handleEvent((Object)new FullStackRefreshEvent(exeContext2), null);
                                    }
                                }
                            });
                        }
                    }
                }, 200L, TimeUnit.MILLISECONDS);
                this.fRefreshStackFramesFutures.put(exeContext2, refreshStackFramesFuture2);
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
        } else if (event instanceof IRunControl.IResumedDMEvent && (refreshStackFramesFuture = this.fRefreshStackFramesFutures.get(exeContext = (IRunControl.IExecutionDMContext)((IRunControl.IResumedDMEvent)event).getDMContext())) != null) {
            refreshStackFramesFuture.cancel(false);
            this.fRefreshStackFramesFutures.remove(exeContext);
        }
        super.handleEvent(event, rm);
    }

    private ScheduledFuture<?> getRefreshFuture(IRunControl.IExecutionDMContext execCtx) {
        for (IRunControl.IExecutionDMContext refreshCtx : this.fRefreshStackFramesFutures.keySet()) {
            if (!refreshCtx.equals(execCtx) && !DMContexts.isAncestorOf((IDMContext)refreshCtx, (IDMContext)execCtx)) continue;
            return this.fRefreshStackFramesFutures.remove(refreshCtx);
        }
        return null;
    }

    @Override
    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        IPreferenceStore store = DsfUIPlugin.getDefault().getPreferenceStore();
        store.removePropertyChangeListener(this.fPreferencesListener);
        IPreferenceStore cStore = CDebugUIPlugin.getDefault().getPreferenceStore();
        cStore.removePropertyChangeListener(this.fPreferencesListener);
        super.dispose();
    }

    public void launchesAdded(ILaunch[] launches) {
        this.handleLaunchesEvent(new LaunchRootVMNode.LaunchesEvent(launches, LaunchRootVMNode.LaunchesEvent.Type.ADDED));
    }

    public void launchesRemoved(ILaunch[] launches) {
        this.handleLaunchesEvent(new LaunchRootVMNode.LaunchesEvent(launches, LaunchRootVMNode.LaunchesEvent.Type.REMOVED));
    }

    public void launchesChanged(ILaunch[] launches) {
        this.handleLaunchesEvent(new LaunchRootVMNode.LaunchesEvent(launches, LaunchRootVMNode.LaunchesEvent.Type.CHANGED));
    }

    public void launchesTerminated(ILaunch[] launches) {
        this.handleLaunchesEvent(new LaunchRootVMNode.LaunchesEvent(launches, LaunchRootVMNode.LaunchesEvent.Type.TERMINATED));
    }

    private void handleLaunchesEvent(final LaunchRootVMNode.LaunchesEvent event) {
        if (this.isDisposed()) {
            return;
        }
        try {
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    if (AbstractLaunchVMProvider.this.isDisposed()) {
                        return;
                    }
                    IRootVMNode rootLayoutNode = AbstractLaunchVMProvider.this.getRootVMNode();
                    if (rootLayoutNode != null && rootLayoutNode.getDeltaFlags(event) != 0) {
                        AbstractLaunchVMProvider.this.handleEvent(event);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
    }

    @Override
    protected boolean canSkipHandlingEvent(Object newEvent, Object eventToSkip) {
        IDMContext eventToSkipDmc;
        IDMContext newEventDmc;
        if (newEvent instanceof IRunControl.IStartedDMEvent || newEvent instanceof IRunControl.IExitedDMEvent) {
            return false;
        }
        return newEvent instanceof IRunControl.ISuspendedDMEvent && eventToSkip instanceof IDMEvent && ((newEventDmc = ((IDMEvent)newEvent).getDMContext()).equals(eventToSkipDmc = ((IDMEvent)eventToSkip).getDMContext()) || DMContexts.isAncestorOf((IDMContext)eventToSkipDmc, (IDMContext)newEventDmc));
    }

    protected void handlePropertyChanged(IPreferenceStore store, final PropertyChangeEvent event) {
        String property = event.getProperty();
        boolean processEvent = false;
        if ("stackFrameLimitEnable".equals(property) || "stackFrameLimit".equals(property)) {
            if (store.getBoolean("stackFrameLimitEnable")) {
                this.getPresentationContext().setProperty("stackFrameLimit", (Object)store.getInt("stackFrameLimit"));
            } else {
                this.getPresentationContext().setProperty("stackFrameLimit", null);
            }
            processEvent = true;
        } else if ("org.eclipse.debug.ui.DebugView.org.eclipse.cdt.debug.ui.cDebug.show_full_paths".equals(property)) {
            this.getPresentationContext().setProperty("org.eclipse.debug.ui.DebugView.org.eclipse.cdt.debug.ui.cDebug.show_full_paths", event.getNewValue());
            processEvent = true;
        }
        if (processEvent) {
            this.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    AbstractLaunchVMProvider.this.handleEvent(event);
                }
            });
        }
    }
}

