/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions;

import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.breakpoints.IToggleBreakpointsTargetCExtension;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyMessages;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions.AbstractDisassemblyBreakpointRulerAction;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.IDisassemblyPart;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class AddBreakpointRulerAction
extends AbstractDisassemblyBreakpointRulerAction {
    protected AddBreakpointRulerAction(IDisassemblyPart disassemblyPart, IVerticalRulerInfo rulerInfo) {
        super(disassemblyPart, rulerInfo);
        this.setText(String.valueOf(DisassemblyMessages.Disassembly_action_AddBreakpoint_label) + "\t" + CDebugUIUtils.formatKeyBindingString((int)SWT.MOD1, (String)DisassemblyMessages.Disassembly_action_ToggleBreakpoint_accelerator));
    }

    @Override
    public void run() {
        IDisassemblyPart part = this.getDisassemblyPart();
        ISelection selection = this.getSelection();
        IToggleBreakpointsTargetCExtension toggleTarget = this.getToggleTarget(selection);
        if (toggleTarget != null) {
            try {
                if (toggleTarget.canCreateLineBreakpointsInteractive((IWorkbenchPart)part, selection)) {
                    toggleTarget.createLineBreakpointsInteractive((IWorkbenchPart)part, selection);
                }
            }
            catch (CoreException e) {
                this.reportException((Exception)((Object)e));
            }
        }
    }

    @Override
    public void update() {
        ISelection selection;
        IToggleBreakpointsTargetCExtension toggleTarget;
        IDisassemblyPart part = this.getDisassemblyPart();
        if (part != null && part.isConnected() && (toggleTarget = this.getToggleTarget(selection = this.getSelection())) != null) {
            this.setEnabled(toggleTarget.canCreateLineBreakpointsInteractive((IWorkbenchPart)part, selection));
            return;
        }
        this.setEnabled(false);
    }

    private IToggleBreakpointsTargetCExtension getToggleTarget(ISelection selection) {
        IToggleBreakpointsTargetManager toggleMgr = DebugUITools.getToggleBreakpointsTargetManager();
        IToggleBreakpointsTarget toggleTarget = toggleMgr.getToggleBreakpointsTarget((IWorkbenchPart)this.getDisassemblyPart(), selection);
        if (toggleTarget instanceof IToggleBreakpointsTargetCExtension) {
            return (IToggleBreakpointsTargetCExtension)toggleTarget;
        }
        return null;
    }

    private void reportException(Exception e) {
        Status status = new Status(4, "org.eclipse.cdt.debug.ui", "Error creating breakpoint: ", (Throwable)e);
        ErrorDialog.openError((Shell)this.getDisassemblyPart().getSite().getShell(), (String)ActionMessages.getString((String)"DisassemblyMessages.Disassembly_action_AddBreakpoint_errorTitle"), (String)ActionMessages.getString((String)"DisassemblyMessages.Disassembly_action_AddBreakpoint_errorMessage"), (IStatus)status);
        CDebugUIPlugin.log((IStatus)status);
    }

    private ISelection getSelection() {
        IDocument document = this.getDocument();
        if (document != null) {
            int line = this.getRulerInfo().getLineOfLastMouseButtonActivity();
            try {
                ISelection selection;
                IRegion region = this.getDocument().getLineInformation(line);
                TextSelection textSelection = new TextSelection(document, region.getOffset(), 0);
                ISelectionProvider provider = this.getDisassemblyPart().getSite().getSelectionProvider();
                if (provider != null && (selection = provider.getSelection()) instanceof ITextSelection && ((ITextSelection)selection).getStartLine() <= line && ((ITextSelection)selection).getEndLine() >= line) {
                    textSelection = (ITextSelection)selection;
                }
                return textSelection;
            }
            catch (BadLocationException badLocationException) {}
        }
        return StructuredSelection.EMPTY;
    }
}

