/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.credentials;

import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class LoginDialog
extends Dialog {
    private Text user;
    private Text password;
    private Button storeCheckbox;
    private UserPasswordCredentials credentials;
    private boolean storeInSecureStore;
    private final URIish uri;
    private boolean isUserSet;
    private boolean changeCredentials = false;
    private String oldUser;

    LoginDialog(Shell shell, URIish uri) {
        super(shell);
        this.uri = uri;
        this.isUserSet = uri.getUser() != null && uri.getUser().length() > 0;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.getShell().setText(this.changeCredentials ? UIText.LoginDialog_changeCredentials : UIText.LoginDialog_login);
        Label uriLabel = new Label(composite, 0);
        uriLabel.setText(UIText.LoginDialog_repository);
        Text uriText = new Text(composite, 8);
        uriText.setText(this.uri.toString());
        Label userLabel = new Label(composite, 0);
        userLabel.setText(UIText.LoginDialog_user);
        if (this.isUserSet) {
            this.user = new Text(composite, 2056);
            this.user.setText(this.uri.getUser());
        } else {
            this.user = new Text(composite, 2048);
            if (this.oldUser != null) {
                this.user.setText(this.oldUser);
            }
        }
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.user);
        Label passwordLabel = new Label(composite, 0);
        passwordLabel.setText(UIText.LoginDialog_password);
        this.password = new Text(composite, 0x400800);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.password);
        if (!this.changeCredentials) {
            Label storeLabel = new Label(composite, 0);
            storeLabel.setText(UIText.LoginDialog_storeInSecureStore);
            this.storeCheckbox = new Button(composite, 32);
            this.storeCheckbox.setSelection(true);
        }
        if (this.isUserSet) {
            this.password.setFocus();
        } else {
            this.user.setFocus();
        }
        return composite;
    }

    UserPasswordCredentials getCredentials() {
        return this.credentials;
    }

    boolean getStoreInSecureStore() {
        return this.storeInSecureStore;
    }

    protected void okPressed() {
        if (this.user.getText().length() > 0) {
            this.credentials = new UserPasswordCredentials(this.user.getText(), this.password.getText());
            if (!this.changeCredentials) {
                this.storeInSecureStore = this.storeCheckbox.getSelection();
            }
        }
        super.okPressed();
    }

    void setChangeCredentials(boolean changeCredentials) {
        this.changeCredentials = changeCredentials;
    }

    public void setOldUser(String oldUser) {
        this.oldUser = oldUser;
    }
}

