/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.view;

import java.text.NumberFormat;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTDataViewersField;
import org.eclipse.linuxtools.internal.gcov.model.TreeElement;

public class FieldTotalLines
extends AbstractSTDataViewersField {
    public String getColumnHeaderText() {
        return "Total Lines";
    }

    private int getTotalLines(Object element) {
        if (element instanceof TreeElement) {
            return ((TreeElement)element).getTotalLines();
        }
        return -1;
    }

    public String getValue(Object obj) {
        int v = this.getTotalLines(obj);
        if (v < 0) {
            return "";
        }
        return NumberFormat.getInstance().format(v);
    }

    public String getToolTipText(Object element) {
        int v = this.getTotalLines(element);
        if (v < 0) {
            return null;
        }
        String s = NumberFormat.getInstance().format(v);
        s = String.valueOf(s) + " line";
        if (v > 1) {
            s = String.valueOf(s) + "s";
        }
        s = String.valueOf(s) + " in total";
        return s;
    }

    public int compare(Object obj1, Object obj2) {
        int i2;
        int i1 = this.getTotalLines(obj1);
        if (i1 > (i2 = this.getTotalLines(obj2))) {
            return 1;
        }
        if (i1 < i2) {
            return -1;
        }
        return 0;
    }
}

