/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.parser;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.gcov.parser.Arc;
import org.eclipse.linuxtools.internal.gcov.parser.Block;
import org.eclipse.linuxtools.internal.gcov.parser.GcnoFunction;
import org.eclipse.linuxtools.internal.gcov.parser.SourceFile;
import org.eclipse.linuxtools.internal.gcov.utils.BEDataInputStream;
import org.eclipse.linuxtools.internal.gcov.utils.GcovStringReader;
import org.eclipse.linuxtools.internal.gcov.utils.LEDataInputStream;

public class GcnoRecordsParser {
    private static final int GCOV_NOTE_MAGIC = 1734569583;
    private static final int GCOV_TAG_FUNCTION = 0x1000000;
    private static final int GCOV_TAG_BLOCKS = 0x1410000;
    private static final int GCOV_TAG_ARCS = 21168128;
    private static final int GCOV_TAG_LINES = 21299200;
    private GcnoFunction fnctn = null;
    private final ArrayList<GcnoFunction> fnctns = new ArrayList();
    private final ArrayList<SourceFile> currentAllSrcs;
    private final HashMap<String, SourceFile> sourceMap;

    public GcnoRecordsParser(HashMap<String, SourceFile> sourceMap, ArrayList<SourceFile> AllSrcs) {
        this.sourceMap = sourceMap;
        this.currentAllSrcs = AllSrcs;
    }

    private SourceFile findOrAdd(String fileName, ArrayList<SourceFile> srcs) {
        SourceFile newsrc = this.sourceMap.get(fileName);
        if (newsrc == null) {
            newsrc = new SourceFile(fileName, srcs.size() + 1);
            srcs.add(newsrc);
            this.sourceMap.put(fileName, newsrc);
        }
        return newsrc;
    }

    public void parseData(DataInput stream) throws IOException, CoreException {
        int magic = 0;
        ArrayList<Block> blocks = null;
        SourceFile source = null;
        boolean parseFirstFnctn = false;
        magic = stream.readInt();
        if (magic == 1734569583) {
            stream = new BEDataInputStream((DataInputStream)stream);
        } else {
            magic = magic >> 16 | magic << 16;
            if ((magic = (magic & 0xFF00FF) << 8 | magic >> 8 & 0xFF00FF) == 1734569583) {
                stream = new LEDataInputStream((DataInputStream)stream);
            } else {
                String message = String.valueOf(magic) + " :desn't correspond to a correct note file header\n";
                Status status = new Status(4, "org.eclipse.linuxtools.gcov.core", message);
                throw new CoreException((IStatus)status);
            }
        }
        int version = stream.readInt();
        stream.readInt();
        try {
            while (true) {
                int tag;
                if ((tag = stream.readInt()) != 0x1000000 && tag != 0x1410000 && tag != 21168128 && tag != 21299200) {
                    continue;
                }
                int length = stream.readInt();
                if (tag == 0x1000000) {
                    if (parseFirstFnctn) {
                        this.fnctns.add(this.fnctn);
                    }
                    long fnctnIdent = (long)stream.readInt() & 0xFFFFFFFFL;
                    long fnctnChksm = (long)stream.readInt() & 0xFFFFFFFFL;
                    if (version >= 875575082) {
                        stream.readInt();
                    }
                    String fnctnName = GcovStringReader.readString(stream);
                    String fnctnSrcFle = GcovStringReader.readString(stream);
                    long fnctnFrstLnNmbr = (long)stream.readInt() & 0xFFFFFFFFL;
                    this.fnctn = new GcnoFunction(fnctnIdent, fnctnChksm, fnctnName, fnctnSrcFle, fnctnFrstLnNmbr);
                    SourceFile srcFle2 = this.findOrAdd(this.fnctn.getSrcFile(), this.currentAllSrcs);
                    if (this.fnctn.getFirstLineNmbr() >= (long)srcFle2.getNumLines()) {
                        srcFle2.setNumLines((int)this.fnctn.getFirstLineNmbr() + 1);
                    }
                    srcFle2.addFnctn(this.fnctn);
                    parseFirstFnctn = true;
                    continue;
                }
                if (tag == 0x1410000) {
                    blocks = new ArrayList<Block>();
                    int i = 0;
                    while (i < length) {
                        long BlckFlag = (long)stream.readInt() & 0xFFFFFFFFL;
                        Block blck = new Block(BlckFlag);
                        blocks.add(blck);
                        ++i;
                    }
                    this.fnctn.setNumBlocks(length);
                    continue;
                }
                if (tag == 21168128) {
                    int srcBlockIndice = stream.readInt();
                    int nmbrArcs = (length - 1) / 2;
                    ArrayList<Arc> arcs = new ArrayList<Arc>(nmbrArcs);
                    int i = 0;
                    while (i < nmbrArcs) {
                        int dstnatnBlockIndice = stream.readInt();
                        long flag = (long)stream.readInt() & 0xFFFFFFFFL;
                        Arc arc = new Arc(srcBlockIndice, dstnatnBlockIndice, flag, blocks);
                        arcs.add(arc);
                        ++i;
                    }
                    Block srcBlk = (Block)blocks.get(srcBlockIndice);
                    for (Arc a : arcs) {
                        srcBlk.addExitArcs(a);
                        srcBlk.incNumSuccs();
                    }
                    for (Arc a : arcs) {
                        Block dstntnBlk = a.getDstnatnBlock();
                        dstntnBlk.addEntryArcs(a);
                        dstntnBlk.incNumPreds();
                    }
                    for (Arc a : arcs) {
                        if (a.isFake()) {
                            if (a.getSrcBlock() != null) {
                                srcBlk = blocks.get(srcBlockIndice);
                                srcBlk.setCallSite(true);
                                a.setCallNonReturn(true);
                            } else {
                                a.setNonLoclaReturn(true);
                                Block dstntnBlk = a.getDstnatnBlock();
                                dstntnBlk.setNonLocalReturn(true);
                            }
                        }
                        if (a.isOnTree()) continue;
                        this.fnctn.incNumCounts();
                    }
                    this.fnctn.setFunctionBlocks(blocks);
                    continue;
                }
                if (tag != 21299200) continue;
                int numBlock = stream.readInt();
                long[] lineNos = new long[length - 1];
                int ix = 0;
                while (true) {
                    long lineNumber;
                    if ((lineNumber = (long)stream.readInt() & 0xFFFFFFFFL) != 0L) {
                        if (ix == 0) {
                            lineNos[ix++] = 0L;
                            lineNos[ix++] = source.getIndex();
                        }
                        lineNos[ix++] = lineNumber;
                        if (lineNumber < (long)source.getNumLines()) continue;
                        source.setNumLines((int)lineNumber + 1);
                        continue;
                    }
                    String fileName = GcovStringReader.readString(stream);
                    if (fileName == "NULL string") break;
                    source = this.findOrAdd(fileName, this.currentAllSrcs);
                    lineNos[ix++] = 0L;
                    lineNos[ix++] = source.getIndex();
                }
                this.fnctn.getFunctionBlocks().get(numBlock).setEncoding(lineNos);
                this.fnctn.getFunctionBlocks().get(numBlock).setNumLine(ix);
            }
        }
        catch (EOFException eOFException) {
            this.fnctn.setFunctionBlocks(blocks);
            this.fnctns.add(this.fnctn);
            return;
        }
    }

    public ArrayList<GcnoFunction> getFnctns() {
        return this.fnctns;
    }

    public ArrayList<SourceFile> getcurrentAllSrcs() {
        return this.currentAllSrcs;
    }
}

