/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.ui.model;

import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelImage;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelSession;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiMessages;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.oprofile.ui.model.IUiModelElement;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelDependent;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelImage;
import org.eclipse.swt.graphics.Image;

public class UiModelSession
implements IUiModelElement {
    private IUiModelElement parent;
    private OpModelSession session;
    private UiModelImage image;
    private UiModelDependent dependent;
    private static final String DEFAULT_SESSION_NAME = "current";

    public UiModelSession(IUiModelElement parent, OpModelSession session) {
        this.parent = parent;
        this.session = session;
        this.image = null;
        this.dependent = null;
        this.refreshModel();
    }

    private void refreshModel() {
        OpModelImage dataModelImage = this.session.getImage();
        if (dataModelImage != null) {
            this.image = new UiModelImage(this, dataModelImage, dataModelImage.getCount(), dataModelImage.getDepCount());
            if (dataModelImage.hasDependents()) {
                this.dependent = new UiModelDependent(this, dataModelImage.getDependents(), dataModelImage.getCount(), dataModelImage.getDepCount());
            }
        }
    }

    public String toString() {
        return this.session.getName();
    }

    public boolean isDefaultSession() {
        return this.session.getName().equalsIgnoreCase(DEFAULT_SESSION_NAME);
    }

    public String getLabelText() {
        if (this.session.getName().equals(DEFAULT_SESSION_NAME)) {
            return OprofileUiMessages.getString("UiModelSession_current");
        }
        return this.toString();
    }

    public IUiModelElement[] getChildren() {
        if (this.dependent != null) {
            return new IUiModelElement[]{this.image, this.dependent};
        }
        return new IUiModelElement[]{this.image};
    }

    public boolean hasChildren() {
        return this.image != null;
    }

    public IUiModelElement getParent() {
        return this.parent;
    }

    public Image getLabelImage() {
        return OprofileUiPlugin.getImageDescriptor("icons/session.gif").createImage();
    }
}

